/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaAssetCardIscOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption option = this.getOption();
        boolean op4Isc = option.containsVariable("op_from_isc");
        if (!op4Isc) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean needRelation = option.containsVariable("need_relation");
        if (needRelation) {
            Map<Long, Long> cardId2VoucherId = Arrays.stream(dataEntities).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("masterid")));
            this.createRelation(cardId2VoucherId);
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("masterid", (Object)dataEntity.getLong("id"));
            }
        }
        Set orgIds = Arrays.stream(dataEntities).map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toSet());
        Map assetBook4Load = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "org", "depreuse", "basecurrency"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)Boolean.TRUE)});
        Map<Long, DynamicObject> orgId2AssetBook = assetBook4Load.values().stream().collect(Collectors.toMap(k -> k.getLong(Fa.id((String)"org")), v -> v));
        ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(dataEntities.length);
        MainEntityType finCardType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        for (DynamicObject card : dataEntities) {
            DynamicObject finCard = this.genFinCardAndUpdateFinEntry(orgId2AssetBook, finCardType, card);
            finCards.add(finCard);
        }
        SaveServiceHelper.save((DynamicObject[])finCards.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private DynamicObject genFinCardAndUpdateFinEntry(Map<Long, DynamicObject> orgId2AssetBook, MainEntityType finCardType, DynamicObject card) {
        DynamicObjectCollection finEntity = card.getDynamicObjectCollection("finentry");
        DynamicObject finEntry = (DynamicObject)finEntity.get(0);
        DataEntityPropertyCollection assetEntryProps = finEntry.getDynamicObjectType().getProperties();
        DynamicObject finCard = (DynamicObject)finCardType.createInstance();
        for (IDataEntityProperty importProp : assetEntryProps) {
            String importPropName = importProp.getName();
            if (!importPropName.contains("fin_")) continue;
            String[] finFieldSplit = importPropName.split("fin_");
            String finField = finFieldSplit[finFieldSplit.length - 1];
            if (importProp instanceof BasedataProp) {
                finCard.set(finField + "_id", (Object)finEntry.getLong(importPropName + ".id"));
                finCard.set(finField, (Object)finEntry.getDynamicObject(importPropName));
                continue;
            }
            if (importProp instanceof DateProp) {
                finCard.set(finField, (Object)finEntry.getDate(importPropName));
                continue;
            }
            if (importProp instanceof IntegerProp) {
                finCard.set(finField, (Object)finEntry.getInt(importPropName));
                continue;
            }
            if (importProp instanceof DecimalProp) {
                finCard.set(finField, (Object)finEntry.getBigDecimal(importPropName));
                continue;
            }
            if (importProp instanceof BooleanProp) {
                finCard.set(finField, (Object)finEntry.getBoolean(importPropName));
                continue;
            }
            if (importProp instanceof LongProp) {
                finCard.set(finField, (Object)finEntry.getLong(importPropName));
                continue;
            }
            finCard.set(finField, (Object)finEntry.getString(importPropName));
        }
        DynamicObject org = card.getDynamicObject("org");
        long orgId = org.getLong("id");
        DynamicObject assetBook = orgId2AssetBook.get(orgId);
        finCard.set("id", card.getPkValue());
        finCard.set("realcard", (Object)card);
        finCard.set(Fa.id((String)"realcard"), card.getPkValue());
        finCard.set("realcardmasterid", (Object)card.getLong("masterid"));
        finCard.set("org", (Object)card.getDynamicObject("org"));
        finCard.set("billno", card.get("billno"));
        finCard.set("number", card.get("number"));
        finCard.set("assetbook", (Object)assetBook);
        finCard.set("depreuse", (Object)assetBook.getDynamicObject("depreuse"));
        finCard.set("billstatus", (Object)BillStatus.C);
        finCard.set("creator", (Object)"creator");
        finCard.set("modifier", (Object)"modifier");
        finCard.set("auditor", (Object)"auditor");
        finCard.set("createtime", (Object)card.getDate("createtime"));
        finCard.set("modifytime", (Object)card.getDate("modifytime"));
        finCard.set("auditdate", (Object)card.getDate("auditdate"));
        finCard.set("depredept", (Object)card.getDynamicObject("headusedept"));
        finCard.set("assetcat", (Object)card.getDynamicObject("assetcat"));
        finCard.set("basecurrency", (Object)assetBook.getDynamicObject("basecurrency"));
        finCard.set(Fa.id((String)"basecurrency"), (Object)assetBook.getLong(Fa.id((String)"basecurrency")));
        finCard.set("hasvoucher", (Object)Boolean.TRUE);
        if (card.getBoolean("initialcard")) {
            finCard.set(Fa.id((String)"period"), (Object)0L);
        }
        finEntry.set("fincard", (Object)finCard);
        finEntry.set(Fa.id((String)"fincard"), (Object)finCard.getLong("id"));
        return finCard;
    }

    private void createRelation(Map<Long, Long> cardId2VoucherId) {
        DBRoute dbRouteFa = DBRoute.of((String)"fa");
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        Long finCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_fin", (String)"fa_card_fin").getTableId();
        try (TXHandle h0 = TX.requiresNew();){
            try {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("delete from t_botp_billtracker where ", new Object[0]);
                sqlBuilder.append("fstableid = ?", new Object[]{realCardTableId});
                sqlBuilder.append(" and fttableid = ?", new Object[]{finCardTableId});
                sqlBuilder.appendIn(" and ftbillid ", cardId2VoucherId.keySet().toArray());
                DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
            }
            catch (Exception e) {
                h0.markRollback();
                throw e;
            }
        }
        long[] ids = DB.genGlobalLongIds((int)(cardId2VoucherId.size() * 4));
        int idIndex = 0;
        ArrayList<Object[]> paramsOfLk = new ArrayList<Object[]>(cardId2VoucherId.size());
        ArrayList<Object[]> paramsOfTc = new ArrayList<Object[]>(cardId2VoucherId.size());
        ArrayList<Object[]> paramsOfBillTracker = new ArrayList<Object[]>(cardId2VoucherId.size());
        ArrayList<Object[]> paramsOfDapTracker = new ArrayList<Object[]>(cardId2VoucherId.size());
        for (Map.Entry<Long, Long> map : cardId2VoucherId.entrySet()) {
            Long cardId = map.getKey();
            Long voucherId = map.getValue();
            paramsOfLk.add(new Object[]{cardId, ids[idIndex++], 1, realCardTableId, cardId, cardId});
            paramsOfTc.add(new Object[]{ids[idIndex++], cardId, finCardTableId, cardId, cardId, realCardTableId, cardId});
            paramsOfBillTracker.add(new Object[]{ids[idIndex++], realCardTableId, cardId, finCardTableId, cardId});
            paramsOfDapTracker.add(new Object[]{ids[idIndex++], voucherId, "fa_card_fin", cardId});
        }
        String insertLk = "INSERT INTO t_fa_card_fin_lk (fid, fpkid, fseq, fstableid, fsbillid, fsid) VALUES(?, ?, ?, ?, ?, ?);";
        String insertTc = "INSERT INTO t_fa_card_fin_tc (fid, ftbillid, fttableid, ftid, fsbillid, fstableid, fsid) VALUES(?, ?, ?, ?, ?, ?, ?);";
        String insertBillTracker = "INSERT INTO t_botp_billtracker (fid, fstableid, fsbillid, fttableid, ftbillid) VALUES(?, ?, ?, ?, ?);";
        String insertDapTracker = "INSERT INTO t_ai_daptracker (fid, fvoucherid, fbilltype, fsourcebillid) VALUES(?, ?, ?, ?);";
        try (TXHandle h1 = TX.required();){
            try {
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertLk, paramsOfLk);
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertTc, paramsOfTc);
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertDapTracker, paramsOfDapTracker);
                try (TXHandle h2 = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertBillTracker, paramsOfBillTracker);
                    }
                    catch (Exception e2) {
                        h2.markRollback();
                        throw e2;
                    }
                }
            }
            catch (Exception e1) {
                h1.markRollback();
                throw e1;
            }
        }
    }
}

