/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.change.ChangeTypeItem;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaUserUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class BizBillToChangeBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final String MAIN_BOOK_TRG = "m";
    private static final String OTHER_BOOK_TRG = "o";

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        String srcName = this.getSrcMainType().getName();
        if ("fa_change_apply".equals(srcName)) {
            e.addSrcField("auditdate");
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String srcName = this.getSrcMainType().getName();
        if ("fa_change_apply".equals(srcName)) {
            ExtendedDataEntity[] billDataEntitys;
            for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("fa_change_dept")) {
                List srcRows = (List)billDataEntity.getValue("ConvertSource");
                DynamicObject srcRow = (DynamicObject)srcRows.get(0);
                Object auditDate = ((DynamicProperty)e.getFldProperties().get("auditdate")).getValue((Object)srcRow);
                billDataEntity.setValue("changedate", auditDate);
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        List extendedDataEntities = (List)targetExtDataEntitySet.getExtDataEntityMap().get("fa_change_dept");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject[] curPeriodList;
            DynamicObject changeBill = extendedDataEntity.getDataEntity();
            DynamicObject changeType = changeBill.getDynamicObject("changetype");
            DynamicObject org = changeBill.getDynamicObject("org");
            DynamicObjectCollection mainChangeBillEntry = changeBill.getDynamicObjectCollection("main_changebillentry");
            if (changeType == null || org == null || mainChangeBillEntry.isEmpty()) continue;
            HashSet<Long> realCardIds = new HashSet<Long>(FaUtils.getInitialCapacity43((int)mainChangeBillEntry.size()));
            for (DynamicObject mainChangeBill : mainChangeBillEntry) {
                DynamicObject realCard = mainChangeBill.getDynamicObject("m_realcard");
                if (realCard == null) continue;
                realCardIds.add(realCard.getLong("masterid"));
            }
            Map realCardMap = BusinessDataServiceHelper.loadFromCache((Object[])realCardIds.toArray(), (String)"fa_card_real");
            Collection assetBooks = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue())}).values();
            Set<DynamicObject> changeItems = this.processChangeItem(changeBill, changeType);
            Map allChangeTypeItems = FaChangeBillUtil.getAllChangeTypeItems(changeItems);
            List changeTypeItems = (List)allChangeTypeItems.get("main_changebillentry");
            HashMap<String, List<DynamicObject>> bookMap = new HashMap<String, List<DynamicObject>>(2);
            for (DynamicObject assetBook : assetBooks) {
                boolean isMainBook = assetBook.getBoolean("ismainbook");
                if (isMainBook) {
                    bookMap.computeIfAbsent(MAIN_BOOK_TRG, v -> new ArrayList(2)).add(assetBook);
                    this.processChangeDate(changeBill, assetBook);
                    continue;
                }
                bookMap.computeIfAbsent(OTHER_BOOK_TRG, v -> new ArrayList(2)).add(assetBook);
            }
            Set curPeriodIds = assetBooks.stream().map(v -> v.getLong(Fa.id((String)"curperiod"))).collect(Collectors.toSet());
            Object[] depreSystemIds = assetBooks.stream().map(v -> v.get(Fa.id((String)"depresystem"))).distinct().toArray();
            Map assetPolicyInfoList = AssetPolicyUtil.getAssetPolicyInfoByDepreSystemIds((Object[])depreSystemIds);
            HashMap<Long, DynamicObject> curPeriodId2PeriodMap = new HashMap<Long, DynamicObject>(curPeriodIds.size());
            HashMap<Long, DynamicObject> nextPeriodId2PeriodMap = new HashMap<Long, DynamicObject>(curPeriodIds.size());
            for (DynamicObject curPeriod : curPeriodList = BusinessDataServiceHelper.load((Object[])curPeriodIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_period"))) {
                curPeriodId2PeriodMap.put(curPeriod.getLong("id"), curPeriod);
                DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriodByDo((DynamicObject)curPeriod, (int)1);
                nextPeriodId2PeriodMap.put(curPeriod.getLong("id"), nextPeriod);
            }
            Map finCardMap = FaChangeBillUtil.getFinCardByRealAndBook(realCardIds, (Map)realCardMap, assetBooks, null);
            HashMap<Long, Set<DynamicObject>> realMasterId2Fins = new HashMap<Long, Set<DynamicObject>>(FaUtils.getInitialCapacity43((int)finCardMap.size()));
            for (Map.Entry map : finCardMap.entrySet()) {
                DynamicObject finCard = (DynamicObject)map.getValue();
                long realCardMasterId = finCard.getLong("realcardmasterid");
                realMasterId2Fins.computeIfAbsent(realCardMasterId, v -> new HashSet(2)).add(finCard);
            }
            HashSet<Long> existsRealIds = new HashSet<Long>(FaUtils.getInitialCapacity43((int)realCardIds.size()));
            DynamicObjectCollection fieldEntity = changeBill.getDynamicObjectCollection("fieldentry");
            fieldEntity.clear();
            DynamicObjectCollection realEntity = changeBill.getDynamicObjectCollection("realentry");
            realEntity.clear();
            this.genChangeBillEntry(changeBill, "main_changebillentry", realCardMap, changeTypeItems, bookMap, curPeriodId2PeriodMap, nextPeriodId2PeriodMap, assetPolicyInfoList, finCardMap, realMasterId2Fins, existsRealIds);
            this.genChangeBillEntry(changeBill, "other_changebillentry", realCardMap, changeTypeItems, bookMap, curPeriodId2PeriodMap, nextPeriodId2PeriodMap, assetPolicyInfoList, finCardMap, realMasterId2Fins, existsRealIds);
        }
    }

    private void processChangeDate(DynamicObject changeBill, DynamicObject assetBook) {
        Date changeDate = changeBill.getDate("changedate");
        if (changeDate == null) {
            Date now = new Date();
            Date beginDate = assetBook.getDate(Fa.dot((String[])new String[]{"curperiod", "begindate"}));
            Date endDate = assetBook.getDate(Fa.dot((String[])new String[]{"curperiod", "enddate"}));
            if (now.before(beginDate)) {
                changeBill.set("changedate", (Object)beginDate);
            } else if (now.after(endDate)) {
                changeBill.set("changedate", (Object)endDate);
            } else {
                changeBill.set("changedate", (Object)now);
            }
        } else {
            Date curBeginDate = assetBook.getDate(Fa.dot((String[])new String[]{"curperiod", "begindate"}));
            if (changeDate.before(curBeginDate)) {
                changeBill.set("changedate", (Object)curBeginDate);
            }
        }
    }

    private void genChangeBillEntry(DynamicObject changeBill, String entityName, Map<Object, DynamicObject> realCardMap, List<ChangeTypeItem> changeTypeItems, Map<String, List<DynamicObject>> bookMap, Map<Long, DynamicObject> curPeriodId2PeriodMap, Map<Long, DynamicObject> nextPeriodId2PeriodMap, Map<Object, List<Tuple<String, DynamicObject>>> assetPolicyInfoList, Map<String, DynamicObject> finCardMap, Map<Long, Set<DynamicObject>> realMasterId2Fins, Set<Long> existsRealIds) {
        String bookTrg = "main_changebillentry".equals(entityName) ? MAIN_BOOK_TRG : OTHER_BOOK_TRG;
        String realTrg = bookTrg + "_realcard";
        String isAdjustDepTrg = bookTrg + "_isadjustdepre";
        String bizDateTrg = bookTrg + "_bizdate";
        String reasonTrg = bookTrg + "_reason";
        List<DynamicObject> books = bookMap.get(bookTrg);
        DynamicObjectCollection changeBillEntity = changeBill.getDynamicObjectCollection(entityName);
        if (changeBillEntity.isEmpty()) {
            return;
        }
        String srcName = this.getSrcMainType().getName();
        for (DynamicObject changeBillEntry : changeBillEntity) {
            DynamicObject realCard = changeBillEntry.getDynamicObject(realTrg);
            if (realCard == null) continue;
            long realMasterId = realCard.getLong("masterid");
            realCard = realCardMap.get(realMasterId);
            for (DynamicObject book : books) {
                long depUseId = book.getLong(Fa.id((String)"depreuse"));
                String key = realMasterId + "_" + depUseId;
                DynamicObject finCard = finCardMap.get(key);
                String isAdjustDepre = changeBillEntry.getString(isAdjustDepTrg);
                Date bizDate = changeBillEntry.getDate(bizDateTrg);
                String reason = changeBillEntry.getString(reasonTrg);
                String isAdjustDep = this.getAdjustDep(changeTypeItems);
                String isAdjust = "2".equals(isAdjustDep) ? isAdjustDepre : isAdjustDep;
                int changeCount = this.genChangeEntryForChangeItem(changeBill, changeTypeItems, curPeriodId2PeriodMap, nextPeriodId2PeriodMap, assetPolicyInfoList, realMasterId2Fins, existsRealIds, changeBillEntry, realCard, realMasterId, book, finCard, bizDate, reason, isAdjust, false);
                if (!"fa_asset_drawback".equals(srcName) || changeCount != 0) continue;
                this.genChangeEntryForChangeItem(changeBill, changeTypeItems, curPeriodId2PeriodMap, nextPeriodId2PeriodMap, assetPolicyInfoList, realMasterId2Fins, existsRealIds, changeBillEntry, realCard, realMasterId, book, finCard, bizDate, reason, isAdjust, true);
            }
        }
    }

    private int genChangeEntryForChangeItem(DynamicObject changeBill, List<ChangeTypeItem> changeTypeItems, Map<Long, DynamicObject> curPeriodId2PeriodMap, Map<Long, DynamicObject> nextPeriodId2PeriodMap, Map<Object, List<Tuple<String, DynamicObject>>> assetPolicyInfoList, Map<Long, Set<DynamicObject>> realMasterId2Fins, Set<Long> existsRealIds, DynamicObject changeBillEntry, DynamicObject realCard, long realMasterId, DynamicObject book, DynamicObject finCard, Date bizDate, String reason, String isAdjust, boolean ignoreChange) {
        int changeCount = 0;
        String srcName = this.getSrcMainType().getName();
        DynamicObjectCollection fieldEntity = changeBill.getDynamicObjectCollection("fieldentry");
        DynamicObject org = changeBill.getDynamicObject("org");
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        if (org != null) {
            orgIdList.add(org.getLong("id"));
        }
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
        for (ChangeTypeItem changeTypeItem : changeTypeItems) {
            Date date;
            boolean changeStatus;
            Object afterValue;
            Object beforeValue = FaUtils.getValueFromDy((DynamicObject)changeBillEntry, (String)((String)changeTypeItem.getMapFields().get(0)));
            if (beforeValue == null || beforeValue instanceof Long && (Long)beforeValue == 0L) {
                String formMeta = changeTypeItem.getFormMeta();
                beforeValue = "fa_card_real".equals(formMeta) ? FaUtils.getValueFromDy((DynamicObject)realCard, (String)changeTypeItem.getItemKey()) : FaUtils.getValueFromDy((DynamicObject)finCard, (String)changeTypeItem.getItemKey());
            }
            if ("fa_asset_drawback".equals(srcName) && "headusedept".equals(changeTypeItem.getItemKey())) {
                Object usePersonPk = FaUtils.getValueFromDy((DynamicObject)changeBillEntry, (String)"m_aft_headuseperson");
                afterValue = ThreadCache.get((Object)("drawbackToChangeUseDept4UsePerson" + usePersonPk), () -> FaUserUtils.getAdminOrgByUse((Object)usePersonPk));
            } else {
                afterValue = FaUtils.getValueFromDy((DynamicObject)changeBillEntry, (String)((String)changeTypeItem.getMapFields().get(1)));
            }
            if (!(changeStatus = ignoreChange ? true : FaBizUtils.checkChangeStatus((Object)beforeValue, (Object)afterValue, (boolean)changeNo))) continue;
            ++changeCount;
            DynamicObject addNewEntry = fieldEntity.addNew();
            addNewEntry.set("seq", (Object)fieldEntity.size());
            addNewEntry.set("realcard1", (Object)realCard);
            addNewEntry.set("depreuse1", (Object)book.getDynamicObject("depreuse"));
            addNewEntry.set("currency1", (Object)finCard.getDynamicObject("currency"));
            addNewEntry.set("fincard1", (Object)finCard);
            addNewEntry.set("basecurrency1", (Object)finCard.getDynamicObject("basecurrency"));
            String field = Fa.dot((String[])new String[]{changeTypeItem.getFormMeta(), changeTypeItem.getItemKey()});
            addNewEntry.set("field", (Object)field);
            addNewEntry.set("beforevalue", beforeValue);
            addNewEntry.set("aftervalue", afterValue);
            addNewEntry.set("reason", (Object)reason);
            addNewEntry.set("isadjustdepre1", (Object)isAdjust);
            if (bizDate != null) {
                date = bizDate;
            } else {
                DynamicObject nextPeriod;
                List<Tuple<String, DynamicObject>> assetPolicyInfo;
                long curPeriodId = book.getLong(Fa.id((String)"curperiod"));
                String assetCatLongNumber = realCard.getString(Fa.dot((String[])new String[]{"assetcat", "longnumber"}));
                DynamicObject assetPolicyEntry = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)assetCatLongNumber, assetPolicyInfo = assetPolicyInfoList.get(book.getLong(Fa.id((String)"depresystem"))));
                date = "CUR".equals(assetPolicyEntry.getString("depreeffect")) ? curPeriodId2PeriodMap.get(curPeriodId).getDate("begindate") : ((nextPeriod = nextPeriodId2PeriodMap.get(curPeriodId)) != null ? nextPeriodId2PeriodMap.get(curPeriodId).getDate("begindate") : curPeriodId2PeriodMap.get(curPeriodId).getDate("begindate"));
            }
            addNewEntry.set("bizdate1", (Object)date);
            addNewEntry.set("assetnumber", (Object)realCard.getString("number"));
            if (!existsRealIds.add(realMasterId)) continue;
            this.genRealAndFinEntry(realMasterId2Fins, changeBill, realCard, realMasterId, isAdjust, date);
        }
        return changeCount;
    }

    private void genRealAndFinEntry(Map<Long, Set<DynamicObject>> realMasterId2Fins, DynamicObject changeBill, DynamicObject realCard, long realMasterId, String isAdjust, Date date) {
        DynamicObjectCollection realEntity = changeBill.getDynamicObjectCollection("realentry");
        DynamicObject realEntry = realEntity.addNew();
        realEntry.set("seq", (Object)realEntity.size());
        realEntry.set("realcard", (Object)realCard);
        Set<DynamicObject> finCards = realMasterId2Fins.get(realMasterId);
        for (DynamicObject fin : finCards) {
            DynamicObjectCollection finEntity = realEntry.getDynamicObjectCollection("finentry");
            DynamicObject finEntry = finEntity.addNew();
            finEntry.set("seq", (Object)finEntity.size());
            finEntry.set("fincard", (Object)fin);
            finEntry.set("currency", (Object)fin.getDynamicObject("basecurrency"));
            finEntry.set("depreuse", (Object)fin.getDynamicObject("depreuse"));
            finEntry.set("isadjustdepre", (Object)isAdjust);
            finEntry.set("bizdate", (Object)date);
        }
    }

    private Set<DynamicObject> processChangeItem(DynamicObject changeBill, DynamicObject changeType) {
        DynamicObjectCollection changeTypeEntry = changeType.getDynamicObjectCollection("changetypeentry");
        Object[] changeItemIds = changeTypeEntry.stream().map(v -> v.getLong(Fa.id((String)"changeitem"))).distinct().toArray();
        Map changeItem4Load = BusinessDataServiceHelper.loadFromCache((Object[])changeItemIds, (String)"fa_change_item");
        HashSet<DynamicObject> changeItems = new HashSet<DynamicObject>(changeItem4Load.size());
        changeItems.addAll(changeItem4Load.values());
        DynamicObjectCollection changeItemColl = changeBill.getDynamicObjectCollection("changeitem");
        for (DynamicObject changeItem : changeItems) {
            DynamicObject assetChangeItemObject = changeItemColl.addNew();
            assetChangeItemObject.set("fbasedataid", (Object)changeItem);
            assetChangeItemObject.set("fbasedataid_id", (Object)changeItem.getLong("id"));
        }
        return changeItems;
    }

    private String getAdjustDep(List<ChangeTypeItem> changeTypeItems) {
        String isAdjustDep = "2";
        for (ChangeTypeItem changeTypeItem : changeTypeItems) {
            String itemKey = changeTypeItem.getItemKey();
            if ("realaccountdate".equals(itemKey)) {
                isAdjustDep = "0";
            }
            if (!"usestatus".equals(itemKey)) continue;
            isAdjustDep = "1";
        }
        return isAdjustDep;
    }
}

