/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaUtils;

public class EngineeringToChangeBillByCountPlugin
extends AbstractConvertPlugIn {
    private Map<String, BigDecimal> exchangeRateMapCache = new HashMap<String, BigDecimal>();

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendedDataEntityArr = targetExtDataEntitySet.FindByEntityKey("fa_change_dept");
        List changeBillObjs = Stream.of(extendedDataEntityArr).map(v -> v.getDataEntity()).collect(Collectors.toList());
        HashSet<Object> realCardIdSet = new HashSet<Object>(16);
        HashSet<Long> sourceids = new HashSet<Long>(16);
        HashSet<Object> newRealCard = new HashSet<Object>(16);
        ArrayList<DynamicObject> realcardDys = new ArrayList<DynamicObject>(16);
        int amtprecision = 2;
        HashMap<Long, DynamicObject> enginnerBillMap = new HashMap<Long, DynamicObject>();
        HashMap engnnerRealMap = new HashMap();
        HashSet<Long> realSet = null;
        HashMap<Long, ArrayList<DynamicObject>> cardMap = new HashMap<Long, ArrayList<DynamicObject>>();
        HashSet existCards = new HashSet(1);
        HashMap<Long, DynamicObject> masterid2DyMap = new HashMap<Long, DynamicObject>(changeBillObjs.size() * 1000);
        for (DynamicObject changeBill : changeBillObjs) {
            Long sourceid = changeBill.getLong("sourceid");
            realSet = (HashSet<Long>)engnnerRealMap.get(sourceid);
            if (realSet == null) {
                realSet = new HashSet<Long>(16);
                engnnerRealMap.put(sourceid, realSet);
            }
            sourceids.add(sourceid);
            DynamicObjectCollection fieldentry = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject entry : fieldentry) {
                Long realcard1 = entry.getLong("realcard1.masterid");
                realSet.add(realcard1);
                realcardDys.add(entry.getDynamicObject("realcard1"));
                masterid2DyMap.put(realcard1, entry.getDynamicObject("realcard1"));
            }
            Date bizDate = EngineeringToChangeBillByCountPlugin.setDateDifPeriod(changeBill.getDynamicObject("org"), Boolean.FALSE);
            Set curRealCard = FaUtils.getCurRealCard((Date)bizDate, (Long)changeBill.getLong("org.id"), (Boolean)false, realSet, (BusyTypeDetailEnum)BusyTypeDetailEnum.FIN_CHG, null);
            existCards.addAll(curRealCard);
            for (DynamicObject realcard : realcardDys) {
                if (existCards.contains(realcard.getLong("id"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u6216\u8005\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1\u3002", (String)"EngineeringToChangeBillByCountPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), realcard.getString("number")));
            }
        }
        Map<String, DynamicObject> entryMap = EngineeringToChangeBillByCountPlugin.getEnginneringMap(sourceids, realCardIdSet, newRealCard, enginnerBillMap);
        List<DynamicObject> fincards = EngineeringToChangeBillByCountPlugin.queryFinCardList(newRealCard, null);
        if (0 == fincards.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u975e\u8d44\u4ea7\u8d26\u7c3f\u671f\u95f4\u5185\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EngineeringToChangeBillByCountPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject fin : fincards) {
            long realMasterid = fin.getLong("realcard.masterid");
            ArrayList<DynamicObject> fins = (ArrayList<DynamicObject>)cardMap.get(realMasterid);
            if (fins == null) {
                fins = new ArrayList<DynamicObject>(2);
                cardMap.put(realMasterid, fins);
            }
            fins.add(fin);
        }
        for (DynamicObject changeBill : changeBillObjs) {
            DynamicObjectCollection fieldentrys = changeBill.getDynamicObjectCollection("fieldentry");
            HashSet<Long> realcards = new HashSet<Long>(fieldentrys.size());
            for (DynamicObject fieldentry : fieldentrys) {
                realcards.add(fieldentry.getLong("realcard1.masterid"));
            }
            fieldentrys.clear();
            long engnnerId = changeBill.getLong("sourceid");
            DynamicObject enginner = (DynamicObject)enginnerBillMap.get(engnnerId);
            if (!engnnerRealMap.containsKey(engnnerId)) continue;
            for (Long real : realcards) {
                List fincs = (List)cardMap.get(real);
                if (null == fincs) continue;
                for (DynamicObject fincard : fincs) {
                    Date bizDate = EngineeringToChangeBillByCountPlugin.setDateDifPeriod(changeBill.getDynamicObject("org"), Boolean.FALSE);
                    changeBill.set("changedate", (Object)bizDate);
                    String billstatus = fincard.getString("billstatus");
                    String number = fincard.getString("number");
                    if (!"C".equals(billstatus)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EngineeringToChangeBillByCountPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
                    }
                    BigDecimal netResidualValRate = FinCardCalc.getNetResidualValRate((DynamicObject)fincard, (boolean)true);
                    BigDecimal exchangeRate = this.getExchangeRate(fincard, enginner, this.exchangeRateMapCache);
                    if (exchangeRate == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u539f\u5e01\u4e0e\u672c\u4f4d\u5e01\u4e4b\u95f4\u7684\u6c47\u7387\uff0c\u8bf7\u5148\u5728\u7cfb\u7edf\u4e91->\u57fa\u7840\u8d44\u6599->\u6c47\u7387\u5217\u8868\u7ef4\u62a4\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"EngineeringToChangeBillByCountPlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObject preresidualvalDy = fieldentrys.addNew();
                    DynamicObject originalvalDy = fieldentrys.addNew();
                    DynamicObject inBaseCurrency = fincard.getDynamicObject("basecurrency");
                    if (inBaseCurrency != null) {
                        amtprecision = inBaseCurrency.getInt("amtprecision");
                    }
                    DynamicObject engineeringInfo = entryMap.get(engnnerId + "_" + fincard.getLong("realcard.masterid"));
                    originalvalDy.set("field", (Object)"fa_card_fin.originalval");
                    originalvalDy.set("beforevalue", fincard.get("originalval"));
                    BigDecimal originalvalAfter = fincard.getBigDecimal("originalval").add(engineeringInfo.getBigDecimal("change_originalval").multiply(exchangeRate));
                    originalvalDy.set("aftervalue", (Object)originalvalAfter.setScale(amtprecision, RoundingMode.HALF_UP));
                    originalvalDy.set("realcard1", masterid2DyMap.get(fincard.get("realcardmasterid")));
                    originalvalDy.set("fincard1", (Object)fincard);
                    originalvalDy.set("reason", engineeringInfo.get("reason"));
                    originalvalDy.set("isadjustdepre1", (Object)"1");
                    originalvalDy.set("assetnumber", (Object)engineeringInfo.getDynamicObject("realcardid").getString("number"));
                    originalvalDy.set("depreuse1", fincard.get("depreuse"));
                    Date bizdate = enginner.getDate("businessdate");
                    originalvalDy.set("bizdate1", (Object)bizdate);
                    originalvalDy.set("currency1", fincard.get("currency"));
                    originalvalDy.set("basecurrency1", fincard.get("basecurrency"));
                    preresidualvalDy.set("field", (Object)"fa_card_fin.preresidualval");
                    preresidualvalDy.set("beforevalue", fincard.get("preresidualval"));
                    BigDecimal preresidualvalAfter = fincard.getBigDecimal("preresidualval").add(engineeringInfo.getBigDecimal("change_originalval").multiply(netResidualValRate).divide(new BigDecimal(100), 4).multiply(exchangeRate));
                    preresidualvalDy.set("aftervalue", (Object)preresidualvalAfter.setScale(amtprecision, RoundingMode.HALF_UP));
                    preresidualvalDy.set("realcard1", masterid2DyMap.get(fincard.get("realcardmasterid")));
                    preresidualvalDy.set("fincard1", (Object)fincard);
                    preresidualvalDy.set("reason", engineeringInfo.get("reason"));
                    preresidualvalDy.set("isadjustdepre1", (Object)"1");
                    preresidualvalDy.set("assetnumber", (Object)engineeringInfo.getDynamicObject("realcardid").getString("number"));
                    preresidualvalDy.set("depreuse1", fincard.get("depreuse"));
                    preresidualvalDy.set("bizdate1", (Object)bizdate);
                    preresidualvalDy.set("currency1", fincard.get("currency"));
                    preresidualvalDy.set("basecurrency1", fincard.get("basecurrency"));
                    DynamicObjectCollection realentry = changeBill.getDynamicObjectCollection("realentry");
                    List targetRealEntry = realentry.stream().filter(t -> {
                        DynamicObject realCardObj = t.getDynamicObject("realcard");
                        return realCardObj != null && real.longValue() == realCardObj.getLong("masterid");
                    }).collect(Collectors.toList());
                    for (DynamicObject finentrys : targetRealEntry) {
                        DynamicObjectCollection finentry = finentrys.getDynamicObjectCollection("finentry");
                        DynamicObject fin = finentry.addNew();
                        fin.set("fincard", (Object)fincard);
                        fin.set("currency", (Object)fincard.getDynamicObject("basecurrency"));
                        fin.set("depreuse", fincard.get("depreuse"));
                        fin.set("isadjustdepre", (Object)"1");
                        fin.set("bizdate", (Object)bizdate);
                    }
                }
            }
        }
        for (DynamicObject changeBill : changeBillObjs) {
            DynamicObjectCollection fieldList = changeBill.getDynamicObjectCollection("fieldentry");
            BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)fieldList);
            changeBill.set("chtypedetail", (Object)changeTypeDetail.getValue());
        }
    }

    private BigDecimal getExchangeRate(DynamicObject fincard, DynamicObject enginner, Map<String, BigDecimal> exchangeRateMapCache) {
        DynamicObject inBaseCurrency;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject assetBook = fincard.getDynamicObject("assetbook");
        DynamicObject exchangetable = null;
        long exchangetableId = 0L;
        long inBaseCurrencyId = 0L;
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (assetBook != null) {
            exchangetable = assetBook.getDynamicObject("exchangetable");
        }
        if (exchangetable != null) {
            exchangetableId = exchangetable.getLong("id");
        }
        if ((inBaseCurrency = fincard.getDynamicObject("basecurrency")) != null) {
            inBaseCurrencyId = inBaseCurrency.getLong("id");
        }
        long currencyId = enginner.getLong("basecurrency.id");
        String finaccountdate = sdf.format(fincard.getDate("finaccountdate"));
        String key = finaccountdate + exchangetableId + currencyId + inBaseCurrencyId;
        if (currencyId != inBaseCurrencyId) {
            if (!exchangeRateMapCache.containsKey(key)) {
                exchangeRate = (BigDecimal)this.getExchangeRate(exchangetableId, currencyId, inBaseCurrencyId, fincard.getDate("finaccountdate"));
                exchangeRateMapCache.put(key, exchangeRate);
            }
            exchangeRate = exchangeRateMapCache.get(key);
        }
        return exchangeRate;
    }

    private Object getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        return BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)date);
    }

    private static Map<String, DynamicObject> getEnginneringMap(Set<Long> sourceids, Set<Object> realCardIdSet, Set<Object> newRealCard, Map<Long, DynamicObject> enginnerBillMap) {
        DynamicObject[] engineerings;
        QFilter qSourseid = new QFilter("id", "in", sourceids);
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> masterIds = new HashSet<Long>(16);
        for (DynamicObject engineering : engineerings = BusinessDataServiceHelper.load((String)"fa_engineeringbill", (String)"assetsentrychange,assetsentrychange.reason,assetsentrychange.realcardid,assetsentrychange.realcardid.bizstatus,assetsentrychange.realcardid.masterid,assetsentrychange.realcardid.number,assetsentrychange.bizdate,assetsentrychange.change_originalval,basecurrency,businessdate", (QFilter[])new QFilter[]{qSourseid})) {
            DynamicObjectCollection engineeringEntry = engineering.getDynamicObjectCollection("assetsentrychange");
            for (DynamicObject entry : engineeringEntry) {
                long masterid = entry.getLong("realcardid.masterid");
                masterIds.add(masterid);
            }
        }
        QFilter qMaster = new QFilter("masterid", "in", masterIds);
        QFilter qIsbak = new QFilter("isbak", "=", (Object)"0");
        DynamicObjectCollection realcards = QueryServiceHelper.query((String)"fa_card_real", (String)"id,masterid", (QFilter[])new QFilter[]{qMaster, qIsbak});
        for (DynamicObject dy : realcards) {
            long id = dy.getLong("id");
            newRealCard.add(id);
        }
        for (DynamicObject engineering : engineerings) {
            DynamicObjectCollection engineeringEntry = engineering.getDynamicObjectCollection("assetsentrychange");
            for (DynamicObject entry : engineeringEntry) {
                long realid = entry.getLong("realcardid.masterid");
                String number = entry.getString("realcardid.number");
                String bizstatus = entry.getString("realcardid.bizstatus");
                if (!"READY".equals(bizstatus)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\uff1a%s\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u5c31\u7eea\uff0c\u4e0d\u80fd\u4e0b\u63a8\u53d8\u66f4\u5355\u3002", (String)"EngineeringToChangeBillByCountPlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
                }
                realCardIdSet.add(realid);
                entryMap.put(engineering.getLong("id") + "_" + entry.getLong("realcardid.masterid"), entry);
                enginnerBillMap.put(engineering.getLong("id"), engineering);
            }
        }
        return entryMap;
    }

    private static List<DynamicObject> queryFinCardList(Set<Object> realCardPKSet, Set<String> curstoms) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", realCardSet)};
        String[] fieldArr = new String[]{"id", "realcard", "realcardmasterid", "currency", "number", FaDaoOrmImpl.dot((String[])new String[]{"realcard", "usestatus", "isdepre"}), "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}), FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "curperiod", "id"}), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre", "networth", "addupyeardepre", "depremethod", "assetcat", "isdynamic", "monthorigvalchg", "monthdeprechg", "billstatus", "yearorigvalchg", "basecurrency", "finaccountdate"};
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.addAll(Arrays.asList(fieldArr));
        if (curstoms != null) {
            fieldSet.addAll(curstoms);
        }
        String selector = String.join((CharSequence)",", fieldSet);
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters, (String)"depreuse asc");
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        selector = FaDaoOrmImpl.comma((String[])new String[]{"id", "curperiod"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selector, (QFilter[])new QFilter("id", "in", bookIdSet).toArray());
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get("id"), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> EngineeringToChangeBillByCountPlugin.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    private static boolean filterFinCards(long curPeriodId, DynamicObject fincard) {
        boolean isRight;
        DynamicObject bizPeriodDyn = fincard.getDynamicObject("bizperiod");
        long bizPeriodId = 0L;
        if (bizPeriodDyn != null) {
            bizPeriodId = fincard.getDynamicObject("bizperiod").getLong("id");
        }
        long endPeriodId = 99999999999L;
        DynamicObject endPeriod = fincard.getDynamicObject("endperiod");
        if (endPeriod != null) {
            endPeriodId = endPeriod.getLong("id");
        }
        boolean bl = isRight = bizPeriodId <= curPeriodId && curPeriodId < endPeriodId;
        if (isRight) {
            if (bizPeriodId < curPeriodId) {
                fincard.set("monthorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("monthdeprechg", (Object)BigDecimal.ZERO);
            }
            if (bizPeriodId / FaBizUtils.YEAR_PERIOD_L < curPeriodId / FaBizUtils.YEAR_PERIOD_L) {
                fincard.set("yearorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("addupyeardepre", (Object)BigDecimal.ZERO);
            }
        }
        return isRight;
    }

    private static Date setDateDifPeriod(DynamicObject org, boolean futureBusiness) {
        Date now = new Date();
        if (org == null) {
            return now;
        }
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)org.getLong("id"));
        if (mainBook != null) {
            Date begindate = (Date)mainBook.get("begindate");
            Date enddate = (Date)mainBook.get("enddate");
            if (begindate == null) {
                return now;
            }
            boolean flag = true;
            if (futureBusiness) {
                flag = now.after(begindate);
            } else {
                boolean bl = flag = now.after(begindate) && now.before(enddate);
            }
            if (flag) {
                return now;
            }
            return enddate;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"EngineeringToChangeBillByCountPlugin_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), org.getString("name")));
    }
}

