/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.botp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.AttachmentPanelMapItem;
import kd.bos.entity.botp.AttachmentPanelMapPolicy;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.AttachmentUtils;
import kd.fi.fa.common.util.Fa;

public class PurchaseToRealCardByCountPlugin
extends AbstractConvertPlugIn {
    private static Log log = LogFactory.getLog(PurchaseToRealCardByCountPlugin.class);
    private static final String BUILD_WAY_BY_QTY = "2";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final String selectPurFields = Fa.comma((String[])new String[]{"id", "billno", "buildway"});

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendedDataEntityArr = targetExtDataEntitySet.FindByEntityKey("fa_card_real");
        List realCardObjs = Stream.of(extendedDataEntityArr).map(v -> v.getDataEntity()).collect(Collectors.toList());
        int extIndex = realCardObjs.size();
        HashMap<Object, List<Object>> sourceId2TargetIdMap = new HashMap<Object, List<Object>>(realCardObjs.size());
        int index = 0;
        ExtendedDataEntitySet buildByQtySet = new ExtendedDataEntitySet();
        HashSet<String> purchaseBillNumberSet = new HashSet<String>(16);
        for (DynamicObject realCard : realCardObjs) {
            purchaseBillNumberSet.add(realCard.getString("srcbillnumber"));
        }
        QFilter[] purchaseFilters = new QFilter[]{new QFilter("billno", "in", purchaseBillNumberSet)};
        DynamicObjectCollection purchaseBills = QueryServiceHelper.query((String)"fa_purchasebill", (String)selectPurFields, (QFilter[])purchaseFilters);
        HashMap<String, String> purId2BuildWayMap = new HashMap<String, String>(16);
        for (DynamicObject purchase : purchaseBills) {
            purId2BuildWayMap.put(purchase.getString("billno"), purchase.getString("buildway"));
        }
        for (DynamicObject realCard : realCardObjs) {
            ExtendedDataEntity dataEntity = extendedDataEntityArr[index];
            DynamicObject purchaseBill = (DynamicObject)((List)dataEntity.getValue("ConvertSource")).get(0);
            Long purchaseBillId = purchaseBill.getLong("id");
            ArrayList targetIds = (ArrayList)sourceId2TargetIdMap.get(purchaseBillId);
            if (targetIds == null) {
                targetIds = new ArrayList(4);
                sourceId2TargetIdMap.put(purchaseBillId, targetIds);
            }
            long[] qytNewCardIds = null;
            String buildWay = (String)purId2BuildWayMap.get(realCard.getString("srcbillnumber"));
            if (buildWay == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5BOTP\u89c4\u5219\u662f\u5426\u914d\u7f6e[\u6765\u6e90\u5206\u5f55]\u7684\u5b57\u6bb5\u6620\u5c04\u3002", (String)"PurchaseToRealCardByCountPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (BUILD_WAY_BY_QTY.equals(buildWay)) {
                int qty = realCard.getInt("assetamount");
                if (qty > 1) {
                    qytNewCardIds = DB.genLongIds((String)"t_fa_card_real", (int)qty);
                    targetIds.addAll(Arrays.stream(qytNewCardIds).boxed().collect(Collectors.toList()));
                }
                ArrayList<ExtendedDataEntity> extendedDataEntities = new ArrayList<ExtendedDataEntity>(qty);
                realCard.set("assetamount", (Object)1);
                int splitSeq = 1;
                realCard.set("sourceentrysplitseq", (Object)splitSeq++);
                for (int i = 1; i <= qty; ++i) {
                    DynamicObject copyObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)realCard, (boolean)false, (boolean)true);
                    copyObj.set("sourceentrysplitseq", (Object)splitSeq++);
                    copyObj.set("id", qytNewCardIds == null ? null : Long.valueOf(qytNewCardIds[i - 1]));
                    extendedDataEntities.add(new ExtendedDataEntity(copyObj, extIndex++, 0));
                }
                buildByQtySet.AddExtendedDataEntities("fa_card_real", extendedDataEntities);
            } else {
                ArrayList<ExtendedDataEntity> allAndEntryWayList = new ArrayList<ExtendedDataEntity>(1);
                allAndEntryWayList.add(dataEntity);
                buildByQtySet.AddExtendedDataEntities("fa_card_real", allAndEntryWayList);
            }
            ++index;
        }
        e.setTargetExtDataEntitySet(buildByQtySet);
        this.copyAttachments(sourceId2TargetIdMap);
    }

    private String querySrcBillBuildWayFromCache(DynamicObject realCard) {
        String srcEntityName = this.getSrcMainType().getName();
        long srcEntryId = realCard.getLong("sourceentryid");
        String selectFields = String.join((CharSequence)",", "buildway");
        QFilter entryIdFilter = new QFilter("assetsentry.id", "=", (Object)srcEntryId);
        DynamicObject purchaseBill = BusinessDataServiceHelper.loadSingleFromCache((String)srcEntityName, (String)selectFields, (QFilter[])new QFilter[]{entryIdFilter});
        if (purchaseBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5BOTP\u89c4\u5219\u662f\u5426\u914d\u7f6e[\u6765\u6e90\u5206\u5f55]\u7684\u5b57\u6bb5\u6620\u5c04\u3002", (String)"PurchaseToRealCardByCountPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        return purchaseBill.getString("buildway");
    }

    private void copyAttachments(Map<Object, List<Object>> sourceId2TargetIdMap) {
        ConvertRuleElement rule = this.getRule();
        AttachmentPanelMapPolicy panelMapPolicy = rule.getAttachmentPanelMapPolicy();
        AttachmentPanelMapItem panelMapItem = (AttachmentPanelMapItem)panelMapPolicy.getItems().get(0);
        String sourcePanel = panelMapItem.getSourceAttachmentPanel();
        if (StringUtils.isEmpty((String)sourcePanel)) {
            log.info("copyAttachments: \u56e0\u4e3abotp\u4e2d\u672a\u914d\u7f6e\u6e90\u5355\u9644\u4ef6\u9762\u677f\uff0c\u6240\u4ee5\u4e0d\u8fdb\u884c\u9644\u4ef6\u7684\u5904\u7406\u3002");
            return;
        }
        AttachmentUtils.copyAttachments((String)"fa_purchasebill", (String)"fa_card_real", (String)ATTACHMENT_PANEL, sourceId2TargetIdMap);
    }
}

