/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class FaChangeApplyOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("main_changebillentry");
        fieldKeys.add("bef_assetamount");
        fieldKeys.add("aft_assetamount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey) || "audit".equals(operationKey) || "submit".equals(operationKey)) {
            for (DynamicObject changeApply : e.getDataEntities()) {
                for (DynamicObject entryRow : changeApply.getDynamicObjectCollection("main_changebillentry")) {
                    BigDecimal befAssetAmount = entryRow.getBigDecimal("bef_assetamount");
                    BigDecimal aftAssetAmount = entryRow.getBigDecimal("aft_assetamount");
                    if (aftAssetAmount != null && aftAssetAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                    entryRow.set("aft_assetamount", (Object)befAssetAmount);
                }
            }
        }
        if ("submit".equals(operationKey)) {
            List orgIdList = Arrays.stream(e.getDataEntities()).map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toList());
            Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
            for (DynamicObject changeApply : e.getDataEntities()) {
                DynamicObject org = changeApply.getDynamicObject("org");
                boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
                DynamicObjectCollection entry = changeApply.getDynamicObjectCollection("main_changebillentry");
                for (DynamicObject entryRow : entry) {
                    DataEntityPropertyCollection properties = entryRow.getDynamicObjectType().getProperties();
                    for (IDataEntityProperty property : properties) {
                        Object aftValue;
                        if (!property.getName().contains("bef_") || "bef_assetamount".equals(property.getName())) continue;
                        String befKey = property.getName();
                        String aftKey = befKey.replace("bef_", "aft_");
                        Object befValue = entryRow.get(befKey);
                        if (befValue == null || !entryRow.containsProperty(aftKey) || !befValue.equals(aftValue = entryRow.get(aftKey)) || changeNo) continue;
                        entryRow.set(aftKey, null);
                    }
                }
            }
        }
    }
}

