/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.changebill.FaChangeApplyOperationPlugin;
import kd.fi.fa.opplugin.changebill.validator.FaChangeApplyCheckMustValidator;

public class FaChangeApplySubmitOp
extends FaChangeApplyOperationPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                List orgIdList = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getLong(Fa.id((String)"org"))).collect(Collectors.toList());
                Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObjectCollection entryData = entity.getDataEntity().getDynamicObjectCollection("main_changebillentry");
                    DynamicObjectCollection changeItems = entity.getDataEntity().getDynamicObjectCollection("changeitem");
                    DynamicObject org = entity.getDataEntity().getDynamicObject("org");
                    boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
                    int rowIndex = 0;
                    for (DynamicObject entryRow : entryData) {
                        boolean hasChanged = false;
                        DynamicObject realcard = entryRow.getDynamicObject("realcard");
                        if (realcard != null) {
                            DynamicObject assetOrg = realcard.getDynamicObject("assetunit");
                            DynamicObject afterUseDept = entryRow.getDynamicObject("aft_headusedept");
                            if (afterUseDept != null && !FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)org, (DynamicObject)assetOrg, (Long)afterUseDept.getLong("id"))) {
                                String orgMsg = String.format(ResManager.loadKDString((String)"\u4e3b\u804c\u90e8\u95e8\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\uff0c\u6240\u5728\u884c\u53f7\uff1a%1$s\u3002", (String)"FaChangeApplySubmitOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex);
                                this.addErrorMessage(entity, orgMsg);
                            }
                            for (DynamicObject obj : changeItems) {
                                Object aftValue;
                                Object befValue;
                                DynamicObject changeItem = obj.getDynamicObject("fbasedataid");
                                String number = changeItem.getString("number");
                                if (!entryRow.containsProperty("bef_" + number)) {
                                    number = changeItem.getString("changeapplykey");
                                }
                                if (!(hasChanged = FaBizUtils.checkChangeStatus((Object)(befValue = FaUtils.getValueFromDy((DynamicObject)entryRow, (String)("bef_" + number))), (Object)(aftValue = FaUtils.getValueFromDy((DynamicObject)entryRow, (String)("aft_" + number))), (boolean)changeNo).booleanValue())) continue;
                                break;
                            }
                        }
                        if (!hasChanged) {
                            String msg = String.format(ResManager.loadKDString((String)"\u672a\u53d1\u751f\u53d8\u66f4\uff0c\u6240\u5728\u884c\u53f7\uff1a%1$s\u3002", (String)"FaChangeApplySubmitOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex + 1);
                            this.addErrorMessage(entity, msg);
                        }
                        ++rowIndex;
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new FaChangeApplyCheckMustValidator());
    }
}

