/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.operate.FaChangeCmd;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaChangeBillGenVoucherOp
extends AbstractOperationServicePlugIn {
    private static final String QUERY_BOOK_FIELD = Fa.comma((String[])new String[]{"id", "periodtype", "basecurrency", "curperiod", "startperiod", "depresystem", "status", "org", "enable", "depreuse"});

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("changedate");
        fieldKeys.add("realentry");
        fieldKeys.add("realcard");
        fieldKeys.add("finentry");
        fieldKeys.add("bf_fin_info");
        fieldKeys.add("af_fin_info");
        fieldKeys.add("depreuse");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap periodMap = new HashMap(dataEntities.length);
                ArrayList updateData = new ArrayList(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject changeBill = dataEntity.getDataEntity();
                    Long orgId = changeBill.getDynamicObject("org").getLong("id");
                    QFilter orgF = new QFilter("org", "=", (Object)orgId);
                    DynamicObjectCollection bookList = QueryServiceHelper.query((String)"fa_assetbook", (String)QUERY_BOOK_FIELD, (QFilter[])new QFilter[]{orgF});
                    for (DynamicObject book : bookList) {
                        if (!FaChangeBillGenVoucherOp.this.checkBfFinInfo(changeBill, book.getLong("depreuse"))) continue;
                        Long curPeriodId = book.getLong("curperiod");
                        Long periodType = book.getLong("periodtype");
                        Date changeDate = changeBill.getDate("changedate");
                        DynamicObject changePeriod = (DynamicObject)periodMap.get(changeDate);
                        if (changePeriod == null) {
                            changePeriod = FaUtils.getPeriodByDate((Date)changeDate, (long)periodType);
                        }
                        if (changePeriod == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38,\u8bf7\u68c0\u67e5! \u65e5\u671f\uff1a%s", (String)"FaChangeBillGenVoucherOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), changeDate));
                        }
                        if (changePeriod.getLong("id") != curPeriodId.longValue() && FaChangeBillGenVoucherOp.this.checkUnGeneratedFinInPeriod(changeBill, book.getLong("depreuse"))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e0d\u5b58\u5728\u8bb0\u8d26\u65e5\u671f\u5bf9\u5e94\u671f\u95f4\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u5148\u7ed3\u8d26\u5230\u5bf9\u5e94\u671f\u95f4\u3002", (String)"FaChangeBillGenVoucherOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        FaChangeBillGenVoucherOp.this.generateFinInfo(changeBill, book, updateData);
                    }
                }
                if (!updateData.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
                }
            }
        });
    }

    private void generateFinInfo(DynamicObject changeBill, DynamicObject book, List<DynamicObject> updateData) {
        Long orgId = changeBill.getDynamicObject("org").getLong("id");
        Long assetBookId = book.getLong("id");
        Long curPeriodId = book.getLong("curperiod");
        DynamicObjectCollection realEntry = changeBill.getDynamicObjectCollection("realentry");
        Set numbers = realEntry.stream().map(v -> v.getDynamicObject("realcard").getString("number")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("assetbook", "=", (Object)assetBookId), new QFilter("number", "in", numbers), new QFilter("bizperiod", "<=", (Object)curPeriodId)};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"id", "number", "bizperiod"}), (QFilter[])filters, (String)"bizperiod DESC");
        HashMap<String, Integer> numberAndCount = new HashMap<String, Integer>(finCards.size());
        HashMap<String, Object> numberToFinCardId = new HashMap<String, Object>(finCards.size());
        for (DynamicObject finCard : finCards) {
            String number;
            Integer step;
            Boolean originalData = finCard.getBoolean("originaldata");
            if (originalData.booleanValue() || (step = (Integer)numberAndCount.get(number = finCard.getString("number"))) != null && step != 1) continue;
            numberToFinCardId.put(number, finCard.get("id"));
            Long bizPeriodId = finCard.getLong("bizperiod");
            step = bizPeriodId.longValue() == curPeriodId.longValue() ? Integer.valueOf(step == null ? 1 : 2) : Integer.valueOf(2);
            numberAndCount.put(number, step);
        }
        Long depreUseId = book.getLong("depreuse");
        FaChangeCmd changeCmd = new FaChangeCmd(changeBill.getPkValue());
        for (DynamicObject real : realEntry) {
            DynamicObject realCard = real.getDynamicObject("realcard");
            String number = realCard.getString("number");
            Object finCardId = numberToFinCardId.get(number);
            DynamicObject finCardSnapshot = changeCmd.createFinCardSnapshot(finCardId);
            DynamicObjectCollection finEntry = real.getDynamicObjectCollection("finentry");
            for (DynamicObject fin : finEntry) {
                Long depreUseId2Fin = fin.getDynamicObject("depreuse").getLong("id");
                if (depreUseId2Fin.longValue() != depreUseId.longValue()) continue;
                fin.set("bf_fin_info", (Object)finCardSnapshot);
                fin.set("af_fin_info", (Object)finCardSnapshot);
            }
        }
        updateData.add(changeBill);
    }

    private boolean checkBfFinInfo(DynamicObject changeBill, Long depreuseId) {
        DynamicObjectCollection realEntry = changeBill.getDynamicObjectCollection("realentry");
        for (DynamicObject real : realEntry) {
            DynamicObjectCollection finEntry = real.getDynamicObjectCollection("finentry");
            for (DynamicObject fin : finEntry) {
                DynamicObject bfFinInfo;
                Long depreUseId2Fin = fin.getDynamicObject("depreuse").getLong("id");
                if (depreUseId2Fin.longValue() != depreuseId.longValue() || (bfFinInfo = fin.getDynamicObject("bf_fin_info")) != null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUnGeneratedFinInPeriod(DynamicObject changeBill, Long depreUseId) {
        Long changBillId = changeBill.getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("changebillid", "=", (Object)changBillId), new QFilter("isgenfin", "=", (Object)Boolean.FALSE), new QFilter("isdeleted", "=", (Object)Boolean.FALSE), new QFilter("depreuse", "=", (Object)depreUseId)};
        boolean allUnGenFin = QueryServiceHelper.exists((String)"fa_future_chg_fin_rel", (QFilter[])filters);
        return allUnGenFin;
    }
}

