/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.opplugin.FaBizBaseValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillFeatureValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillLeaseCardValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillSubmitOp;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillBeforeValueValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillChange2WorkloadValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillPreusingAmountValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillRealCardChangeItemValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeCheckMustValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaChangeBillSaveOp
extends AbstractBusyRecordServicePlugin {
    long curTime = 0L;
    private static final Log log = LogFactory.getLog(FaChangeBillSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        this.curTime = System.currentTimeMillis();
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaBizBaseValidator());
        e.addValidator((AbstractValidator)new FaChangeBillPreusingAmountValidator());
        e.addValidator((AbstractValidator)new FaChangeBillFeatureValidator());
        e.addValidator((AbstractValidator)new FaChangeBillLeaseCardValidator());
        e.addValidator((AbstractValidator)new FaChangeBillChange2WorkloadValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection changeFieldEntry = bill.getDynamicObjectCollection("fieldentry");
                    BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)changeFieldEntry);
                    FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "realentry", "realcard.masterid", "fa_change_dept", changeTypeDetail);
                    Map<Long, List<DynamicObject>> changeMap = FaChangeBillSubmitOp.getCardChangeMap(bill);
                    if (changeMap.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u524d\u540e\u7684\u503c\u6ca1\u6709\u53d8\u5316\u3002", (String)"FaChangeBillSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    Long orgId = bill.getDynamicObject("org").getLong("id");
                    Date changeDate = bill.getDate("changedate");
                    DynamicObjectCollection realEntry = bill.getDynamicObjectCollection("realentry");
                    Set numbers = realEntry.stream().map(v -> v.getDynamicObject("realcard").getString("number")).collect(Collectors.toSet());
                    if (changeDate == null) continue;
                    Set existCards = FaUtils.getRealCardCurFin4Numbers((Date)changeDate, (Long)orgId, numbers);
                    int errCount = 0;
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject real : realEntry) {
                        String number = real.getDynamicObject("realcard").getString("number");
                        if (existCards.contains(number)) continue;
                        ++errCount;
                        if (sb.length() > 0) {
                            sb.append("\u3001");
                        }
                        sb.append(number);
                    }
                    if (sb.length() <= 0) continue;
                    String errorMessage = FaUtils.getErrorRealCardMsg((int)errCount, (String)sb.toString());
                    this.addErrorMessage(dataEntity, errorMessage);
                }
            }
        });
        e.addValidator((AbstractValidator)new FaChangeBillRealCardChangeItemValidator());
        e.addValidator((AbstractValidator)new FaChangeBillBeforeValueValidator());
        e.addValidator((AbstractValidator)new FaChangeCheckMustValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.updateChtypedetail(e.getDataEntities());
        FaOpUtils.updateMasterIdByRealCard4Entries(e.getDataEntities(), "fieldentry", "realcard1");
        FaModiRealStatsUtils.saveUpdate_allBill_bizStatus((BeginOperationTransactionArgs)e, (String)"realentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.CHG, (BizStatusEnum)BizStatusEnum.READY);
    }

    private void updateChtypedetail(DynamicObject[] dataEntities) {
        for (DynamicObject changeBill : dataEntities) {
            DynamicObjectCollection fieldList = changeBill.getDynamicObjectCollection("fieldentry");
            BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)fieldList);
            changeBill.set("chtypedetail", (Object)changeTypeDetail.getValue());
            DynamicObjectCollection realList = changeBill.getDynamicObjectCollection("realentry");
            for (DynamicObject realEntry : realList) {
                DynamicObjectCollection finList = realEntry.getDynamicObjectCollection("finentry");
                System.out.println("finList : " + finList.size());
            }
        }
    }

    public void setChangeCardDetail(DynamicObject billDy) {
        Map<Object, Object> changeCardMap = new LinkedHashMap();
        changeCardMap = this.getReal2FinCardMap(billDy);
        for (Map.Entry<Object, Object> realMap : changeCardMap.entrySet()) {
            DynamicObjectCollection realEntries = billDy.getDynamicObjectCollection("realentry");
            DynamicObject realEntry = realEntries.addNew();
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            realEntry.set("realcard", realMap.getKey());
            realEntry.set("aftrealcard", realMap.getKey());
            for (DynamicObject finDy : (List)realMap.getValue()) {
                Long currencyId = finDy.getDynamicObject("currency").getLong("id");
                Long deperuseId = finDy.getDynamicObject("depreuse").getLong("id");
                DynamicObject finEntry = finEntries.addNew();
                finEntry.set("fincard", finDy.getPkValue());
                finEntry.set("currency", (Object)currencyId);
                finEntry.set("depreuse", (Object)deperuseId);
            }
        }
    }

    public Map<Long, List<DynamicObject>> getReal2FinCardMap(DynamicObject billDy) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        ArrayList<Long> finIds = new ArrayList<Long>();
        DynamicObjectCollection fieldDys = billDy.getDynamicObjectCollection("fieldentry");
        for (int i = 0; i < fieldDys.size(); ++i) {
            DynamicObject realCard = ((DynamicObject)fieldDys.get(i)).getDynamicObject("realcard1");
            DynamicObject finCard = ((DynamicObject)fieldDys.get(i)).getDynamicObject("fincard1");
            if (realCard == null || finCard == null) continue;
            Long finID = finCard.getLong("id");
            Long realID = realCard.getLong("id");
            if (finIds.contains(finID)) continue;
            if (result.containsKey(realID)) {
                ((List)result.get(realID)).add(finCard);
            } else {
                ArrayList<DynamicObject> curInitFinLst = new ArrayList<DynamicObject>();
                curInitFinLst.add(finCard);
                result.put(realID, curInitFinLst);
            }
            finIds.add(finID);
        }
        return result;
    }
}

