/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.constants.FaChangeItem;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;

public class FaChangeBillAboutReStartRealBillValidator
extends AbstractValidator {
    public void validate() {
        Map<String, Long> changeBillNo2ChangePeriodIdMap = this.getChangeBillNo2ChangePeriodIdMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set<Long> realCardIdSet;
            Long orgId;
            String billNo;
            Long changePeriodId;
            Set<Long> existsFaReStartRealBillRealCardId;
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObjectCollection changeFieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
            HashMap<Long, String> realCardId2NameMap = new HashMap<Long, String>(16);
            for (DynamicObject changeFieldEntryDynObj : changeFieldEntry) {
                String field = changeFieldEntryDynObj.getString("field");
                if (!FaChangeItem.SYS_INIT_DEPRE_ITEM.contains(field)) continue;
                DynamicObject realCardObj = changeFieldEntryDynObj.getDynamicObject("realcard1");
                long realCardId = realCardObj.getLong("masterid");
                String realCardNumber = realCardObj.getString("number");
                realCardId2NameMap.put(realCardId, realCardNumber);
            }
            if (realCardId2NameMap.isEmpty() || (existsFaReStartRealBillRealCardId = CommonCheckUtils.existsFaReStartRealBill(changePeriodId = changeBillNo2ChangePeriodIdMap.get(billNo = changeBill.getString("billno")), orgId = Long.valueOf(changeBill.getDynamicObject("org").getLong("id")), realCardIdSet = realCardId2NameMap.keySet())).isEmpty()) continue;
            HashSet<String> numberSet = new HashSet<String>(existsFaReStartRealBillRealCardId.size());
            for (Long realCardId : existsFaReStartRealBillRealCardId) {
                String number = (String)realCardId2NameMap.get(realCardId);
                numberSet.add(number);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u53d8\u66f4\u5f53\u671f\u5b58\u5728\u91cd\u542f\u5355\u3002", (String)"FaChangeBillAboutReStartRealBillValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", numberSet));
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private Map<String, Long> getChangeBillNo2ChangePeriodIdMap() {
        HashMap<String, Long> map = new HashMap<String, Long>(this.dataEntities.length);
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            String billNo = changeBill.getString("billno");
            Long orgId = changeBill.getDynamicObject("org").getLong("id");
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (Objects.isNull(mainAssetBookDynObj) && Objects.nonNull(mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"depreuse", "periodtype"})))) {
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            if (Objects.isNull(mainAssetBookDynObj)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e3b\u8d26\u7c3f\u3002", (String)"FaChangeBillAboutReStartRealBillValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            Date changeDate = changeBill.getDate("changedate");
            long periodTypeId = mainAssetBookDynObj.getLong("periodtype");
            DynamicObject changePeriod = PeriodUtil.getPeriodFullObjByDate((Date)changeDate, (long)periodTypeId);
            Long changePeriodId = changePeriod.getLong("id");
            map.put(billNo, changePeriodId);
        }
        return map;
    }
}

