/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.SourceFlagEnum;

public class FaChangeBillRealCardChangeItemValidator
extends AbstractValidator {
    private static final Map<String, String> NOT_SUPPORT_FIELDS = new HashMap<String, String>(3);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection fieldEntity = bill.getDynamicObjectCollection("fieldentry").stream().filter(row -> SourceFlagEnum.DATAASSET.name().equals(row.getDynamicObject("realcard1").getString("sourceflag"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            HashMap<String, Set> realCardChangeItemMap = new HashMap<String, Set>(fieldEntity.size());
            for (DynamicObject row2 : fieldEntity) {
                String field = NOT_SUPPORT_FIELDS.get(row2.getString("field"));
                if (field == null || row2.getString("beforevalue").equals(row2.getString("aftervalue"))) continue;
                String number = row2.getDynamicObject("realcard1").getString("number");
                realCardChangeItemMap.computeIfAbsent(number, items -> new HashSet(3)).add(field);
            }
            if (realCardChangeItemMap.size() <= 0) continue;
            StringBuilder errorMessageSb = new StringBuilder();
            for (Map.Entry entry : realCardChangeItemMap.entrySet()) {
                errorMessageSb.append(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a\u3010%1s\u3011\u7684\u5b9e\u7269\u5361\u7247\u5efa\u5361\u65b9\u5f0f\u662f\u3010\u6570\u636e\u8d44\u4ea7\u3011\uff0c\u4e0d\u652f\u6301\u53d8\u66f4\u3010%2s\u3011\u3002", (String)"FaChangeBillRealCardChangeItemValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()))).append("\r\n");
            }
            this.addErrorMessage(dataEntity, errorMessageSb.toString());
        }
    }

    static {
        NOT_SUPPORT_FIELDS.put("fa_card_real.realaccountdate", ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f", (String)"FaChangeBillRealCardChangeItemValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        NOT_SUPPORT_FIELDS.put("fa_card_real.isstoraged", ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001", (String)"FaChangeBillRealCardChangeItemValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        NOT_SUPPORT_FIELDS.put("fa_card_real.assetamount", ResManager.loadKDString((String)"\u8d44\u4ea7\u6570\u91cf", (String)"FaChangeBillRealCardChangeItemValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
    }
}

