/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaClearApplyBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        Map<String, Object> checkDataMap = this.getCheckDataMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Map orgId2PeriodTypeMap = checkDataMap.getOrDefault("orgId2PeriodTypeMap", new HashMap());
            Map realCardId2FinAccountDateMap = checkDataMap.getOrDefault("realCardId2FinAccountDateMap", new HashMap());
            Date date = dynamicObject.getDate("cleardate");
            Long orgId = (Long)dynamicObject.getDynamicObject("org").getPkValue();
            Long periodType = orgId2PeriodTypeMap.getOrDefault(orgId, 0L);
            DynamicObject periodByDate = FaUtils.getPeriodByDate((Date)date, (long)periodType);
            Date endDate = null;
            if (Objects.nonNull(periodByDate)) {
                endDate = periodByDate.getDate("enddate");
            }
            int rowIndex = 0;
            for (DynamicObject everyRow : dynamicObject.getDynamicObjectCollection("clrapplybill_entry")) {
                ++rowIndex;
                DynamicObject card = everyRow.getDynamicObject("realcard");
                Date finAccountDate = (Date)realCardId2FinAccountDateMap.get((Long)card.getPkValue());
                if (finAccountDate != null && endDate != null && endDate.before(finAccountDate)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u6216\u8005\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1\u3002", (String)"FaClearApplyBillSubmitValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
                    continue;
                }
                BigDecimal assetQty = card.getBigDecimal("assetamount");
                BigDecimal clearQty = everyRow.getBigDecimal("clearqty");
                if (assetQty.compareTo(BigDecimal.ONE) == 0 && clearQty.compareTo(BigDecimal.ONE) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u8d44\u4ea7\u5df2\u505a\u53d8\u66f4\u6216\u62c6\u5206\u4e1a\u52a1\uff0c\u9700\u8981\u91cd\u65b0\u63d0\u4ea4\u6e05\u7406\u7533\u8bf7\u3002", (String)"FaClearApplyBillSubmitValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
                    continue;
                }
                if (clearQty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u6e05\u7406\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u96f6\u3002", (String)"FaClearApplyBillSubmitValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
                    continue;
                }
                if (clearQty.compareTo(assetQty) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u6e05\u7406\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u8d44\u4ea7\u6570\u91cf\u3002", (String)"FaClearApplyBillSubmitValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
            }
        }
    }

    private Map<String, Object> getCheckDataMap() {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        ArrayList<Object> readCardIdList = new ArrayList<Object>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long orgId = (Long)dynamicObject.getDynamicObject("org").getPkValue();
            orgIdSet.add(orgId);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("clrapplybill_entry");
            for (DynamicObject dynObj : dynamicObjectCollection) {
                DynamicObject card = dynObj.getDynamicObject("realcard");
                Object pkValue = card.getPkValue();
                readCardIdList.add(pkValue);
            }
        }
        Map<Long, Date> realCardId2FinAccountDateMap = this.getRealCardId2FinAccountDateMap(readCardIdList);
        HashMap<Long, Long> orgId2PeriodTypeMap = new HashMap<Long, Long>();
        DynamicObjectCollection mainBookByOrgIds = FaUtils.getMainBookByOrgIds(orgIdSet);
        for (DynamicObject mainBook : mainBookByOrgIds) {
            long orgId = mainBook.getLong("org");
            long periodType = mainBook.getLong("periodtype");
            orgId2PeriodTypeMap.put(orgId, periodType);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("orgId2PeriodTypeMap", orgId2PeriodTypeMap);
        result.put("realCardId2FinAccountDateMap", realCardId2FinAccountDateMap);
        return result;
    }

    private Map<Long, Date> getRealCardId2FinAccountDateMap(List<Object> readCardIdList) {
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", readCardIdList)};
        String selectFields = Fa.comma((String[])new String[]{"realcardmasterid", "finaccountdate"});
        HashMap<Long, Date> realCardId2FinAccountDateMap = new HashMap<Long, Date>();
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getLong("realcardmasterid");
            Date finAccountDate = finCard.getDate("finaccountdate");
            realCardId2FinAccountDateMap.put(realCardId, finAccountDate);
        }
        return realCardId2FinAccountDateMap;
    }
}

