/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.model.CompFieldsValuesPo;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.CompFieldsValuesUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.clear.FaClearBillOpUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearBillUnAuditValidator
extends AbstractValidator {
    private static final String[] REAL_CARD_FIELDS_FOR_DepreData = new String[]{"id", "number", "billstatus"};

    public void validate() {
        Map variables = this.getOption().getVariables();
        String isautodispatch = (String)variables.get("ispatch");
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        HashMap<String, String> orgIdAndPeriodId2SumHasVouMsg = new HashMap<String, String>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject clearBill = dataEntity.getDataEntity();
            DynamicObjectCollection entries = clearBill.getDynamicObjectCollection("detail_entry");
            Set realCardPkSet = entries.stream().map(v -> v.get("realcardmasterid")).collect(Collectors.toSet());
            DynamicObject org = clearBill.getDynamicObject("org");
            Optional checkResult = new FutureBizChecker(clearBill.getPkValue(), org.getPkValue(), realCardPkSet, clearBill.getDate("auditdate"), BusyTypeDetailEnum.REAL_FIN_CHG).checkWhenun();
            if (checkResult.isPresent()) {
                String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaOpUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
                throw new KDBizException(msg);
            }
            Boolean disposal = this.checkDisposal(dataEntity.getDataEntity());
            if (disposal.booleanValue()) {
                String errStr = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u5904\u7f6e\u5355\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FaClearBillUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errStr, ErrorLevel.Error);
                continue;
            }
            String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "cleardate");
            if (!bookNames.isEmpty()) {
                String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaClearBillUnAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format("%s:%s\u3002", msgCaption, bookNames));
                continue;
            }
            String msg = FaClearBillOpUtils.checkDepreSumVouncher(orgId2SumMutilVou, dataEntity.getDataEntity(), orgIdAndPeriodId2SumHasVouMsg);
            if (msg != null) {
                this.addMessage(dataEntity, msg);
            }
            this.clearCompFieldValues(dataEntity);
            DynamicObjectCollection realEntries = dataEntity.getDataEntity().getDynamicObjectCollection("detail_entry");
            int i = 1;
            boolean hasError = false;
            for (DynamicObject changeEntry : realEntries) {
                String bizstatus = (String)changeEntry.getDynamicObject("realcard").get("bizstatus");
                String realCardNumber = changeEntry.getDynamicObject("realcard").getString("number");
                if (!("READY".equals(bizstatus) || "DELETE".equals(bizstatus) || isautodispatch != null && isautodispatch.equals("true") && "DISPATCH".equals(bizstatus))) {
                    hasError = true;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u5b58\u5728\u672a\u5b8c\u6210\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u6267\u884c\u5b8c\u672a\u5b8c\u6210\u4e1a\u52a1\u540e\u518d\u8bd5\u3002", (String)"FaClearBillUnAuditValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCardNumber), ErrorLevel.Error);
                }
                ++i;
            }
            if (hasError) continue;
            long srcBillId = clearBill.getLong("srcbill");
            String clearsource = clearBill.getString("clearsource");
            if (clearsource.equals(FaClearSourceEnum.DISPATCH.name()) && (isautodispatch == null || !isautodispatch.equals("true"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6e05\u7406\u5355\u662f\u7531\u8c03\u62e8\u4ea7\u751f\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FaClearBillUnAuditValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (FaClearSourceEnum.LEASE_TERMINATION.name().equals(clearsource) && !variables.containsKey("unAuditFromLease")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6e05\u7406\u5355\u662f\u7531\u79df\u8d41\u7ec8\u6b62\u4ea7\u751f\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FaClearBillUnAuditValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (FaClearSourceEnum.MERGE.name().equals(clearsource) && !variables.containsKey("unAuditFromMerge")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76\u4ea7\u751f\u7684\u6e05\u7406\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaClearBillUnAuditValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (FaClearSourceEnum.SPLIT.name().equals(clearsource) && !variables.containsKey("unAuditFromSplit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u62c6\u5206\u4ea7\u751f\u7684\u6e05\u7406\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaClearBillUnAuditValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            this.checkSrcDispatch_RealCardStatus(dataEntity, srcBillId, clearsource);
        }
    }

    private void clearCompFieldValues(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection clearEntries = bill.getDynamicObjectCollection("detail_entry");
        for (DynamicObject clearEntryEntity : clearEntries) {
            String isclearall = clearEntryEntity.getString("isclearall");
            BigDecimal assetqty = clearEntryEntity.getBigDecimal("assetqty");
            BigDecimal qty_db = clearEntryEntity.getBigDecimal("realcard.assetamount");
            String compfieldsv = clearEntryEntity.getString("compfieldsv");
            CompFieldsValuesPo compFieldsValuesPo = CompFieldsValuesUtils.convert((String)compfieldsv);
            BigDecimal originalval_db = clearEntryEntity.getBigDecimal("fincard.originalval");
            BigDecimal decval_db = clearEntryEntity.getBigDecimal("fincard.decval");
            BigDecimal preresidualval_db = clearEntryEntity.getBigDecimal("fincard.preresidualval");
            String number = clearEntryEntity.getString("realcard.number");
            if (isclearall.equals("1")) {
                if (assetqty.compareTo(qty_db) != 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u8d44\u4ea7\u6570\u91cf[%2$s]\u4e0e\u5b9e\u7269\u5361\u7247\u7684\u6570\u91cf[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, assetqty, qty_db));
                }
                if (compFieldsValuesPo == null || !compFieldsValuesPo.getStyle().equals("S1")) continue;
                BigDecimal originalval = compFieldsValuesPo.getOriginalval();
                BigDecimal decval = compFieldsValuesPo.getDecval();
                BigDecimal preresidualval = compFieldsValuesPo.getPreresidualval();
                if (originalval.compareTo(originalval_db) != 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u539f\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, originalval, originalval_db));
                    continue;
                }
                if (preresidualval.compareTo(preresidualval_db) != 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u6b8b\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, preresidualval, preresidualval_db));
                    continue;
                }
                if (decval.compareTo(decval_db) == 0) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u51cf\u503c\u51c6\u5907[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, decval, decval_db));
                continue;
            }
            BigDecimal clearqty = clearEntryEntity.getBigDecimal("clearqty");
            if (assetqty.compareTo(BigDecimal.ONE) == 0 && (clearqty.compareTo(BigDecimal.ONE) != 0 || qty_db.compareTo(BigDecimal.ONE) != 0)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u8d44\u4ea7\u6570\u91cf[%2$s]\u4e0e\u5b9e\u7269\u5361\u7247\u7684\u6570\u91cf[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, clearqty, qty_db));
            }
            if (assetqty.compareTo(BigDecimal.ONE) > 0 && assetqty.compareTo(clearqty.add(qty_db)) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u8d44\u4ea7\u6570\u91cf[%2$s]\u4e0e\u5b9e\u7269\u5361\u7247\u7684\u6570\u91cf[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, assetqty, clearqty.add(qty_db)));
            }
            if (compFieldsValuesPo == null || !compFieldsValuesPo.getStyle().equals("S1")) continue;
            BigDecimal originalval = compFieldsValuesPo.getOriginalval();
            BigDecimal decval = compFieldsValuesPo.getDecval();
            BigDecimal preresidualval = compFieldsValuesPo.getPreresidualval();
            BigDecimal clearassetvalue = clearEntryEntity.getBigDecimal("assetvalue");
            BigDecimal cleardecval = clearEntryEntity.getBigDecimal("decval");
            BigDecimal clearpreresidualval = clearEntryEntity.getBigDecimal("preresidualval");
            if (originalval.compareTo(originalval_db.add(clearassetvalue)) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u539f\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, originalval, originalval_db.add(clearassetvalue)));
                continue;
            }
            if (preresidualval.compareTo(preresidualval_db.add(clearpreresidualval)) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u6b8b\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, preresidualval, preresidualval_db.add(clearpreresidualval)));
                continue;
            }
            if (decval.compareTo(decval_db.add(cleardecval)) == 0) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u540e\u51cf\u503c\u51c6\u5907[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillUnAuditValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, decval, decval_db.add(cleardecval)));
        }
    }

    private Boolean checkDisposal(DynamicObject billDy) {
        DynamicObjectCollection entry = billDy.getDynamicObjectCollection("detail_entry");
        Set entryIds = entry.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter filter = new QFilter(Fa.dot((String[])new String[]{"detail", "clearbill.id"}), "in", entryIds);
        return QueryServiceHelper.exists((String)"fa_disposal", (QFilter[])filter.toArray());
    }

    private void checkSrcDispatch_RealCardStatus(ExtendedDataEntity dataEntity, long dispatchBillId, String clearsource) {
        if (!clearsource.equals(FaClearSourceEnum.DISPATCH.name())) {
            return;
        }
        QFilter srcBillIdFilter = new QFilter("srcbillid", "=", (Object)dispatchBillId);
        QFilter sourceFlagFilter = new QFilter("sourceflag", "=", (Object)SourceFlagEnum.DISPATCH.name());
        QFilter[] selectCardRealFilter = new QFilter[]{srcBillIdFilter, sourceFlagFilter};
        DynamicObject cardReal = QueryServiceHelper.queryOne((String)"fa_card_real", (String)Fa.join((Object[])REAL_CARD_FIELDS_FOR_DepreData, (String)","), (QFilter[])selectCardRealFilter);
        if (cardReal == null) {
            return;
        }
        String cardRealNumber = cardReal.getString("number");
        String cardRealStatus = cardReal.getString("billstatus");
        if (cardRealStatus.equals(BillStatus.C.name())) {
            String msgCaption = String.format(ResManager.loadKDString((String)"\u8c03\u62e8\u751f\u6210\u7684\u6e05\u7406\u5355\uff0c\u5bf9\u5e94\u7684\u8c03\u5165\u65b9\u5b9e\u7269\u5361\u7247\u3010%s\u3011\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"FaClearBillUnAuditValidator_13", (String)"fi-fa-opplugin", (Object[])new Object[0]), cardRealNumber);
            this.addErrorMessage(dataEntity, msgCaption);
            return;
        }
    }
}

