/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaDispatchBillSaveValidator
extends AbstractValidator {
    public void validate() {
        String type = this.getOperateType();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            int entrySize = dyn.getDynamicObjectCollection("dispatchentry").size();
            if (entrySize != 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDispatchBillSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!"submit".equals(type)) {
            return;
        }
        Map<String, Long> dispatchBillNo2DispatchPeriodIdMap = this.getDispatchBillNo2DispatchPeriodIdMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject org;
            long orgId;
            DynamicObject dyn = dataEntity.getDataEntity();
            Date changedate = dyn.getDate("dispatchdate");
            boolean iscurr = FaBizUtils.isCurrentDate((Date)changedate, (Long)(orgId = dyn.getLong("org_id")));
            if (!iscurr) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u65e5\u671f\u4e0d\u5728\u591a\u4e2a\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7684\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"FaDispatchBillSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if ((org = (DynamicObject)dataEntity.getValue("org")) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u51fa\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FaDispatchBillSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            String errorMsg = FaOpUtils.checkAssetBookStruts(org.getLong("id"));
            if (errorMsg != null) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
                continue;
            }
            DynamicObjectCollection entries = (DynamicObjectCollection)dyn.get("dispatchentry");
            HashMap<Long, String> realCardId2NumberMap = new HashMap<Long, String>(entries.size());
            for (DynamicObject dynObj : entries) {
                DynamicObject realCardDynObj = dynObj.getDynamicObject("realcard");
                if (Objects.isNull(realCardDynObj)) continue;
                long realCardId = Long.parseLong(realCardDynObj.getPkValue().toString());
                String realCardNumber = realCardDynObj.getString("number");
                realCardId2NumberMap.put(realCardId, realCardNumber);
            }
            if (realCardId2NumberMap.size() > 0) {
                String dispatchBillNo = dyn.getString("billno");
                Long dispatchPeriodId = dispatchBillNo2DispatchPeriodIdMap.get(dispatchBillNo);
                Set<Long> realCardIdSet = realCardId2NumberMap.keySet();
                Set<Long> existsFaReStartRealBillRealCardIdSet = CommonCheckUtils.existsFaReStartRealBill(dispatchPeriodId, orgId, realCardIdSet);
                if (existsFaReStartRealBillRealCardIdSet.size() > 0) {
                    HashSet<String> numberSet = new HashSet<String>(existsFaReStartRealBillRealCardIdSet.size());
                    for (Long realCardId : existsFaReStartRealBillRealCardIdSet) {
                        String number = (String)realCardId2NumberMap.get(realCardId);
                        numberSet.add(number);
                    }
                    String errorInfo = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u8c03\u62e8\u5f53\u671f\u5b58\u5728\u91cd\u542f\u5355\u3002", (String)"FaDispatchBillSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", numberSet));
                    this.addErrorMessage(dataEntity, errorInfo);
                }
            }
            try {
                FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "dispatchentry", "realcard.masterid", "fa_dispatch");
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
        this.checkPeriodType(this.dataEntities);
    }

    private Map<String, Long> getDispatchBillNo2DispatchPeriodIdMap() {
        HashMap<String, Long> map = new HashMap<String, Long>(this.dataEntities.length);
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billNo = bill.getString("billno");
            Long orgId = bill.getDynamicObject("org").getLong("id");
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (Objects.isNull(mainAssetBookDynObj) && Objects.nonNull(mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"depreuse", "periodtype"})))) {
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            if (Objects.isNull(mainAssetBookDynObj)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e3b\u8d26\u7c3f\u3002", (String)"FaDispatchBillSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            Date dispatchDate = bill.getDate("dispatchdate");
            long periodTypeId = mainAssetBookDynObj.getLong("periodtype");
            DynamicObject dispatchPeriod = PeriodUtil.getPeriodFullObjByDate((Date)dispatchDate, (long)periodTypeId);
            Long dispatchPeriodId = dispatchPeriod.getLong("id");
            map.put(billNo, dispatchPeriodId);
        }
        return map;
    }

    private void checkPeriodType(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> orgIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            long outOrgId = bill.getLong("org_id");
            long inOrgId = bill.getLong("inorg_id");
            orgIds.add(outOrgId);
            orgIds.add(inOrgId);
        }
        QFilter bookFilter = new QFilter("org", "in", orgIds);
        String selectFields = Fa.comma((String[])new String[]{"org", "depreuse", "periodtype", "depreuse.name"});
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])bookFilter.toArray());
        HashMap<Long, List> orgBookMap = new HashMap<Long, List>(assetBooks.size());
        for (DynamicObject book : assetBooks) {
            long orgId = book.getLong("org");
            List books = orgBookMap.computeIfAbsent(orgId, k -> new ArrayList(4));
            books.add(book);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            long outOrgId = bill.getLong("org_id");
            long inOrgId = bill.getLong("inorg_id");
            List outBooks = (List)orgBookMap.get(outOrgId);
            List inBooks = (List)orgBookMap.get(inOrgId);
            if (inBooks != null) {
                outBooks.addAll(inBooks);
            } else {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5165\u7ec4\u7ec7\u6ca1\u6709\u8d44\u4ea7\u8d26\u7c3f", (String)"FaDispatchBillSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            HashMap<Long, Long> map = new HashMap<Long, Long>(4);
            for (DynamicObject book : outBooks) {
                long depreUseId = book.getLong("depreuse");
                long periodTypeId = book.getLong("periodtype");
                if (!map.containsKey(depreUseId)) {
                    map.put(depreUseId, periodTypeId);
                    continue;
                }
                if ((Long)map.get(depreUseId) == periodTypeId) continue;
                String depreUseName = book.getString("depreuse.name");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u5165\u3001\u8c03\u51fa\u7ec4\u7ec7\u8d44\u4ea7\u8d26\u7c3f\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u64cd\u4f5c\u5931\u8d25\uff1a%s\u3002", (String)"FaDispatchBillSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName));
            }
        }
    }
}

