/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.common.util.Fa;

public class FaDisposalSaveValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> entrysIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            DynamicObjectCollection detail = dyn.getDynamicObjectCollection("detail");
            HashSet<Long> clearBillIdSet = new HashSet<Long>(detail.size());
            for (Object dynamicObject : detail) {
                entrysIds.add(dynamicObject.getLong("clearbill.id"));
                clearBillIdSet.add(dynamicObject.getLong(Fa.dot((String[])new String[]{"clearbill", "id"})));
            }
            this.checkClearBillSource(dataEntity, clearBillIdSet);
        }
        Map<Long, String> statusMap = this.getStatusMap(entrysIds);
        block2: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            DynamicObjectCollection detail = dyn.getDynamicObjectCollection("detail");
            int rowIndex = 1;
            for (DynamicObject dynamicObject : detail) {
                Long entrysId = dynamicObject.getLong("clearbill.id");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)statusMap.get(entrysId))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5904\u7f6e\u8d44\u4ea7\u8be6\u60c5\u5f15\u7528\u7684\u6e05\u7406\u5355\u4e0d\u4e3a\u5ba1\u6838\u72b6\u6001", (String)"FaDisposalSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
                    break;
                }
                Long id = Long.parseLong(dataEntity.getBillPkId().toString());
                Boolean result = this.isDisposaled(entrysId, detail, id);
                if (result.booleanValue()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5df2\u88ab\u5904\u7f6e\u3002", (String)"FaDisposalSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
                }
                ++rowIndex;
            }
            DynamicObjectCollection invoice = dyn.getDynamicObjectCollection("invoice");
            int size = invoice.size();
            Boolean flag = false;
            for (int i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    String invoicenumberCur = ((DynamicObject)invoice.get(i)).getString("invoicenumber");
                    String invoicenumber = ((DynamicObject)invoice.get(j)).getString("invoicenumber");
                    if (!StringUtils.isNotEmpty((CharSequence)invoicenumberCur) || !StringUtils.isNotEmpty((CharSequence)invoicenumber) || !StringUtils.equals((CharSequence)invoicenumberCur, (CharSequence)invoicenumber)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u91cd\u590d", (String)"FaDisposalSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
                    flag = true;
                    break;
                }
                if (flag.booleanValue()) continue block2;
            }
        }
    }

    private void checkClearBillSource(ExtendedDataEntity dataEntity, Set<Long> clearBillIdSet) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", clearBillIdSet), new QFilter("clearsource", "=", (Object)FaClearSourceEnum.MERGE.name())};
        DynamicObjectCollection clearBills = QueryServiceHelper.query((String)"fa_clearbill", (String)"billno", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)clearBills)) {
            String billNos = clearBills.stream().map(t -> t.getString("billno")).collect(Collectors.joining(";"));
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5355[$s]\u7531\u5408\u5e76\u5355\u4ea7\u751f\uff0c\u4e0d\u5141\u8bb8\u505a\u8d44\u4ea7\u5904\u7f6e\u3002", (String)"FaDisposalSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos));
        }
    }

    private Map<Long, String> getStatusMap(List<Long> entrysIds) {
        HashMap<Long, String> map = new HashMap<Long, String>(10);
        DynamicObjectCollection clearbills = QueryServiceHelper.query((String)"fa_clearbill", (String)"id,billstatus,detail_entry", (QFilter[])new QFilter[]{new QFilter("detail_entry.id", "in", entrysIds)});
        for (DynamicObject clearbill : clearbills) {
            map.put(clearbill.getLong("detail_entry"), clearbill.getString("billstatus"));
        }
        return map;
    }

    private Boolean isDisposaled(Long entrysid, DynamicObjectCollection detail, Long id) {
        QFilter entryIdFilter = new QFilter("detail.clearbill.entrysid", "=", (Object)entrysid);
        QFilter disposalIdFilter = new QFilter("id", "!=", (Object)id);
        if (id != 0L) {
            entryIdFilter.and(disposalIdFilter);
        }
        DynamicObject disposal = QueryServiceHelper.queryOne((String)"fa_disposal", (String)"id,detail.clearbill", (QFilter[])new QFilter[]{entryIdFilter});
        Boolean result = false;
        if (disposal != null) {
            result = true;
        }
        return result;
    }
}

