/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.dataasset;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaMutexRequireUtil;

public class DataAssetUnAuditValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> dataObjIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            dataObjIds.add(Long.parseLong(dataEntity.getBillPkId().toString()));
        }
        Set locks = FaMutexRequireUtil.requireMutexBatch((String)"fa_dataasset_card", dataObjIds, (String)"dataasset_mdf", (String)"detailmodify");
        HashMap<Long, String> dataAssetMap = new HashMap<Long, String>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long id = Long.parseLong(dataEntity.getBillPkId().toString());
            String billNo = dataEntity.getBillNo();
            dataAssetMap.put(id, billNo);
            if (locks.contains(id)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u8d44\u4ea7\u6b63\u5728\u8fdb\u884c\u4fee\u6539\u6216\u5931\u6548\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DataAssetUnAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection assetCards = QueryServiceHelper.query((String)"fa_asset_card", (String)"srcbillid", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", dataAssetMap.keySet())});
        HashSet<Long> srcBillIds = new HashSet<Long>(assetCards.size());
        for (DynamicObject assetCard : assetCards) {
            srcBillIds.add(assetCard.getLong("srcbillid"));
        }
        if (srcBillIds.size() > 0) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                long id = Long.parseLong(dataEntity.getBillPkId().toString());
                if (!srcBillIds.contains(id)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"DataAssetUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
        FaMutexRequireUtil.batchRelease((String)"fa_dataasset_card", (Collection)locks, (String)"dataasset_mdf", (String)"detailmodify");
    }
}

