/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.lease.utils.LeaseChangeUtil;
import kd.fi.fa.business.pclock.AbstractPcLockOperationServicePlugIn;
import kd.fi.fa.business.pclock.PcLockConfigBillNoConstants;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.opplugin.lease.FaLeaseChangeBillAuditValidator;
import kd.fi.fa.opplugin.lease.LeaseChangeHandler;

public class FaLeaseChangeBillAuditOp
extends AbstractPcLockOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("leasecontract");
        fieldKeys.add("effectivedate");
        fieldKeys.add("changeitems");
        fieldKeys.add("changebakcontract");
        fieldKeys.add("befcontract");
        fieldKeys.add("aftcontract");
        fieldKeys.add("amortizationdate");
        fieldKeys.add("pushstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaLeaseChangeBillAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.setAmortizationDate(e.getDataEntities());
        new LeaseChangeHandler(e.getDataEntities()).handle();
        this.checkLeaseLiabOriAftChg(e);
        this.setLeaseChangePushStatus(e.getDataEntities());
    }

    private void setLeaseChangePushStatus(DynamicObject[] dataEntities) {
        DynamicObjectCollection existsMappings = QueryServiceHelper.query((String)"fa_change_map", (String)"leasechgitem", (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"leasechgitem", "number"}), "not in", Arrays.asList("payruleentryentity", "leaseenddate"))});
        Set<Long> existsMappingLeaseChgItems = existsMappings.stream().map(v -> v.getLong("leasechgitem")).collect(Collectors.toSet());
        for (DynamicObject dataEntity : dataEntities) {
            boolean isExempt = dataEntity.getDynamicObject("leasecontract").getBoolean("isexempt");
            if (isExempt) {
                dataEntity.set("pushstatus", (Object)"B");
                continue;
            }
            Tuple<Boolean, Boolean> tuple = FaLeaseChangeBillAuditOp.checkChangePayRuleOrEndDateAndValue(dataEntity);
            boolean onlyPayRuleOrEndDateChange = (Boolean)tuple.item1;
            boolean valueChange = (Boolean)tuple.item2;
            if (onlyPayRuleOrEndDateChange) {
                if (!valueChange) continue;
                dataEntity.set("pushstatus", (Object)"B");
                continue;
            }
            if (valueChange || !FaLeaseChangeBillAuditOp.checkLeaseChangeMapAssetChange(dataEntity, existsMappingLeaseChgItems)) continue;
            dataEntity.set("pushstatus", (Object)"B");
        }
    }

    private static boolean checkLeaseChangeMapAssetChange(DynamicObject bill, Set<Long> existsMappingLeaseChgItems) {
        DynamicObjectCollection leaseChangeItemCollection = bill.getDynamicObjectCollection("changeitems");
        Set leaseChangeItemSet = leaseChangeItemCollection.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        return Collections.disjoint(leaseChangeItemSet, existsMappingLeaseChgItems);
    }

    private static Tuple<Boolean, Boolean> checkChangePayRuleOrEndDateAndValue(DynamicObject bill) {
        Set changeFields = LeaseChangeUtil.getChangeFields((DynamicObject)bill);
        if (changeFields.size() == 1) {
            String changeField = (String)changeFields.stream().findFirst().get();
            if ("payruleentryentity".equals(changeField)) {
                return new Tuple((Object)true, (Object)FaLeaseChangeBillAuditOp.checkAssetsValueNoChange(bill));
            }
            if ("leaseenddate".equals(changeField)) {
                return new Tuple((Object)true, (Object)FaLeaseChangeBillAuditOp.checkDepMonthsValueNoChange(bill));
            }
        } else {
            if (changeFields.size() == 2 && changeFields.contains("payruleentryentity") && changeFields.contains("leaseenddate")) {
                return new Tuple((Object)true, (Object)(FaLeaseChangeBillAuditOp.checkAssetsValueNoChange(bill) != false && FaLeaseChangeBillAuditOp.checkDepMonthsValueNoChange(bill) != false ? 1 : 0));
            }
            if (changeFields.contains("payruleentryentity") || changeFields.contains("leaseenddate")) {
                return new Tuple((Object)false, (Object)(FaLeaseChangeBillAuditOp.checkAssetsValueNoChange(bill) == false || FaLeaseChangeBillAuditOp.checkDepMonthsValueNoChange(bill) == false ? 1 : 0));
            }
        }
        return new Tuple((Object)false, (Object)false);
    }

    private static Boolean checkAssetsValueNoChange(DynamicObject bill) {
        DynamicObject befContract = bill.getDynamicObject("befcontract");
        DynamicObject aftContract = bill.getDynamicObject("aftcontract");
        BigDecimal befLeaseAssets = befContract.getBigDecimal("leaseassets") == null ? BigDecimal.ZERO : befContract.getBigDecimal("leaseassets");
        BigDecimal aftLeaseAssets = aftContract.getBigDecimal("leaseassets") == null ? BigDecimal.ZERO : aftContract.getBigDecimal("leaseassets");
        return befLeaseAssets.compareTo(aftLeaseAssets) == 0;
    }

    private static Boolean checkDepMonthsValueNoChange(DynamicObject bill) {
        int aftDepReMonths;
        DynamicObject befContract = bill.getDynamicObject("befcontract");
        DynamicObject aftContract = bill.getDynamicObject("aftcontract");
        int befDepReMonths = befContract.getInt("depremonths");
        return befDepReMonths == (aftDepReMonths = aftContract.getInt("depremonths"));
    }

    protected void setPcLockCofig() {
        this.pcLockCofigBillNoList.add(PcLockConfigBillNoConstants.FA_LEASE_CHANGE_DEFAULT_CONFIG);
    }

    private void checkLeaseLiabOriAftChg(BeginOperationTransactionArgs e) {
        Object[] leaseContractPks = Arrays.stream(e.getDataEntities()).map(v -> v.getDynamicObject("leasecontract").getPkValue()).toArray();
        QFilter contractFilter = new QFilter("id", "in", (Object)leaseContractPks);
        String contractFields = Fa.comma((String[])new String[]{"id", "number", "sourcetype", "initconfirmdate", "sysswitchdate", Fa.dot((String[])new String[]{"payplanentryentity", "planpaydate"}), Fa.dot((String[])new String[]{"payplanentryentity", "unpaidrent"})});
        DynamicObjectCollection contractList = QueryServiceHelper.query((String)"fa_lease_contract", (String)contractFields, (QFilter[])contractFilter.toArray());
        Map<Long, List<DynamicObject>> leaseContractMap = contractList.stream().collect(Collectors.groupingBy(v -> v.getLong("id")));
        QFilter rentSettleFilter = new QFilter("leasecontract", "in", (Object)leaseContractPks);
        String rentSettleFields = Fa.comma((String[])new String[]{"leasecontract", "rent"});
        DynamicObjectCollection rentSettleList = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)rentSettleFields, (QFilter[])rentSettleFilter.toArray());
        Map<Long, List<DynamicObject>> groupRentSettle = rentSettleList.stream().collect(Collectors.groupingBy(v -> v.getLong("leasecontract")));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupRentSettle.entrySet()) {
            Long contractId = entry.getKey();
            BigDecimal sumRent = entry.getValue().stream().map(v -> v.getBigDecimal("rent")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<DynamicObject> plainContract = leaseContractMap.get(contractId);
            if (plainContract == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540cid[%s]\u672a\u627e\u5230\u5408\u540c\u5bf9\u8c61\u3002", (String)"FaLeaseChangeBillAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), contractId));
            }
            BigDecimal totalUnpaidRent = this.getTotalUnpaidRent(plainContract);
            if (sumRent.compareTo(totalUnpaidRent) == 0) continue;
            String contractNumber = plainContract.get(0).getString("number");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u540c[%1$s]\u53d8\u66f4\u540e\uff0c\u644a\u9500\u4e0e\u8ba1\u606f\u7684\u7d2f\u8ba1\u79df\u91d1(%2$s)\u4e0d\u7b49\u4e8e\u672a\u4ed8\u79df\u91d1\u4e4b\u548c(%3$s)\u3002", (String)"FaLeaseChangeBillAuditOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), contractNumber, sumRent.stripTrailingZeros().toPlainString(), totalUnpaidRent.stripTrailingZeros().toPlainString()));
        }
    }

    private BigDecimal getTotalUnpaidRent(List<DynamicObject> plainContract) {
        if (plainContract == null || plainContract.isEmpty()) {
            return BigDecimal.ZERO;
        }
        String sourceType = plainContract.get(0).getString("sourcetype");
        Date initConfirmDate = plainContract.get(0).getDate("initconfirmdate");
        Date sysSwitchDate = plainContract.get(0).getDate("sysswitchdate");
        Date date = LeaseContractSourceType.A.name().equals(sourceType) ? initConfirmDate : sysSwitchDate;
        BigDecimal totalUnpaidRent = BigDecimal.ZERO;
        for (DynamicObject contract : plainContract) {
            Date planPayDate = contract.getDate(Fa.dot((String[])new String[]{"payplanentryentity", "planpaydate"}));
            if (DateUtil.compareDate((Date)planPayDate, (Date)date) < 0) continue;
            BigDecimal unpaidRent = contract.getBigDecimal(Fa.dot((String[])new String[]{"payplanentryentity", "unpaidrent"}));
            totalUnpaidRent = totalUnpaidRent.add(unpaidRent);
        }
        return totalUnpaidRent;
    }

    private void setAmortizationDate(DynamicObject[] dataEntities) {
        long orgId;
        ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
            orgId = leaseContract.getLong(Fa.id((String)"org"));
            orgIdList.add(orgId);
        }
        QFilter filter = new QFilter("org", "in", orgIdList);
        Map leaseInitMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_init"), (QFilter[])filter.toArray());
        HashMap<Long, Date> beginDateMap = new HashMap<Long, Date>(leaseInitMap.size());
        for (DynamicObject leaseInit : leaseInitMap.values()) {
            orgId = leaseInit.getLong(Fa.id((String)"org"));
            DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
            Date beginDate = curPeriod.getDate("begindate");
            beginDateMap.put(orgId, beginDate);
        }
        for (DynamicObject bill : dataEntities) {
            DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
            long orgId2 = leaseContract.getLong(Fa.id((String)"org"));
            Date curPeriodBeginDate = (Date)beginDateMap.get(orgId2);
            if (curPeriodBeginDate == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u540c[%s]\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u5c1a\u672a\u8fdb\u884c\u79df\u8d41\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u3002", (String)"FaLeaseChangeBillAuditOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseContract.getString("number")));
            }
            Date effectiveDate = bill.getDate("effectivedate");
            if (DateUtil.compareDate((Date)effectiveDate, (Date)curPeriodBeginDate) < 0) {
                bill.set("amortizationdate", (Object)curPeriodBeginDate);
                continue;
            }
            bill.set("amortizationdate", (Object)effectiveDate);
        }
    }
}

