/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.lease.utils.LeaseChangeUtil;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.pclock.AbstractPcLockOperationServicePlugIn;
import kd.fi.fa.business.pclock.PcLockConfigBillNoConstants;
import kd.fi.fa.opplugin.lease.FaLeaseChangeBillSubmitValidator;

public class FaLeaseChangeBillSubmitOp
extends AbstractPcLockOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("leasecontract");
        fieldKeys.add("effectivedate");
        fieldKeys.add("changeitems");
        fieldKeys.add("changebakcontract");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject aftContract = LeaseChangeUtil.getAftContractForValidate((OperateOption)this.getOption(), (AddValidatorsEventArgs)e);
        e.addValidator((AbstractValidator)new FaLeaseChangeBillSubmitValidator().buildAftContract(aftContract));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        LeaseChangeUtil.updateChangeBakContract((OperateOption)this.getOption(), (BeginOperationTransactionArgs)e);
        Map<Long, DynamicObject> changeBakContractMap = this.getAllChangeBakContract(e.getDataEntities());
        for (DynamicObject bill : e.getDataEntities()) {
            if (!LeaseChangeUtil.isEffectPayPlan((DynamicObject)bill)) continue;
            DynamicObject changeBakContract = bill.getDynamicObject("changebakcontract");
            changeBakContract = changeBakContractMap.get(changeBakContract.getLong("id"));
            DynamicObject oriContract = bill.getDynamicObject("leasecontract");
            oriContract = changeBakContractMap.get(oriContract.getLong("id"));
            LeaseUtil.generatePayPlan4Chg((DynamicObject)changeBakContract, (DynamicObject)oriContract);
            LeaseUtil.calLeaseContractAmount4Submit((DynamicObject)changeBakContract);
        }
        SaveServiceHelper.save((DynamicObject[])changeBakContractMap.values().toArray(new DynamicObject[0]));
    }

    private Map<Long, DynamicObject> getAllChangeBakContract(DynamicObject[] bills) {
        ArrayList<Long> changeBakContractIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject changeBakContract = bill.getDynamicObject("changebakcontract");
            changeBakContractIds.add(changeBakContract.getLong("id"));
            DynamicObject oriContract = bill.getDynamicObject("leasecontract");
            changeBakContractIds.add(oriContract.getLong("id"));
        }
        DynamicObject[] changeBakContractArr = BusinessDataServiceHelper.load((Object[])changeBakContractIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        return Arrays.stream(changeBakContractArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
    }

    protected void setPcLockCofig() {
        this.pcLockCofigBillNoList.add(PcLockConfigBillNoConstants.FA_LEASE_CHANGE_DEFAULT_CONFIG);
    }
}

