/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaLeaseChangeDeleteAssetChangeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaLeaseChangeDeleteAssetChangeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("leasecontract");
        fieldKeys.add("auditdate");
        fieldKeys.add("pushstatus");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> leaseChangeBillIds = new HashSet<Long>(4);
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(dataEntities.length);
        Map<Long, Set<Object>> leaseId2ChangeIds = this.befDeleteChangeBillOp(dataEntities, leaseChangeBillIds, errorInfoList);
        if (!leaseChangeBillIds.isEmpty()) {
            try {
                OperationResult result = (OperationResult)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fa", (String)"DeleteAssetChangeBillService", (String)"deleteBySourceIdsIgnoreRight", (Object[])new Object[]{leaseChangeBillIds});
                this.operationResult.setSuccess(result.isSuccess());
                this.operationResult.getAllErrorInfo().addAll(result.getAllErrorInfo());
                List successPkIds = result.getSuccessPkIds();
                this.operationResult.setSuccessPkIds(successPkIds);
                this.aftDeleteChangeBillOp(leaseId2ChangeIds, successPkIds, dataEntities);
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        } else {
            this.operationResult.setSuccess(false);
            this.operationResult.setSuccessPkIds(new ArrayList(1));
        }
        this.operationResult.getAllErrorInfo().addAll(errorInfoList);
    }

    private void aftDeleteChangeBillOp(Map<Long, Set<Object>> leaseId2ChangeIds, List<Object> successPkIds, DynamicObject[] dataEntities) {
        if (!successPkIds.isEmpty()) {
            ArrayList<Long> needUpdateIds = new ArrayList<Long>(leaseId2ChangeIds.size());
            for (Map.Entry<Long, Set<Object>> map : leaseId2ChangeIds.entrySet()) {
                Set<Object> changeBillIds = map.getValue();
                changeBillIds.removeAll(successPkIds);
                if (!changeBillIds.isEmpty()) continue;
                needUpdateIds.add(map.getKey());
            }
            DynamicObject[] updateData = BusinessDataServiceHelper.load((Object[])needUpdateIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_change_bill"));
            for (DynamicObject bill : dataEntities) {
                Object id = bill.getPkValue();
                if (!needUpdateIds.contains(id)) continue;
                bill.set("pushstatus", (Object)"A");
            }
            for (DynamicObject data : updateData) {
                data.set("pushstatus", (Object)"A");
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
            SaveServiceHelper.save((DynamicObject[])updateData);
        }
    }

    private Map<Long, Set<Object>> befDeleteChangeBillOp(DynamicObject[] dataEntities, Set<Long> leaseChangeBillIds, List<OperateErrorInfo> errorInfoList) {
        Set leaseChangeIds = Arrays.stream(dataEntities).map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection changeBills = QueryServiceHelper.query((String)"fa_change_dept", (String)Fa.comma((String[])new String[]{"id", "sourceid"}), (QFilter[])new QFilter[]{new QFilter("sourceid", "in", leaseChangeIds)});
        HashMap<Long, Set<Object>> leaseId2ChangeIds = new HashMap<Long, Set<Object>>(leaseChangeBillIds.size(), 1.0f);
        for (DynamicObject changeBill : changeBills) {
            long leaseChangeId = changeBill.getLong("sourceid");
            long changeBillId = changeBill.getLong("id");
            Set changeBillIds = leaseId2ChangeIds.computeIfAbsent(leaseChangeId, v -> new HashSet(2, 1.0f));
            changeBillIds.add(changeBillId);
        }
        for (DynamicObject dataEntity : dataEntities) {
            Long leaseChangeId = dataEntity.getLong("id");
            if (leaseId2ChangeIds.containsKey(leaseChangeId)) {
                leaseChangeBillIds.add(leaseChangeId);
                continue;
            }
            OperateErrorInfo operateError = new OperateErrorInfo();
            operateError.setPkValue(dataEntity.getPkValue());
            String leaseChangeBillNo = dataEntity.getString("billno");
            operateError.setMessage(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u4e0d\u5b58\u5728\u5173\u8054\u5355\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeDeleteAssetChangeOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
            operateError.setLevel(ErrorLevel.Error);
            errorInfoList.add(operateError);
        }
        return leaseId2ChangeIds;
    }
}

