/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.utils.FaUtils;

public class FaLeaseContractInitPushValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            List<String> errorInfo = this.validateForPush(bill);
            for (String error : errorInfo) {
                this.addErrorMessage(dataEntity, error);
            }
        }
    }

    private List<String> validateForPush(DynamicObject leaseContractInit) {
        String checkDate;
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        String isPushMsg = this.validateForPushByInit(leaseContractInit);
        if (isPushMsg != null) {
            errorInfo.add(isPushMsg);
        }
        if ((checkDate = this.checkAssetBookPeriodAndSysSwitchDate(leaseContractInit)) != null) {
            errorInfo.add(checkDate);
        }
        this.checkLeaseContractExemptStatus(leaseContractInit, errorInfo);
        return errorInfo;
    }

    private void checkLeaseContractExemptStatus(DynamicObject leaseContractInit, List<String> errorInfo) {
        boolean isExempt = leaseContractInit.getBoolean("isexempt");
        if (isExempt) {
            String number = leaseContractInit.getString("number");
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f7\uff1a%s \u662f\u8c41\u514d\u5408\u540c\uff0c\u65e0\u987b\u4e0b\u63a8\u3002", (String)"FaLeaseContractInitPushValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
        }
    }

    private String validateForPushByInit(DynamicObject leaseContractInit) {
        String errorInfo = null;
        long masterId = leaseContractInit.getLong("masterid");
        boolean push = BFTrackerServiceHelper.isPush((String)"fa_lease_contract_init", (Long)masterId);
        if (push) {
            String number = leaseContractInit.getString("number");
            errorInfo = String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f7\uff1a%s \u5b58\u5728\u540e\u7eed\u5b9e\u7269\u5361\u7247\uff0c\u4e0b\u63a8\u5931\u8d25\u3002", (String)"FaLeaseContractInitPushValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), number);
        }
        return errorInfo;
    }

    private String checkAssetBookPeriodAndSysSwitchDate(DynamicObject leaseContractInit) {
        long orgId = leaseContractInit.getDynamicObject("org").getLong("id");
        Date sysSwitchDate = leaseContractInit.getDate("sysswitchdate");
        DynamicObject mainBook = FaUtils.getMainBookDyByOrg((Long)orgId);
        if (mainBook == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6838\u7b97\u7ec4\u7ec7\u7684\u4e3b\u8d26\u7c3f\u3002", (String)"FaLeaseContractInitPushValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        }
        String status = mainBook.getString("status");
        DynamicObject enablePeriod = mainBook.getDynamicObject("startperiod");
        Date enablePeriodBeginDate = enablePeriod.getDate("begindate");
        Date enablePeriodEndDate = enablePeriod.getDate("enddate");
        if (sysSwitchDate.before(enablePeriodBeginDate)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u4e0d\u80fd\u65e9\u4e8e\u5bf9\u5e94\u6838\u7b97\u7ec4\u7ec7\u8d44\u4ea7\u4e3b\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u3002", (String)"FaLeaseContractInitPushValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        }
        if (BillStatus.C.name().equals(status)) {
            DynamicObject currentPeriod = mainBook.getDynamicObject("curperiod");
            Date currentPeriodBeginDate = currentPeriod.getDate("begindate");
            Date currentPeriodEndDate = currentPeriod.getDate("enddate");
            if (enablePeriodBeginDate.compareTo(sysSwitchDate) <= 0 && enablePeriodEndDate.compareTo(sysSwitchDate) >= 0) {
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u4e3a\u8d26\u7c3f\u542f\u7528\u671f\u95f4\uff0c\u4f46\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"FaLeaseContractInitPushValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            }
            if (sysSwitchDate.after(enablePeriodEndDate) && sysSwitchDate.before(currentPeriodBeginDate) || sysSwitchDate.after(currentPeriodEndDate)) {
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u4e0d\u5728\u5f53\u524d\u8d26\u7c3f\u671f\u95f4\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"FaLeaseContractInitPushValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            }
        } else if (sysSwitchDate.after(enablePeriodEndDate)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u4e0d\u5728\u5f53\u524d\u8d26\u7c3f\u671f\u95f4\uff0c\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"FaLeaseContractInitPushValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        }
        return null;
    }
}

