/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaLeaseDeInitializationOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("org");
        fieldKeys.add("startperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashSet<Long> orgIds = new HashSet<Long>(FaUtils.getInitialCapacity43((int)dataEntities.length));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject leaseInit = dataEntity.getDataEntity();
                    orgIds.add(leaseInit.getLong(Fa.id((String)"org")));
                    if (!"B".equals(leaseInit.getString("status"))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%s]\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u9700\u518d\u6b21\u53cd\u521d\u59cb\u5316\u3002", (String)"FaLeaseDeInitializationOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseInit.getString(Fa.dot((String[])new String[]{"org", "name"}))));
                }
                DynamicObjectCollection assetBook = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)true)});
                Map<Long, Long> orgIdToCurPeriodId = assetBook.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getLong("curperiod")));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    long leaseStartCurPeriodId;
                    DynamicObject leaseInit = dataEntity.getDataEntity();
                    long orgId = leaseInit.getLong(Fa.id((String)"org"));
                    Long assetBookCurPeriodId = orgIdToCurPeriodId.get(orgId);
                    if (assetBookCurPeriodId == null || (leaseStartCurPeriodId = leaseInit.getLong(Fa.id((String)"startperiod"))) >= assetBookCurPeriodId) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u665a\u4e8e\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u80fd\u53cd\u521d\u59cb\u5316\u3002", (String)"FaLeaseDeInitializationOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseInit.getString(Fa.dot((String[])new String[]{"org", "name"}))));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("status", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

