/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.lease.FaLeaseInitSaveValidator;

public class FaLeaseInitSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaLeaseInitSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Set orgIds = Arrays.stream(dataEntities).map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toSet());
        QFilter[] qFilters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)true)};
        DynamicObjectCollection assetBook = QueryServiceHelper.query((String)"fa_assetbook", (String)"org", (QFilter[])qFilters);
        Set existsBookOrgIds = assetBook.stream().map(v -> v.getLong("org")).collect(Collectors.toSet());
        if (existsBookOrgIds.size() != dataEntities.length) {
            int length = dataEntities.length - existsBookOrgIds.size();
            ArrayList<DynamicObject> newAssetBookList = new ArrayList<DynamicObject>(length);
            DynamicObject defaultDepreUse = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_depreuse", (QFilter[])new QFilter[]{new QFilter("default", "=", (Object)true)});
            if (defaultDepreUse != null) {
                for (DynamicObject dataEntity : dataEntities) {
                    long orgId = dataEntity.getLong(Fa.id((String)"org"));
                    if (existsBookOrgIds.contains(orgId)) continue;
                    newAssetBookList.add(this.generateAssetBook(dataEntity, defaultDepreUse));
                }
                SaveServiceHelper.save((DynamicObject[])newAssetBookList.toArray(new DynamicObject[0]));
            }
        }
    }

    private DynamicObject generateAssetBook(DynamicObject dataEntity, DynamicObject depreUse) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"fa_assetbook");
        DynamicObject assetBook = new DynamicObject((DynamicObjectType)mainEntityType);
        long id = DBServiceHelper.genLongIds((String)"t_fa_assetbook", (int)1)[0];
        assetBook.set("id", (Object)id);
        DynamicObject org = dataEntity.getDynamicObject("org");
        String assetBookNumber = org.getString("number") + depreUse.getString("number");
        String assetBookName = org.getString("name") + depreUse.getString("name");
        assetBook.set("number", (Object)assetBookNumber);
        assetBook.set("name", (Object)assetBookName);
        assetBook.set("status", (Object)"B");
        assetBook.set("creator", dataEntity.get("creator"));
        assetBook.set("enable", (Object)"0");
        assetBook.set("createtime", dataEntity.get("createtime"));
        assetBook.set("masterid", (Object)id);
        assetBook.set("org", (Object)dataEntity.getDynamicObject("org"));
        assetBook.set("depreuse", (Object)depreUse);
        assetBook.set("depresystem", dataEntity.get("depresystem"));
        assetBook.set("basecurrency", dataEntity.get("basecurrency"));
        assetBook.set("exchangetable", dataEntity.get("exchangetable"));
        assetBook.set("periodtype", dataEntity.get("periodtype"));
        assetBook.set("startperiod", dataEntity.get("startperiod"));
        assetBook.set("curperiod", dataEntity.get("startperiod"));
        assetBook.set("ismainbook", (Object)true);
        return assetBook;
    }
}

