/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaLeaseInitSaveValidator
extends AbstractValidator {
    public void validate() {
        this.checkUpdateLeaseInit();
        this.checkLeaseInitData4AssetBook();
    }

    private void checkUpdateLeaseInit() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            long id;
            DynamicObject leaseInit = dataEntity.getDataEntity();
            boolean fromDatabase = leaseInit.getDataEntityState().getFromDatabase();
            if (!fromDatabase || (id = leaseInit.getLong("id")) == 0L) continue;
            long orgId = leaseInit.getLong(Fa.id((String)"org"));
            boolean existsLeaseContract = QueryServiceHelper.exists((String)"fa_lease_contract", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            if (!existsLeaseContract) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u79df\u8d41\u5408\u540c/\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"FaLeaseInitSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkLeaseInitData4AssetBook() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashMap<Long, ExtendedDataEntity> org2LeaseInit = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long orgId = (Long)dataEntity.getValue(Fa.id((String)"org"));
            org2LeaseInit.put(orgId, dataEntity);
        }
        String field = Fa.comma((String[])new String[]{"org", "depresystem", "basecurrency", "exchangetable", "periodtype", "startperiod"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", org2LeaseInit.keySet()), new QFilter("ismainbook", "=", (Object)true)};
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)field, (QFilter[])filters);
        if (!assetBooks.isEmpty()) {
            for (DynamicObject assetBook : assetBooks) {
                long startPeriodId;
                long periodTypeId;
                long exchangeTableId;
                long baseCurrencyId;
                long orgId = assetBook.getLong("org");
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)org2LeaseInit.get(orgId);
                long depreSystemId = assetBook.getLong("depresystem");
                if (depreSystemId != (Long)dataEntity.getValue(Fa.id((String)"depresystem"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u8d44\u4ea7\u653f\u7b56\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaLeaseInitSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((baseCurrencyId = assetBook.getLong("basecurrency")) != (Long)dataEntity.getValue(Fa.id((String)"basecurrency"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u4e3b\u4e1a\u52a1\u5e01\u522b\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaLeaseInitSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((exchangeTableId = assetBook.getLong("exchangetable")) != (Long)dataEntity.getValue(Fa.id((String)"exchangetable"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u6c47\u7387\u8868\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaLeaseInitSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((periodTypeId = assetBook.getLong("periodtype")) != (Long)dataEntity.getValue(Fa.id((String)"periodtype"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u671f\u95f4\u7c7b\u578b\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaLeaseInitSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((startPeriodId = assetBook.getLong("startperiod")) <= (Long)dataEntity.getValue(Fa.id((String)"startperiod"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u65e9\u4e8e\u4e3b\u8d26\u7c3f\u542f\u7528\u671f\u95f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaLeaseInitSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

