/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.lease.LeaseTerminationHandler;
import kd.fi.fa.business.model.LeaseTerminationParam;
import kd.fi.fa.opplugin.lease.FaLeaseTerminationValidator;

public class FaLeaseTerminationOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaLeaseTerminationValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
            ArrayList<LeaseTerminationParam> params = new ArrayList<LeaseTerminationParam>(entry.size());
            for (DynamicObject row : entry) {
                DynamicObject contract = row.getDynamicObject("leasecontract");
                long contractId = contract.getLong("id");
                Date leaseTerminationDate = row.getDate("leaseterminationdate");
                DynamicObject changeMode = row.getDynamicObject("changemode");
                long changeModeId = changeMode.getLong("id");
                Date renewalEndDate = row.getDate("renewalenddate");
                params.add(new LeaseTerminationParam(contractId, leaseTerminationDate, changeModeId, renewalEndDate));
            }
            new LeaseTerminationHandler(params).handle();
        }
    }
}

