/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.lease.BackupMode;
import kd.fi.fa.business.enums.lease.InterestDetailSourceType;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.lease.InterestDetailGenerator4LeaseChange;
import kd.fi.fa.business.lease.RentSettleGenerator4LeaseChange;
import kd.fi.fa.business.lease.backup.LeaseContractBackupUtils;
import kd.fi.fa.business.lease.model.PayRuleCompareResult;
import kd.fi.fa.business.lease.utils.LeaseChangeUtil;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseChangeHandler {
    private static final Log logger = LogFactory.getLog(LeaseChangeHandler.class);
    private static final Map<String, Set<String>> LINKAGE_FIELDS = new HashMap<String, Set<String>>(4);
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private final DynamicObject[] bills;
    private final Map<Long, BackupMode> backupModeMap = new HashMap<Long, BackupMode>(32);
    private Map<Long, DynamicObject> contractMap = new HashMap<Long, DynamicObject>(0);
    private Map<Long, DynamicObject> interestDetailMap = new HashMap<Long, DynamicObject>(0);
    private final List<DynamicObject> contract4Save = new ArrayList<DynamicObject>(32);
    private final Map<Long, BigDecimal> totalAssetsAmountBefChgMap = new HashMap<Long, BigDecimal>(32);
    private final Map<Long, BigDecimal> totalAssetsAmountAftChgMap = new HashMap<Long, BigDecimal>(32);
    private final Map<Long, BigDecimal> effectiveDateBeginBalanceBefChgMap = new HashMap<Long, BigDecimal>(32);
    private final Map<Long, BigDecimal> effectiveDateBeginBalanceAftChgMap = new HashMap<Long, BigDecimal>(32);
    private final Map<Long, DynamicObject> leaseInitMap = new HashMap<Long, DynamicObject>(32);

    public LeaseChangeHandler(DynamicObject[] bills) {
        this.bills = bills;
        this.loadContractData(bills);
        this.loadInterestDetailData(bills);
    }

    public void handle() {
        for (DynamicObject bill : this.bills) {
            this.buildBefContract(bill);
        }
        for (DynamicObject bill : this.bills) {
            this.doChange(bill);
        }
        this.batchUpdateData();
        for (DynamicObject bill : this.bills) {
            this.buildAftContract(bill);
        }
    }

    private void doChange(DynamicObject bill) {
        Set changeFields = LeaseChangeUtil.getChangeFields((DynamicObject)bill);
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        leaseContract = this.contractMap.get(leaseContract.getLong("id"));
        DynamicObject changeBakContract = bill.getDynamicObject("changebakcontract");
        changeBakContract = this.contractMap.get(changeBakContract.getLong("id"));
        DynamicObject befContract = bill.getDynamicObject("befcontract");
        Date effectiveDate = bill.getDate("effectivedate");
        leaseContract.set("version", (Object)this.formatDate(effectiveDate));
        leaseContract.set("isinitdata", (Object)false);
        leaseContract.set("previousbackid", (Object)befContract.getLong("id"));
        for (String field : changeFields) {
            this.copyField(changeBakContract, leaseContract, field);
            Set<String> linkageFields = LINKAGE_FIELDS.get(field);
            if (linkageFields == null || linkageFields.isEmpty()) continue;
            for (String linkageField : linkageFields) {
                this.copyField(changeBakContract, leaseContract, linkageField);
            }
        }
        if (LeaseChangeUtil.isEffectPayPlan((DynamicObject)bill)) {
            boolean isDiscountRateChanged = changeFields.contains("discountrate");
            this.updatePayPlanAndRelatedInfo(befContract, changeBakContract, leaseContract, effectiveDate, isDiscountRateChanged);
            boolean rentsettlestatus = LeaseUtil.isNeedRentSettle((DynamicObject)changeBakContract);
            if (rentsettlestatus) {
                leaseContract.set("rentsettlestatus", (Object)LeaseContractRentSettleStatus.C.name());
            } else {
                leaseContract.set("rentsettlestatus", (Object)LeaseContractRentSettleStatus.B.name());
            }
        }
        this.updatePlanEntrySrcContractId(befContract, leaseContract, effectiveDate);
        this.contract4Save.add(leaseContract);
    }

    private void copyField(DynamicObject changeBakContract, DynamicObject leaseContract, String field) {
        MainEntityType contractType = EntityMetadataCache.getDataEntityType((String)"fa_lease_contract");
        DynamicProperty property = contractType.getProperty(field);
        if (property instanceof EntryProp) {
            this.copyEntryWithoutHisData(changeBakContract, leaseContract, field);
        } else {
            this.copyCommonField(changeBakContract, leaseContract, field);
        }
    }

    private void copyCommonField(DynamicObject fromDyn, DynamicObject toDyn, String field) {
        Object aftValue = fromDyn.get(field);
        toDyn.set(field, aftValue);
    }

    private void copyEntryWithoutHisData(DynamicObject fromDyn, DynamicObject toDyn, String field) {
        DynamicObjectCollection entry = toDyn.getDynamicObjectCollection(field);
        entry.clear();
        this.copyEntry(fromDyn, toDyn, field);
    }

    private void copyEntry(DynamicObject fromDyn, DynamicObject toDyn, String field) {
        this.copyEntry(fromDyn, toDyn, field, new ArrayList<String>(0));
    }

    private void copyEntry(DynamicObject fromDyn, DynamicObject toDyn, String field, List<String> excludeFields) {
        if (fromDyn == null || toDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u88ab\u590d\u5236\u5bf9\u8c61\u201d\u6216\u201c\u5f85\u66f4\u65b0\u5bf9\u8c61\u201d\u4e3a\u7a7a, \u201c\u88ab\u590d\u5236\u5bf9\u8c61\u201d\uff1a[%1$s], \u201c\u5f85\u66f4\u65b0\u5bf9\u8c61\u201d\uff1a[%2$s]", (String)"LeaseChangeHandler_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), fromDyn, toDyn));
        }
        if (!fromDyn.getDataEntityType().getName().equals(toDyn.getDataEntityType().getName())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8c61\u7c7b\u578b\u4e0d\u4e00\u81f4: \u201c\u88ab\u590d\u5236\u5bf9\u8c61\u201d\uff1a[%1$s], \u201c\u5f85\u66f4\u65b0\u5bf9\u8c61\u201d\uff1a[%2$s]", (String)"LeaseChangeHandler_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), fromDyn.getDataEntityType().getName(), toDyn.getDataEntityType().getName()));
        }
        MainEntityType entityType = (MainEntityType)fromDyn.getDataEntityType();
        if (!(entityType.getProperty(field) instanceof EntryProp)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u590d\u5236\u7684\u5b57\u6bb5[%s]\u4e0d\u662f\u5206\u5f55\u7c7b\u578b", (String)"LeaseChangeHandler_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), field));
        }
        Set entryFields = ((EntityType)entityType.getAllEntities().get(field)).getFields().keySet();
        DynamicObjectCollection fromEntry = fromDyn.getDynamicObjectCollection(field);
        DynamicObjectCollection toEntry = toDyn.getDynamicObjectCollection(field);
        int seq = toEntry.size() + 1;
        for (DynamicObject fromRow : fromEntry) {
            DynamicObject newRow = toEntry.addNew();
            newRow.set("seq", (Object)seq++);
            for (String key : entryFields) {
                if (excludeFields.contains(key)) continue;
                Object value = fromRow.get(key);
                newRow.set(key, value);
            }
        }
    }

    private void updatePayPlanAndRelatedInfo(DynamicObject befContract, DynamicObject changeBakContract, DynamicObject leaseContract, Date effectiveDate, boolean isDiscountRateChanged) {
        PayRuleCompareResult compareResult = LeaseChangeUtil.comparePayRule((DynamicObject)befContract, (DynamicObject)changeBakContract, (Date)effectiveDate);
        this.prepareDataBefCopyPayPlan(leaseContract);
        this.copyPayPlan(changeBakContract, leaseContract, effectiveDate);
        this.calLeaseLiabAndAssetsData4PayPlan(leaseContract, effectiveDate, compareResult, isDiscountRateChanged);
        this.prepareDataAftCopyPayPlan(leaseContract);
        BackupMode backupMode = this.setBackupMode(leaseContract, compareResult, isDiscountRateChanged);
        if (backupMode == BackupMode.ALLDATA) {
            this.prepareDataBefUpdateInterestDetail(leaseContract, effectiveDate);
            this.updateInterestDetail(leaseContract, effectiveDate);
            this.prepareDataAftUpdateInterestDetail(leaseContract, effectiveDate);
            this.updateRentSettle(leaseContract);
        }
        this.updateFinInfo(leaseContract, compareResult, isDiscountRateChanged);
    }

    private void copyPayPlan(DynamicObject changeBakContract, DynamicObject leaseContract, Date effectiveDate) {
        DynamicObjectCollection chgPlanEntry = changeBakContract.getDynamicObjectCollection("payplanentryentity");
        HashMap<String, Date> chgNumber2ObjMap = new HashMap<String, Date>(chgPlanEntry.size(), 1.0f);
        for (DynamicObject chgPlan : chgPlanEntry) {
            DynamicObject payItem = chgPlan.getDynamicObject("plan_payitem");
            String payItemClass = payItem.getString("accountingclass");
            if (!"C".equals(payItemClass)) continue;
            chgNumber2ObjMap.put(chgPlan.getString("plannumber"), chgPlan.getDate("plan_enddate"));
        }
        DynamicObjectCollection oriPlanEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        HashMap<String, Date> oriNumber2ObjMap = new HashMap<String, Date>(oriPlanEntry.size(), 1.0f);
        for (DynamicObject oriPlan : oriPlanEntry) {
            DynamicObject payItem = oriPlan.getDynamicObject("plan_payitem");
            String payItemClass = payItem.getString("accountingclass");
            if (!"C".equals(payItemClass)) continue;
            oriNumber2ObjMap.put(oriPlan.getString("plannumber"), oriPlan.getDate("plan_enddate"));
        }
        Iterator oriIterator = oriPlanEntry.iterator();
        while (oriIterator.hasNext()) {
            String chgEndDateStr;
            String endDateStr;
            Date chgEndDate;
            DynamicObject row = (DynamicObject)oriIterator.next();
            Date planPayDate = row.getDate("planpaydate");
            Date endDate = row.getDate("plan_enddate");
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String payItemClass = payItem.getString("accountingclass");
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) >= 0) {
                oriIterator.remove();
                continue;
            }
            if (!"C".contains(payItemClass) || (chgEndDate = (Date)chgNumber2ObjMap.get(row.getString("plannumber"))) == null || (endDateStr = format.format(endDate)).equals(chgEndDateStr = format.format(chgEndDate))) continue;
            oriIterator.remove();
        }
        Iterator chgIterator = chgPlanEntry.iterator();
        while (chgIterator.hasNext()) {
            String oriEndDateStr;
            String endDateStr;
            DynamicObject row = (DynamicObject)chgIterator.next();
            Date planPayDate = row.getDate("planpaydate");
            Date endDate = row.getDate("plan_enddate");
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String payItemClass = payItem.getString("accountingclass");
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) < 0 && !"C".equals(payItemClass)) {
                chgIterator.remove();
                continue;
            }
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) >= 0 || !"C".equals(payItemClass)) continue;
            Date oriEndDate = (Date)oriNumber2ObjMap.get(row.getString("plannumber"));
            boolean toHold = false;
            if (oriEndDate != null && !(endDateStr = format.format(endDate)).equals(oriEndDateStr = format.format(oriEndDate))) {
                toHold = true;
            }
            if (toHold) continue;
            chgIterator.remove();
        }
        ArrayList<String> excludeFields = new ArrayList<String>(2);
        excludeFields.add("planentrysrcid");
        excludeFields.add("contractsrcid");
        this.copyEntry(changeBakContract, leaseContract, "payplanentryentity", excludeFields);
        oriPlanEntry.sort((o1, o2) -> {
            String number1 = o1.getString("plannumber");
            String number2 = o2.getString("plannumber");
            return number1.compareTo(number2);
        });
        int seq = 1;
        for (DynamicObject row : oriPlanEntry) {
            row.set("seq", (Object)seq++);
        }
    }

    private void updatePlanEntrySrcContractId(DynamicObject befContract, DynamicObject leaseContract, Date effectiveDate) {
        long leaseContractId = leaseContract.getLong("id");
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject row : planEntry) {
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) < 0) {
                long planEntrySrcContractId = row.getLong(Fa.id((String)"contractsrcid"));
                if (planEntrySrcContractId != leaseContractId && planEntrySrcContractId != 0L) continue;
                row.set("contractsrcid", (Object)befContract);
                continue;
            }
            row.set("contractsrcid", (Object)leaseContract);
        }
    }

    private void calLeaseLiabAndAssetsData4PayPlan(DynamicObject leaseContract, Date effectiveDate, PayRuleCompareResult compareResult, boolean isDiscountRateChanged) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = org.getLong("id");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int amtPrecision = currency.getInt("amtprecision");
        BigDecimal dailyDiscountRate = leaseContract.getBigDecimal("dailydiscountrate");
        BigDecimal dailyDiscountRate4Cal = dailyDiscountRate.divide(FaBigDecimalUtil.HUNDRED, 8, 4);
        String transitionPlan = leaseContract.getString("transitionplan");
        boolean isDeductVatDiscount = SystemParamHelper.getBooleanParam((String)"is_deduct_vat_discount", (long)orgId, (boolean)false);
        Set changedPayItemClass = compareResult.getChangedPayItemClass();
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject row : planEntry) {
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) < 0) continue;
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            if (!changedPayItemClass.contains("A") && !isDiscountRateChanged) continue;
            boolean deductible = row.getBoolean("plan_deductible");
            BigDecimal rent = row.getBigDecimal("rent");
            BigDecimal rentNoTax = row.getBigDecimal("rentnotax");
            BigDecimal unpaidRent = row.getBigDecimal("unpaidrent");
            int liabDiscountDays = 0;
            String acctClass = payItem.getString("accountingclass");
            if ("A".equals(acctClass) && DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) >= 0) {
                liabDiscountDays = DateUtil.getDiffDays((Date)effectiveDate, (Date)planPayDate);
            }
            row.set("discountdays", (Object)liabDiscountDays);
            BigDecimal liabDiscountFactor = BigDecimal.ONE.add(dailyDiscountRate4Cal).pow(liabDiscountDays).setScale(6, 4);
            row.set("discountfactor", (Object)liabDiscountFactor);
            BigDecimal liabPresentValue = BigDecimal.ZERO;
            if ("A".equals(acctClass)) {
                liabPresentValue = unpaidRent.divide(liabDiscountFactor, amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            }
            row.set("presentvalue", (Object)liabPresentValue);
            if (!TransitionPlan.A.name().equals(transitionPlan) && !TransitionPlan.C.name().equals(transitionPlan)) continue;
            int assetsDiscountDays = 0;
            if ("A".equals(acctClass) && DateUtil.compareDate((Date)planPayDate, (Date)effectiveDate) >= 0) {
                assetsDiscountDays = DateUtil.getDiffDays((Date)effectiveDate, (Date)planPayDate);
            }
            row.set("discountdays2", (Object)assetsDiscountDays);
            BigDecimal assetsDiscountFactor = BigDecimal.ONE.add(dailyDiscountRate4Cal).pow(assetsDiscountDays).setScale(6, 4);
            row.set("discountfactor2", (Object)assetsDiscountFactor);
            BigDecimal assetsPresentValue = BigDecimal.ZERO;
            if ("A".equals(acctClass)) {
                BigDecimal amountTemp = deductible && !isDeductVatDiscount ? rentNoTax : rent;
                assetsPresentValue = amountTemp.divide(assetsDiscountFactor, amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            }
            row.set("presentvalue2", (Object)assetsPresentValue);
        }
    }

    private void prepareDataBefCopyPayPlan(DynamicObject leaseContract) {
        long leaseContractId = leaseContract.getLong("id");
        this.totalAssetsAmountBefChgMap.put(leaseContractId, this.calTotalAssetsAmount(leaseContract));
    }

    private void prepareDataAftCopyPayPlan(DynamicObject leaseContract) {
        long leaseContractId = leaseContract.getLong("id");
        this.totalAssetsAmountAftChgMap.put(leaseContractId, this.calTotalAssetsAmount(leaseContract));
    }

    private BigDecimal calTotalAssetsAmount(DynamicObject leaseContract) {
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String acctClass = payItem.getString("accountingclass");
            if (!"B".equals(acctClass)) continue;
            boolean deductible = row.getBoolean("plan_deductible");
            if (deductible) {
                BigDecimal rentNoTax = row.getBigDecimal("rentnotax");
                total = total.add(rentNoTax);
                continue;
            }
            BigDecimal rent = row.getBigDecimal("rent");
            total = total.add(rent);
        }
        return total;
    }

    private BackupMode setBackupMode(DynamicObject leaseContract, PayRuleCompareResult compareResult, boolean isDiscountRateChanged) {
        long contractId = leaseContract.getLong("id");
        if (isDiscountRateChanged) {
            this.backupModeMap.put(contractId, BackupMode.ALLDATA);
            return BackupMode.ALLDATA;
        }
        Set changedPayItemClass = compareResult.getChangedPayItemClass();
        if (changedPayItemClass.contains("A")) {
            this.backupModeMap.put(contractId, BackupMode.ALLDATA);
            return BackupMode.ALLDATA;
        }
        this.backupModeMap.put(contractId, BackupMode.BASICDATA);
        return BackupMode.BASICDATA;
    }

    private void updateInterestDetail(DynamicObject leaseContract, Date effectiveDate) {
        DynamicObjectCollection entry;
        long leaseContractId = leaseContract.getLong("id");
        DynamicObject interestDetail = this.interestDetailMap.get(leaseContractId);
        if (interestDetail != null) {
            boolean hisPeriodEffective = this.isHisPeriodEffective(leaseContract, effectiveDate);
            if (hisPeriodEffective) {
                this.processInterestDetailIfHisPeriodEffective(leaseContract, effectiveDate, interestDetail);
            }
            entry = interestDetail.getDynamicObjectCollection("detailentry");
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                Date date = row.getDate("date");
                boolean latestData = row.getBoolean("latestdata");
                if (DateUtil.compareDate((Date)date, (Date)effectiveDate) < 0 || !latestData) continue;
                iterator.remove();
            }
        }
        DynamicObject tempInterestDetail = new InterestDetailGenerator4LeaseChange(leaseContract, effectiveDate).generate4LeaseChange();
        if (interestDetail != null) {
            this.copyEntry(tempInterestDetail, interestDetail, "detailentry");
        } else {
            interestDetail = tempInterestDetail;
            interestDetail.set("leasecontract", (Object)leaseContract);
            this.interestDetailMap.put(leaseContractId, interestDetail);
        }
        entry = interestDetail.getDynamicObjectCollection("detailentry");
        entry.sort((o1, o2) -> {
            String sourceType2;
            String contractVersion2;
            String contractVersion1 = o1.getString("contractversion");
            if (!contractVersion1.equals(contractVersion2 = o2.getString("contractversion"))) {
                return contractVersion1.compareTo(contractVersion2);
            }
            String sourceType1 = o1.getString("sourcetype");
            if (!sourceType1.equals(sourceType2 = o2.getString("sourcetype"))) {
                return sourceType2.compareTo(sourceType1);
            }
            Date date1 = o1.getDate("date");
            Date date2 = o2.getDate("date");
            return DateUtil.compareDate((Date)date1, (Date)date2);
        });
        int seq = 1;
        for (DynamicObject row : entry) {
            row.set("seq", (Object)seq++);
        }
    }

    private void processInterestDetailIfHisPeriodEffective(DynamicObject leaseContract, Date effectiveDate, DynamicObject interestDetail) {
        String aftChgVersion = leaseContract.getString("version");
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(leaseContract);
        DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
        Date curPeriodBeginDate = curPeriod.getDate("begindate");
        DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
        if (DateUtil.compareDate((Date)effectiveDate, (Date)curPeriodBeginDate) >= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u4e0d\u5728\u5386\u53f2\u671f\u95f4\uff0c\u65e0\u9700\u51b2\u9500\u8ba1\u606f\u660e\u7ec6\uff0c\u751f\u6548\u65e5[%1$s]\uff0c\u5f53\u671f\u5f00\u59cb\u65e5[%2$s]\u3002", (String)"LeaseChangeHandler_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), effectiveDate, curPeriodBeginDate));
        }
        int size = detailEntry.size();
        for (int i = 0; i < size; ++i) {
            boolean latestData;
            DynamicObject row = (DynamicObject)detailEntry.get(i);
            Date date = row.getDate("date");
            if (DateUtil.compareDate((Date)date, (Date)effectiveDate) < 0 || DateUtil.compareDate((Date)date, (Date)curPeriodBeginDate) >= 0 || !(latestData = row.getBoolean("latestdata"))) continue;
            row.set("latestdata", (Object)Boolean.FALSE);
            BigDecimal beginBalance = row.getBigDecimal("beginbalance");
            BigDecimal leaseLiabPay = row.getBigDecimal("leaseliabpay");
            BigDecimal leaseLiabInt = row.getBigDecimal("leaseliabint");
            BigDecimal endBalance = row.getBigDecimal("endbalance");
            BigDecimal realDailyRate = row.getBigDecimal("realdailyrate");
            DynamicObject reverseData = detailEntry.addNew();
            reverseData.set("date", (Object)date);
            reverseData.set("beginbalance", (Object)beginBalance.negate());
            reverseData.set("leaseliabpay", (Object)leaseLiabPay.negate());
            reverseData.set("leaseliabint", (Object)leaseLiabInt.negate());
            reverseData.set("endbalance", (Object)endBalance.negate());
            reverseData.set("realdailyrate", (Object)realDailyRate);
            reverseData.set("amortizationperiod", (Object)curPeriod);
            reverseData.set("sourcetype", (Object)InterestDetailSourceType.C.name());
            reverseData.set("latestdata", (Object)Boolean.FALSE);
            reverseData.set("contractversion", (Object)aftChgVersion);
        }
    }

    private boolean isHisPeriodEffective(DynamicObject leaseContract, Date effectiveDate) {
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(leaseContract);
        DynamicObject curPeriod = leaseInit.getDynamicObject("curperiod");
        Date beginDate = curPeriod.getDate("begindate");
        return DateUtil.compareDate((Date)effectiveDate, (Date)beginDate) < 0;
    }

    private void prepareDataBefUpdateInterestDetail(DynamicObject leaseContract, Date effectiveDate) {
        long contractId = leaseContract.getLong("id");
        this.effectiveDateBeginBalanceBefChgMap.put(contractId, this.getEffectiveDateBeginBalance(contractId, effectiveDate));
    }

    private void prepareDataAftUpdateInterestDetail(DynamicObject leaseContract, Date effectiveDate) {
        long contractId = leaseContract.getLong("id");
        this.effectiveDateBeginBalanceAftChgMap.put(contractId, this.getEffectiveDateBeginBalance(contractId, effectiveDate));
    }

    private BigDecimal getEffectiveDateBeginBalance(long leaseContractId, Date effectiveDate) {
        DynamicObject intDetail = this.interestDetailMap.get(leaseContractId);
        if (intDetail == null) {
            logger.info(String.format("getEffectiveDateBeginBalance -> \u672a\u627e\u5230\u8ba1\u606f\u660e\u7ec6\u6570\u636e\uff0ccontractId\uff1a%s", leaseContractId));
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection detailEntry = intDetail.getDynamicObjectCollection("detailentry");
        for (DynamicObject row : detailEntry) {
            Date date = row.getDate("date");
            boolean latestData = row.getBoolean("latestdata");
            if (DateUtil.compareDate((Date)date, (Date)effectiveDate) != 0 || !latestData) continue;
            return row.getBigDecimal("beginbalance");
        }
        logger.info(String.format("\u5b58\u5728\u8ba1\u606f\u660e\u7ec6\u6570\u636e\uff0c\u4f46\u662f\u6ca1\u6709\u53d8\u66f4\u751f\u6548\u65e5\u5f53\u5929\u7684\u5206\u5f55\u884c\uff0ccontractId\uff1a%s", leaseContractId));
        return BigDecimal.ZERO;
    }

    private void updateFinInfo(DynamicObject leaseContract, PayRuleCompareResult compareResult, boolean isDiscountRateChanged) {
        boolean isExempt = leaseContract.getBoolean("isexempt");
        if (isExempt) {
            return;
        }
        Set changedPayItemClass = compareResult.getChangedPayItemClass();
        if (!isDiscountRateChanged && changedPayItemClass.size() == 1 && changedPayItemClass.contains("C")) {
            return;
        }
        String sourceType = leaseContract.getString("sourcetype");
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        BigDecimal leaseLiabOri = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            Date planPayDate = row.getDate("planpaydate");
            if (LeaseContractSourceType.B.name().equals(sourceType) && DateUtil.compareDate((Date)planPayDate, (Date)sysSwitchDate) < 0) continue;
            BigDecimal unPaidRent = row.getBigDecimal("unpaidrent");
            leaseLiabOri = leaseLiabOri.add(unPaidRent);
        }
        long leaseContractId = leaseContract.getLong("id");
        BigDecimal leaseLiab = leaseContract.getBigDecimal("leaseliab");
        BigDecimal beginBalanceAftChg = this.effectiveDateBeginBalanceAftChgMap.getOrDefault(leaseContractId, BigDecimal.ZERO);
        BigDecimal beginBalanceBefChg = this.effectiveDateBeginBalanceBefChgMap.getOrDefault(leaseContractId, BigDecimal.ZERO);
        leaseLiab = leaseLiab.add(beginBalanceAftChg.subtract(beginBalanceBefChg));
        BigDecimal leaseAssets = leaseContract.getBigDecimal("leaseassets");
        BigDecimal totalAmountAftChg = this.totalAssetsAmountAftChgMap.get(leaseContractId);
        BigDecimal totalAmountBefChg = this.totalAssetsAmountBefChgMap.get(leaseContractId);
        leaseAssets = leaseAssets.add(beginBalanceAftChg.subtract(beginBalanceBefChg)).add(totalAmountAftChg.subtract(totalAmountBefChg));
        if (isDiscountRateChanged || changedPayItemClass.contains("A")) {
            leaseContract.set("leaseliabori", (Object)leaseLiabOri);
            leaseContract.set("leaseliab", (Object)leaseLiab);
        }
        if (isDiscountRateChanged || changedPayItemClass.contains("A") || changedPayItemClass.contains("B")) {
            leaseContract.set("leaseassets", (Object)leaseAssets);
        }
    }

    private void updateRentSettle(DynamicObject leaseContract) {
        DynamicObject interestDetail = this.interestDetailMap.get(leaseContract.getLong("id"));
        DynamicObject leaseInit = this.getLeaseInitFromLocalCache(leaseContract);
        long curPeriodId = leaseInit.getLong(Fa.id((String)"curperiod"));
        new RentSettleGenerator4LeaseChange(leaseContract, interestDetail, curPeriodId).regenerate();
    }

    private void buildBefContract(DynamicObject bill) {
        DynamicObject befContract = bill.getDynamicObject("befcontract");
        if (befContract != null) {
            return;
        }
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        leaseContract = this.contractMap.get(leaseContract.getLong("id"));
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "=", (Object)leaseContract.getLong("masterid")), new QFilter("version", "=", (Object)leaseContract.getString("version")), new QFilter("isbak", "=", (Object)true)};
        String selectFields = Fa.comma((String[])new String[]{"plan_payitem", "plannumber", "plan_startdate", "leaseassets", "depremonths", "plan_enddate", "planpaydate", "plan_invoicetype", "plan_deductible", "plan_taxrate", "rentnotax", "tax", "rent", "unpaidrent"});
        befContract = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_contract", (String)selectFields, (QFilter[])filters);
        if (befContract == null) {
            befContract = LeaseContractBackupUtils.backup((Long)leaseContract.getLong("id"), (BackupMode)BackupMode.ALLDATA);
        }
        bill.set("befcontract", (Object)befContract);
    }

    private void buildAftContract(DynamicObject bill) {
        DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
        long contractId = leaseContract.getLong("id");
        BackupMode backupMode = this.backupModeMap.getOrDefault(contractId, BackupMode.BASICDATA);
        DynamicObject aftContract = LeaseContractBackupUtils.backup((Long)contractId, (BackupMode)backupMode);
        bill.set("aftcontract", (Object)aftContract);
    }

    private void batchUpdateData() {
        Object[] saveContractResult = SaveServiceHelper.save((DynamicObject[])this.contract4Save.toArray(new DynamicObject[0]));
        if (saveContractResult.length != this.contract4Save.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u53d8\u66f4\u540e\u5408\u540c\u5931\u8d25\uff0c\u5f85\u4fdd\u5b58[%1$s]\u6761\uff0c\u5b9e\u9645\u4fdd\u5b58[%2$s]\u6761\u3002", (String)"LeaseChangeHandler_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), this.contract4Save.size(), saveContractResult.length));
        }
        Object[] saveInterestDetailResult = SaveServiceHelper.save((DynamicObject[])this.interestDetailMap.values().toArray(new DynamicObject[0]));
        if (saveInterestDetailResult.length != this.interestDetailMap.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u53d8\u66f4\u540e\u8ba1\u606f\u660e\u7ec6\u8868\u5931\u8d25\uff0c\u5f85\u4fdd\u5b58[%1$s]\u6761\uff0c\u5b9e\u9645\u4fdd\u5b58[%2$s]\u6761\u3002", (String)"LeaseChangeHandler_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), this.interestDetailMap.size(), saveInterestDetailResult.length));
        }
    }

    private DynamicObject getLeaseInitFromLocalCache(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = org.getLong("id");
        DynamicObject leaseInit = this.leaseInitMap.get(orgId);
        if (leaseInit == null) {
            leaseInit = BusinessDataServiceHelper.loadSingle((String)"fa_lease_init", (String)"curperiod", (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
            if (leaseInit == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7[%s]\u7684\u79df\u8d41\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"LeaseChangeHandler_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), org.getString("number")));
            }
            this.leaseInitMap.put(orgId, leaseInit);
        }
        return leaseInit;
    }

    private void loadContractData(DynamicObject[] bills) {
        ArrayList<Long> contractIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject aftContract;
            DynamicObject befContract;
            DynamicObject changeBakContract;
            DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
            if (leaseContract != null) {
                contractIds.add(leaseContract.getLong("id"));
            }
            if ((changeBakContract = bill.getDynamicObject("changebakcontract")) != null) {
                contractIds.add(changeBakContract.getLong("id"));
            }
            if ((befContract = bill.getDynamicObject("befcontract")) != null) {
                contractIds.add(befContract.getLong("id"));
            }
            if ((aftContract = bill.getDynamicObject("aftcontract")) == null) continue;
            contractIds.add(aftContract.getLong("id"));
        }
        DynamicObject[] contractArr = BusinessDataServiceHelper.load((Object[])contractIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        this.contractMap = Arrays.stream(contractArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
    }

    private void loadInterestDetailData(DynamicObject[] bills) {
        ArrayList<Long> contractIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject leaseContract = bill.getDynamicObject("leasecontract");
            long leaseContractId = leaseContract.getLong("id");
            contractIds.add(leaseContractId);
        }
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "in", contractIds)};
        DynamicObjectCollection intDetailsOnlyPk = QueryServiceHelper.query((String)"fa_interest_detail", (String)"id", (QFilter[])filters);
        Object[] intDetailIds = intDetailsOnlyPk.stream().map(v -> v.getLong("id")).toArray();
        DynamicObject[] intDetails = BusinessDataServiceHelper.load((Object[])intDetailIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_interest_detail"));
        this.interestDetailMap = Arrays.stream(intDetails).collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"leasecontract")), v -> v));
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return dateFormat.format(date);
    }

    static {
        LINKAGE_FIELDS.put("discountrate", (Set<String>)new HashSet<String>(){
            {
                this.add("dailydiscountrate");
            }
        });
        LINKAGE_FIELDS.put("leaseenddate", (Set<String>)new HashSet<String>(){
            {
                this.add("leasemonths");
                this.add("depremonths");
            }
        });
    }
}

