/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.model.CompFieldsValuesPo;
import kd.fi.fa.business.utils.CompFieldsValuesUtils;
import kd.fi.fa.common.util.Fa;

public class FaMergeBillAuditCompFieldValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (this.validateContext.getValidateResults().getErrorDataIndexs().contains(dataEntity.getDataEntityIndex())) continue;
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inEntry : inEntryEntity) {
                String inCompFieldsV = inEntry.getString("incompfieldsv");
                CompFieldsValuesPo inCompFieldsValuesPo = CompFieldsValuesUtils.convert((String)inCompFieldsV);
                if (inCompFieldsValuesPo == null) continue;
                Long inFinCardId = inEntry.getLong(Fa.id((String)"infincard"));
                this.checkCompFieldsV(inCompFieldsValuesPo, inFinCardId, dataEntity);
                DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
                for (DynamicObject outEntry : outEntryEntity) {
                    String outCompFieldsV = outEntry.getString("outcompfieldsv");
                    CompFieldsValuesPo outCompFieldsValuesPo = CompFieldsValuesUtils.convert((String)outCompFieldsV);
                    if (outCompFieldsValuesPo == null) continue;
                    Long outFinCardId = outEntry.getLong(Fa.id((String)"outfincard"));
                    this.checkCompFieldsV(outCompFieldsValuesPo, outFinCardId, dataEntity);
                }
            }
        }
    }

    private void checkCompFieldsV(CompFieldsValuesPo compFieldsValuesPo, Long finCardId, ExtendedDataEntity dataEntity) {
        if (compFieldsValuesPo.getStyle().equals("S1")) {
            BigDecimal originalVal = compFieldsValuesPo.getOriginalval();
            BigDecimal decVal = compFieldsValuesPo.getDecval();
            BigDecimal preResidualVal = compFieldsValuesPo.getPreresidualval();
            DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"number", "originalval", "decval", "preresidualval"}), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finCardId)});
            if (finCard == null) {
                return;
            }
            BigDecimal originalValDb = finCard.getBigDecimal("originalval");
            BigDecimal decValDb = finCard.getBigDecimal("decval");
            BigDecimal preResidualValDb = finCard.getBigDecimal("preresidualval");
            String number = finCard.getString("number");
            if (originalVal.compareTo(originalValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u5408\u5e76\u524d\u539f\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillAuditCompFieldValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, originalVal, originalValDb));
            }
            if (preResidualVal.compareTo(preResidualValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u5408\u5e76\u524d\u6b8b\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillAuditCompFieldValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, preResidualVal, preResidualValDb));
            }
            if (decVal.compareTo(decValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u5408\u5e76\u524d\u51cf\u503c\u51c6\u5907[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillAuditCompFieldValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, decVal, decValDb));
            }
        }
    }
}

