/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.clear.ClearBillHDGenerator;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.convertor.MergeBill2ClearBillConvertor;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.merge.FaMergeBillAuditCompFieldValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillDepreSumValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;

public class FaMergeBillAuditOp
extends AbstractBizCtrOperationServicePlugIn
implements IFaOpHandler {
    private static final String BEGIN_ARGS = "beginArgs";
    private static final String[] SELECTOR = new String[]{"originalval", "monthorigvalchg", "yearorigvalchg"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("mergedate");
        fieldKeys.add("mergeperiod");
        fieldKeys.add("type");
        fieldKeys.add("realcard");
        fieldKeys.add("inentryentity");
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "infincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "indepreuse"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inoriginalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inaccumdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "indecval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inpreresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "beforeinfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "afterinfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "incompfieldsv"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inchangemode"}));
        fieldKeys.add("inbasecurrency");
        fieldKeys.add("outdepreuse");
        fieldKeys.add("outentryentity");
        fieldKeys.add("outbasecurrency");
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outfincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "OUTREALCARDMASTERID"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outoriginalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outaccumdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outdecval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outpreresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "afteroutfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "beforeoutfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outcompfieldsv"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outchangemode"}));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMergeBillDepreSumValidator());
        e.addValidator((AbstractValidator)new FaMergeBillAuditCompFieldValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        HashMap<String, BeginOperationTransactionArgs> otherParams = new HashMap<String, BeginOperationTransactionArgs>(1, 1.0f);
        otherParams.put(BEGIN_ARGS, e);
        FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operationKey, (String)"fa_mergebill", (DynamicObject[])e.getDataEntities(), otherParams, (IFaOpHandler)this);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        if (dataEntities.length == 0) {
            return;
        }
        BeginOperationTransactionArgs e = (BeginOperationTransactionArgs)otherParams.get(BEGIN_ARGS);
        IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
        MainEntityType dynamicCardType = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        HashSet<DynamicObject> snapshots = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> dynamicCards = new HashSet<DynamicObject>(16);
        for (DynamicObject dataEntity : dataEntities) {
            Map<Long, Map<Long, Long>> real2depreUse2FinCard;
            String type = dataEntity.getString("type");
            if ("1".equals(type)) {
                FaModiRealStatsUtils.updateMergeBillCardBizStatus((DynamicObject)dataEntity, (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.MERGING);
                Map<Long, DynamicObject> befFinCard2Snapshot = FaMergeBillUtils.genFinCardSnapshot4MergeBill(dataEntity, true);
                snapshots.addAll(befFinCard2Snapshot.values());
                real2depreUse2FinCard = new HashMap<Long, Map<Long, Long>>(8);
                long periodId = dataEntity.getLong(Fa.id((String)"mergeperiod"));
                DynamicObjectCollection inEntryEntity = dataEntity.getDynamicObjectCollection("inentryentity");
                for (DynamicObject inEntry : inEntryEntity) {
                    long inRealCardId = inEntry.getLong("inrealcardmasterid");
                    long depreUseId = inEntry.getLong(Fa.id((String)"indepreuse"));
                    Map inReal2depreUse2FinCard = fCardDao.copyFinCards(periodId, depreUseId, new Object[]{inRealCardId}, v -> this.inFinCardMergeHandle(inEntry, v), SELECTOR, null);
                    real2depreUse2FinCard = FaCommonUtils.mergeMap(real2depreUse2FinCard, (Map)inReal2depreUse2FinCard);
                    DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
                    Set outRealCardIds = outEntryEntity.stream().map(v -> v.getLong("OUTREALCARDMASTERID")).collect(Collectors.toSet());
                    Map outReal2depreUse2FinCard = fCardDao.copyFinCards(periodId, depreUseId, outRealCardIds.toArray(), v -> this.outFinCardMergeHandle(outEntryEntity, v, periodId), SELECTOR, null);
                    real2depreUse2FinCard = FaCommonUtils.mergeMap(real2depreUse2FinCard, (Map)outReal2depreUse2FinCard);
                    long assetBookId = inEntry.getLong(Fa.dot((String[])new String[]{"infincard", Fa.id((String)"org")}));
                    new DepreSplitSum().updateDepreSplit4ChangeBill(Long.valueOf(assetBookId), Long.valueOf(depreUseId), outRealCardIds);
                }
            } else {
                e.setCancelOperation(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u7c7b\u578b\u7684\u5408\u5e76\u64cd\u4f5c", (String)"FaMergeBillAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            this.updateFinCard(dataEntity, real2depreUse2FinCard);
            Map<Long, DynamicObject> aftFinCard2Snapshot = FaMergeBillUtils.genFinCardSnapshot4MergeBill(dataEntity, false);
            snapshots.addAll(aftFinCard2Snapshot.values());
            this.inCard2DynamicCard(dataEntity, dynamicCardType, dynamicCards);
            this.generateClearBillByMerge(dataEntity.getPkValue());
        }
        if (!snapshots.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])snapshots.toArray(new DynamicObject[0]));
        }
        if (!dynamicCards.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
    }

    private void updateFinCard(DynamicObject dataEntity, Map<Long, Map<Long, Long>> real2depreUse2FinCard) {
        HashSet<Long> finCardIds = new HashSet<Long>(8);
        for (Map.Entry<Long, Map<Long, Long>> mapEntry : real2depreUse2FinCard.entrySet()) {
            Map<Long, Long> depreUse2FinCard = mapEntry.getValue();
            for (Map.Entry<Long, Long> depreUse2FinCardMap : depreUse2FinCard.entrySet()) {
                finCardIds.add(depreUse2FinCardMap.getValue());
            }
        }
        Map finCardId2FinCard = BusinessDataServiceHelper.loadFromCache((Object[])finCardIds.toArray(), (String)"fa_card_fin");
        DynamicObjectCollection inEntryEntity = dataEntity.getDynamicObjectCollection("inentryentity");
        for (DynamicObject inEntry : inEntryEntity) {
            Long inRealCardId = inEntry.getLong("inrealcardmasterid");
            Long depreUseId = inEntry.getLong(Fa.id((String)"indepreuse"));
            Long inFinCardId = real2depreUse2FinCard.get(inRealCardId).get(depreUseId);
            if (inFinCardId != null) {
                inEntry.set(Fa.id((String)"infincard"), (Object)inFinCardId);
                inEntry.set("infincard", finCardId2FinCard.get(inFinCardId));
            }
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryEntity) {
                Long outRealCardId = outEntry.getLong("OUTREALCARDMASTERID");
                Long outFinCardId = real2depreUse2FinCard.get(outRealCardId).get(depreUseId);
                if (outFinCardId == null) continue;
                outEntry.set(Fa.id((String)"outfincard"), (Object)outFinCardId);
                outEntry.set("outfincard", finCardId2FinCard.get(outFinCardId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private void inCard2DynamicCard(DynamicObject mergeBill, MainEntityType type, Set<DynamicObject> dynamicCards) {
        DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
        Set depreUseIds = inEntryEntity.stream().map(v -> v.getLong(Fa.id((String)"indepreuse"))).collect(Collectors.toSet());
        long realCardId = ((DynamicObject)inEntryEntity.get(0)).getLong("inrealcardmasterid");
        DynamicObjectCollection existsDynamicCards = QueryServiceHelper.query((String)"fa_card_dynamic", (String)"depreuse", (QFilter[])new QFilter[]{new QFilter("realcard", "=", (Object)realCardId), new QFilter("depreuse", "in", depreUseIds)});
        Set existDepreUseIds = existsDynamicCards.stream().map(v -> v.getLong("depreuse")).collect(Collectors.toSet());
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "depreuse"}), (QFilter[])new QFilter("org", "=", (Object)mergeBill.getLong(Fa.id((String)"org"))).toArray());
        Map<Long, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.getLong("depreuse"), v -> v.getLong("id")));
        for (DynamicObject inEntry : inEntryEntity) {
            Long depreUseId = inEntry.getLong(Fa.id((String)"indepreuse"));
            if (existDepreUseIds.contains(depreUseId)) continue;
            DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
            dynamicCard.set("realcard", (Object)realCardId);
            dynamicCard.set("assetbook", (Object)bookMap.get(depreUseId));
            dynamicCard.set("depreuse", (Object)depreUseId);
            dynamicCard.set("date", (Object)mergeBill.getDate("mergedate"));
            dynamicCard.set("entityname", (Object)"fa_mergebill");
            dynamicCard.set("changebillid", mergeBill.getPkValue());
            dynamicCard.set("sourcename", (Object)mergeBill.getString("billno"));
            dynamicCards.add(dynamicCard);
        }
    }

    private void inFinCardMergeHandle(DynamicObject inEntry, DynamicObject finCard) {
        BigDecimal inOriginalVal = inEntry.getBigDecimal("inoriginalval");
        BigDecimal inAccumDepre = inEntry.getBigDecimal("inaccumdepre");
        BigDecimal inDecVal = inEntry.getBigDecimal("indecval");
        BigDecimal inPreResidualVal = inEntry.getBigDecimal("inpreresidualval");
        BigDecimal newOriginalVal = finCard.getBigDecimal("originalval").add(inOriginalVal);
        finCard.set("originalval", (Object)newOriginalVal);
        BigDecimal finAccumDepre = finCard.getBigDecimal("accumdepre");
        BigDecimal newAccumDepre = finAccumDepre.add(inAccumDepre);
        finCard.set("accumdepre", (Object)newAccumDepre);
        BigDecimal newDecVal = finCard.getBigDecimal("decval").add(inDecVal);
        finCard.set("decval", (Object)newDecVal);
        finCard.set("preresidualval", (Object)finCard.getBigDecimal("preresidualval").add(inPreResidualVal));
        BigDecimal newNetWorth = newOriginalVal.subtract(newAccumDepre);
        finCard.set("networth", (Object)newNetWorth);
        BigDecimal newNetAmount = newNetWorth.subtract(newDecVal);
        finCard.set("netamount", (Object)newNetAmount);
        finCard.set("monthorigvalchg", (Object)finCard.getBigDecimal("monthorigvalchg").add(inOriginalVal));
        finCard.set("monthdeprechg", (Object)finCard.getBigDecimal("monthdeprechg").add(inDecVal));
        finCard.set("monthaccumdeprechg", (Object)finCard.getBigDecimal("monthaccumdeprechg").add(inAccumDepre));
        finCard.set("isneeddepre", (Object)true);
    }

    private void outFinCardMergeHandle(DynamicObjectCollection outEntryEntity, DynamicObject finCard, long mergePeriodId) {
        long finCardId = finCard.getLong("id");
        for (DynamicObject outEntry : outEntryEntity) {
            long outFinCardId = outEntry.getLong(Fa.id((String)"outfincard"));
            if (finCardId != outFinCardId) continue;
            BigDecimal outOriginalVal = outEntry.getBigDecimal("outoriginalval");
            BigDecimal outAccumDepre = outEntry.getBigDecimal("outaccumdepre");
            BigDecimal outDecVal = outEntry.getBigDecimal("outdecval");
            BigDecimal outPreResidualVal = outEntry.getBigDecimal("outpreresidualval");
            BigDecimal finOriginalVal = finCard.getBigDecimal("originalval");
            BigDecimal newOriginalVal = finOriginalVal.subtract(outOriginalVal);
            finCard.set("originalval", (Object)newOriginalVal);
            long finBizPeriodId = finCard.getLong(Fa.id((String)"bizperiod"));
            BigDecimal finAccumDepre = finCard.getBigDecimal("accumdepre");
            BigDecimal addUpYearDepre = finCard.getBigDecimal("addupyeardepre");
            if (mergePeriodId == finBizPeriodId) {
                BigDecimal finMonthDepre = finCard.getBigDecimal("monthdepre");
                finAccumDepre = finAccumDepre.subtract(finMonthDepre);
                addUpYearDepre = addUpYearDepre.subtract(finMonthDepre);
                finCard.set("addupyeardepre", (Object)addUpYearDepre);
                finCard.set("depredamount", (Object)finCard.getBigDecimal("depredamount").subtract(finCard.getBigDecimal("addidepreamount")));
                finCard.set("addidepreamount", (Object)0);
                finCard.set("monthdeprerate", (Object)0);
            }
            BigDecimal newAccumDepre = finAccumDepre.subtract(outAccumDepre);
            finCard.set("accumdepre", (Object)newAccumDepre);
            BigDecimal newDecVal = finCard.getBigDecimal("decval").subtract(outDecVal);
            finCard.set("decval", (Object)newDecVal);
            finCard.set("preresidualval", (Object)finCard.getBigDecimal("preresidualval").subtract(outPreResidualVal));
            BigDecimal newNetWorth = newOriginalVal.subtract(newAccumDepre);
            finCard.set("networth", (Object)newNetWorth);
            BigDecimal newNetAmount = newNetWorth.subtract(newDecVal);
            finCard.set("netamount", (Object)newNetAmount);
            finCard.set("monthorigvalchg", (Object)finCard.getBigDecimal("monthorigvalchg").subtract(outOriginalVal));
            finCard.set("monthdeprechg", (Object)finCard.getBigDecimal("monthdeprechg").subtract(outDecVal));
            finCard.set("monthaccumdeprechg", (Object)finCard.getBigDecimal("monthaccumdeprechg").subtract(outAccumDepre));
            finCard.set("monthdepre", (Object)BigDecimal.ZERO);
            finCard.set("isneeddepre", (Object)false);
        }
    }

    public void generateClearBillByMerge(Object billPk) {
        MergeBill2ClearBillConvertor convertor = new MergeBill2ClearBillConvertor();
        ClearBillHDGenerator generator = new ClearBillHDGenerator((IClearBillConvertor)convertor);
        generator.generate(billPk, "fa_mergebill");
    }
}

