/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;

public class FaMergeBillChangeValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObject mergePeriod = mergeBill.getDynamicObject("mergeperiod");
            if (mergePeriod == null) {
                DynamicObject org = mergeBill.getDynamicObject("org");
                DynamicObject mainBookByOrg = FaUtils.getMainBookDyByOrg((Long)org.getLong("id"));
                mergePeriod = mainBookByOrg.getDynamicObject("curperiod");
            }
            DynamicObject realCard = mergeBill.getDynamicObject("realcard");
            Set<Long> ids = FaMergeBillUtils.getMergeBillRealCardIds(mergeBill);
            if (realCard != null) {
                boolean exists = QueryServiceHelper.exists((String)"fa_change_dept", (QFilter[])new QFilter[]{new QFilter("fieldentry.realcard1", "=", realCard.getPkValue()), new QFilter("fieldentry.isadjustdepre1", "=", (Object)true), new QFilter("fieldentry.bizdate1", ">", (Object)mergePeriod.getDate("enddate"))});
                if (exists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5b58\u5728\u5f71\u54cd\u4e0b\u671f\u6298\u65e7\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillChangeValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCard.getString("number")));
                }
                ids.remove(realCard.getPkValue());
            }
            Set depreChangeItemIds = FaUtils.getDepreChangeItem();
            DynamicObjectCollection changeBills = QueryServiceHelper.query((String)"fa_change_dept", (String)"fieldentry.realcard1.number", (QFilter[])new QFilter[]{new QFilter("changedate", ">=", (Object)mergePeriod.getDate("begindate")), new QFilter("changedate", "<=", (Object)mergePeriod.getDate("enddate")), new QFilter("fieldentry.realcard1", "in", ids).and(new QFilter("fieldentry.isadjustdepre1", "=", (Object)true).and(new QFilter("fieldentry.bizdate1", ">", (Object)mergePeriod.getDate("enddate")).or(new QFilter("fieldentry.bizdate1", "<", (Object)mergePeriod.getDate("begindate")))).or(new QFilter("fieldentry.isadjustdepre1", "=", (Object)false).and(new QFilter("changeitem.fbasedataid.id", "in", (Object)depreChangeItemIds))))});
            Set numbers = changeBills.stream().map(v -> v.getString("fieldentry.realcard1.number")).collect(Collectors.toSet());
            if (numbers.isEmpty()) continue;
            String numbersStr = String.join((CharSequence)"\u3001", numbers);
            if (numbers.size() > 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247\u7f16\u7801\uff1a%s \u5f53\u671f\u5b58\u5728\u8ffd\u6eaf\u8c03\u6574\u6216\u672a\u6765\u9002\u7528\u7684\u4e1a\u52a1\u65e5\u671f\u4e0d\u5728\u5f53\u671f\u7684\u53d8\u66f4\u4e1a\u52a1\u5355\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillChangeValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5f53\u671f\u5b58\u5728\u8ffd\u6eaf\u8c03\u6574\u6216\u672a\u6765\u9002\u7528\u7684\u4e1a\u52a1\u65e5\u671f\u4e0d\u5728\u5f53\u671f\u7684\u53d8\u66f4\u4e1a\u52a1\u5355\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillChangeValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
        }
    }
}

