/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;

public class FaMergeBillDepreAdjustValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObject mergePeriod = mergeBill.getDynamicObject("mergeperiod");
            if (mergePeriod == null) {
                mergePeriod = mergeBill.getDynamicObject("org").getDynamicObject("curperiod");
            }
            Set<Long> ids = FaMergeBillUtils.getMergeBillRealCardIds(mergeBill);
            DynamicObjectCollection depreAdjustBills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)"entryentity.realcard.number", (QFilter[])new QFilter[]{new QFilter("period", "=", mergePeriod.getPkValue()), new QFilter("entryentity.realcard.id", "in", ids)});
            Set numbers = depreAdjustBills.stream().map(v -> v.getString("entryentity.realcard.number")).collect(Collectors.toSet());
            if (depreAdjustBills.isEmpty()) continue;
            String numbersStr = String.join((CharSequence)"\u3001", numbers);
            if (numbers.size() > 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247\u7f16\u7801\uff1a%s \u5f53\u671f\u5b58\u5728\u6298\u65e7\u8c03\u6574\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillDepreAdjustValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5f53\u671f\u5b58\u5728\u6298\u65e7\u8c03\u6574\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillDepreAdjustValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
        }
    }
}

