/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;

public class FaMergeBillDevalueValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObject nextPeriod = FaMergeBillUtils.getMergeBillNextPeriod(mergeBill);
            if (nextPeriod == null) continue;
            Set<Long> ids = FaMergeBillUtils.getMergeBillRealCardIds(mergeBill);
            DynamicObjectCollection assetDevalues = QueryServiceHelper.query((String)"fa_asset_devalue", (String)"changebillentry.realcard.number", (QFilter[])new QFilter[]{new QFilter("changebillentry.realcard.id", "in", ids), new QFilter("changebillentry.bizdate", ">=", (Object)nextPeriod.getDate("begindate")), new QFilter("changebillentry.bizdate", "<=", (Object)nextPeriod.getDate("begindate"))});
            Set numbers = assetDevalues.stream().map(v -> v.getString("changebillentry.realcard.number")).collect(Collectors.toSet());
            if (numbers.isEmpty()) continue;
            String numbersStr = String.join((CharSequence)"\u3001", numbers);
            if (numbers.size() > 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247\u7f16\u7801\uff1a%s \u5b58\u5728\u5f71\u54cd\u4e0b\u671f\u7684\u51cf\u503c\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillDevalueValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5b58\u5728\u5f71\u54cd\u4e0b\u671f\u7684\u51cf\u503c\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillDevalueValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
        }
    }
}

