/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.model.CompFieldsValuesPo;
import kd.fi.fa.business.utils.CompFieldsValuesUtils;

public class FaMergeBillUnAuditCompFieldValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (this.validateContext.getValidateResults().getErrorDataIndexs().contains(dataEntity.getDataEntityIndex())) continue;
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObjectCollection inEntryEntry = mergeBill.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inEntry : inEntryEntry) {
                this.checkCompFieldsV4In(dataEntity, inEntry);
                DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
                for (DynamicObject outEntry : outEntryEntity) {
                    this.checkCompFieldsV4Out(dataEntity, outEntry);
                }
            }
        }
    }

    private void checkCompFieldsV4Out(ExtendedDataEntity dataEntity, DynamicObject outEntry) {
        String outCompFieldsV = outEntry.getString("outcompfieldsv");
        CompFieldsValuesPo outCompFieldsValuesPo = CompFieldsValuesUtils.convert((String)outCompFieldsV);
        if (outCompFieldsValuesPo == null) {
            return;
        }
        DynamicObject outFinCard = outEntry.getDynamicObject("outfincard");
        if (outFinCard != null && outCompFieldsValuesPo.getStyle().equals("S1")) {
            BigDecimal originalVal = outCompFieldsValuesPo.getOriginalval().subtract(outEntry.getBigDecimal("outoriginalval"));
            BigDecimal decVal = outCompFieldsValuesPo.getDecval().subtract(outEntry.getBigDecimal("outdecval"));
            BigDecimal preResidualVal = outCompFieldsValuesPo.getPreresidualval().subtract(outEntry.getBigDecimal("outpreresidualval"));
            BigDecimal originalValDb = outFinCard.getBigDecimal("originalval");
            BigDecimal decValDb = outFinCard.getBigDecimal("decval");
            BigDecimal preResidualValDb = outFinCard.getBigDecimal("preresidualval");
            String number = outFinCard.getString("number");
            if (originalVal.compareTo(originalValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f6c\u51fa\u5361\u7247[%1$s]\u5408\u5e76\u540e\u539f\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillUnAuditCompFieldValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, originalVal, originalValDb));
            }
            if (preResidualVal.compareTo(preResidualValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f6c\u51fa\u5361\u7247[%1$s]\u5408\u5e76\u540e\u6b8b\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillUnAuditCompFieldValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, preResidualVal, preResidualValDb));
            }
            if (decVal.compareTo(decValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f6c\u51fa\u5361\u7247[%1$s]\u5408\u5e76\u540e\u51cf\u503c\u51c6\u5907[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillUnAuditCompFieldValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, decVal, decValDb));
            }
        }
    }

    private void checkCompFieldsV4In(ExtendedDataEntity dataEntity, DynamicObject inEntry) {
        String inCompFieldsV = inEntry.getString("incompfieldsv");
        CompFieldsValuesPo inCompFieldsValuesPo = CompFieldsValuesUtils.convert((String)inCompFieldsV);
        if (inCompFieldsValuesPo == null) {
            return;
        }
        DynamicObject inFinCard = inEntry.getDynamicObject("infincard");
        if (inFinCard != null && inCompFieldsValuesPo.getStyle().equals("S1")) {
            BigDecimal originalVal = inCompFieldsValuesPo.getOriginalval().add(inEntry.getBigDecimal("inoriginalval"));
            BigDecimal decVal = inCompFieldsValuesPo.getDecval().add(inEntry.getBigDecimal("indecval"));
            BigDecimal preResidualVal = inCompFieldsValuesPo.getPreresidualval().add(inEntry.getBigDecimal("inpreresidualval"));
            BigDecimal originalValDb = inFinCard.getBigDecimal("originalval");
            BigDecimal decValDb = inFinCard.getBigDecimal("decval");
            BigDecimal preResidualValDb = inFinCard.getBigDecimal("preresidualval");
            String number = inFinCard.getString("number");
            if (originalVal.compareTo(originalValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f6c\u5165\u5361\u7247[%1$s]\u5408\u5e76\u540e\u539f\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillUnAuditCompFieldValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, originalVal, originalValDb));
            }
            if (preResidualVal.compareTo(preResidualValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f6c\u5165\u5361\u7247[%1$s]\u5408\u5e76\u540e\u6b8b\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillUnAuditCompFieldValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, preResidualVal, preResidualValDb));
            }
            if (decVal.compareTo(decValDb) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f6c\u5165\u5361\u7247[%1$s]\u5408\u5e76\u540e\u51cf\u503c\u51c6\u5907[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaMergeBillUnAuditCompFieldValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, decVal, decValDb));
            }
        }
    }
}

