/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillDepreSumValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillUnAuditCompFieldValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillUnAuditValidator;

public class FaMergeBillUnAuditOp
extends AbstractBizCtrOperationServicePlugIn
implements IFaOpHandler {
    private static final String BEGIN_ARGS = "beginArgs";
    private static final String[] SELECTOR = new String[]{"originalval", "monthorigvalchg", "yearorigvalchg"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("mergedate");
        fieldKeys.add("mergeperiod");
        fieldKeys.add("type");
        fieldKeys.add("realcard");
        fieldKeys.add("voucherflag");
        fieldKeys.add("inentryentity");
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "infincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "indepreuse"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inoriginalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inaccumdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "indecval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inpreresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "beforeinfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "afterinfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "incompfieldsv"}));
        fieldKeys.add("outentryentity");
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outfincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "OUTREALCARDMASTERID"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outoriginalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outaccumdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outdecval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outpreresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "afteroutfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "beforeoutfin"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outcompfieldsv"}));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaMergeBillUnAuditValidator());
        e.addValidator((AbstractValidator)new FaMergeBillDepreSumValidator());
        e.addValidator((AbstractValidator)new FaMergeBillUnAuditCompFieldValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        HashMap<String, BeginOperationTransactionArgs> otherParams = new HashMap<String, BeginOperationTransactionArgs>(1, 1.0f);
        otherParams.put(BEGIN_ARGS, e);
        FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operationKey, (String)"fa_mergebill", (DynamicObject[])e.getDataEntities(), otherParams, (IFaOpHandler)this);
        super.beginOperationTransaction(e);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        if (dataEntities.length == 0) {
            return;
        }
        BeginOperationTransactionArgs e = (BeginOperationTransactionArgs)otherParams.get(BEGIN_ARGS);
        IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
        for (DynamicObject dataEntity : dataEntities) {
            String type = dataEntity.getString("type");
            if ("1".equals(type)) {
                this.deleteClearBill(dataEntity);
                this.deleteFinSnapshot(dataEntity);
                DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)"fa_mergebill"), new QFilter("changebillid", "=", dataEntity.getPkValue())});
                long periodId = dataEntity.getLong(Fa.id((String)"mergeperiod"));
                DynamicObjectCollection inEntryEntity = dataEntity.getDynamicObjectCollection("inentryentity");
                for (DynamicObject inEntry : inEntryEntity) {
                    long inRealCardId = inEntry.getLong("inrealcardmasterid");
                    long depreUseId = inEntry.getLong(Fa.id((String)"indepreuse"));
                    fCardDao.restoreCard(periodId, depreUseId, new Object[]{inRealCardId}, v -> this.inFinCardMergeHandle(inEntry, v), SELECTOR);
                    DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
                    Object[] outRealCardIds = outEntryEntity.stream().map(v -> v.getLong("OUTREALCARDMASTERID")).collect(Collectors.toSet()).toArray();
                    fCardDao.restoreCard(periodId, depreUseId, outRealCardIds, v -> this.outFinCardMergeHandle(outEntryEntity, v, periodId), SELECTOR);
                }
            } else {
                e.setCancelOperation(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u7c7b\u578b\u7684\u5408\u5e76\u64cd\u4f5c", (String)"FaMergeBillUnAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            FaModiRealStatsUtils.updateMergeBillCardBizStatus((DynamicObject)dataEntity, (BizStatusEnum)BizStatusEnum.MERGING, (BizStatusEnum)BizStatusEnum.READY);
            dataEntity.set("voucherflag", (Object)"B");
        }
    }

    private void deleteFinSnapshot(DynamicObject dataEntity) {
        ArrayList<Long> changeBackCards = new ArrayList<Long>(8);
        DynamicObjectCollection inEntryEntity = dataEntity.getDynamicObjectCollection("inentryentity");
        for (DynamicObject inEntry : inEntryEntity) {
            changeBackCards.add(inEntry.getLong(Fa.id((String)"beforeinfin")));
            changeBackCards.add(inEntry.getLong(Fa.id((String)"afterinfin")));
            inEntry.set("beforeinfin", null);
            inEntry.set("afterinfin", null);
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryEntity) {
                changeBackCards.add(outEntry.getLong(Fa.id((String)"afteroutfin")));
                changeBackCards.add(outEntry.getLong(Fa.id((String)"beforeoutfin")));
                outEntry.set("afteroutfin", null);
                outEntry.set("beforeoutfin", null);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin"), (Object[])changeBackCards.toArray());
    }

    private void deleteClearBill(DynamicObject dataEntity) {
        Long billId = dataEntity.getLong("id");
        HashSet<Long> clearBillIds = new HashSet<Long>(2);
        DynamicObject clearBill = QueryServiceHelper.queryOne((String)"fa_clearbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("srcbill", "=", (Object)billId), new QFilter("clearsource", "=", (Object)FaClearSourceEnum.MERGE.name())});
        if (clearBill == null) {
            return;
        }
        clearBillIds.add(clearBill.getLong("id"));
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("unAuditFromMerge", "true");
        operate.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"fa_clearbill", (Object[])clearBillIds.toArray(new Long[0]), (OperateOption)operate);
        FaCommonUtils.handleOperationResult((OperationResult)result);
        operate = OperateOption.create();
        operate.setVariableValue("deleteClearBillByUnAudit", "true");
        operate.setVariableValue("ishasright", String.valueOf(true));
        result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_clearbill", (Object[])clearBillIds.toArray(new Long[0]), (OperateOption)operate);
        FaCommonUtils.handleOperationResult((OperationResult)result);
    }

    private void inFinCardMergeHandle(DynamicObject inEntry, DynamicObject finCard) {
        BigDecimal inOriginalVal = inEntry.getBigDecimal("inoriginalval");
        BigDecimal inAccumDepre = inEntry.getBigDecimal("inaccumdepre");
        BigDecimal inDecVal = inEntry.getBigDecimal("indecval");
        BigDecimal inPreResidualVal = inEntry.getBigDecimal("inpreresidualval");
        BigDecimal newOriginalVal = finCard.getBigDecimal("originalval").subtract(inOriginalVal);
        finCard.set("originalval", (Object)newOriginalVal);
        BigDecimal finAccumDepre = finCard.getBigDecimal("accumdepre");
        BigDecimal newAccumDepre = finAccumDepre.subtract(inAccumDepre);
        finCard.set("accumdepre", (Object)newAccumDepre);
        BigDecimal newDecVal = finCard.getBigDecimal("decval").subtract(inDecVal);
        finCard.set("decval", (Object)newDecVal);
        finCard.set("preresidualval", (Object)finCard.getBigDecimal("preresidualval").subtract(inPreResidualVal));
        BigDecimal newNetWorth = newOriginalVal.subtract(newAccumDepre);
        finCard.set("networth", (Object)newNetWorth);
        BigDecimal newNetAmount = newNetWorth.subtract(newDecVal);
        finCard.set("netamount", (Object)newNetAmount);
        finCard.set("monthorigvalchg", (Object)finCard.getBigDecimal("monthorigvalchg").subtract(inOriginalVal));
        finCard.set("monthdeprechg", (Object)finCard.getBigDecimal("monthdeprechg").subtract(inDecVal));
        finCard.set("monthaccumdeprechg", (Object)finCard.getBigDecimal("monthaccumdeprechg").subtract(inAccumDepre));
        finCard.set("isneeddepre", (Object)true);
    }

    private void outFinCardMergeHandle(DynamicObjectCollection outEntryEntity, DynamicObject finCard, long mergePeriodId) {
        long finCardId = finCard.getLong("id");
        for (DynamicObject outEntry : outEntryEntity) {
            long outFinCardId = outEntry.getLong(Fa.id((String)"outfincard"));
            if (finCardId != outFinCardId) continue;
            BigDecimal outOriginalVal = outEntry.getBigDecimal("outoriginalval");
            BigDecimal outAccumDepre = outEntry.getBigDecimal("outaccumdepre");
            BigDecimal outDecVal = outEntry.getBigDecimal("outdecval");
            BigDecimal outPreResidualVal = outEntry.getBigDecimal("outpreresidualval");
            BigDecimal finOriginalVal = finCard.getBigDecimal("originalval");
            BigDecimal newOriginalVal = finOriginalVal.add(outOriginalVal);
            finCard.set("originalval", (Object)newOriginalVal);
            long finBizPeriodId = finCard.getLong(Fa.id((String)"bizperiod"));
            BigDecimal finAccumDepre = finCard.getBigDecimal("accumdepre");
            if (mergePeriodId == finBizPeriodId) {
                BigDecimal finMonthDepre = finCard.getBigDecimal("monthdepre");
                finAccumDepre = finAccumDepre.subtract(finMonthDepre);
            }
            BigDecimal newAccumDepre = finAccumDepre.add(outAccumDepre);
            finCard.set("accumdepre", (Object)newAccumDepre);
            BigDecimal newDecVal = finCard.getBigDecimal("decval").add(outDecVal);
            finCard.set("decval", (Object)newDecVal);
            finCard.set("preresidualval", (Object)finCard.getBigDecimal("preresidualval").add(outPreResidualVal));
            BigDecimal newNetWorth = newOriginalVal.subtract(newAccumDepre);
            finCard.set("networth", (Object)newNetWorth);
            BigDecimal newNetAmount = newNetWorth.subtract(newDecVal);
            finCard.set("netamount", (Object)newNetAmount);
            finCard.set("monthorigvalchg", (Object)finCard.getBigDecimal("monthorigvalchg").add(outOriginalVal));
            finCard.set("monthdeprechg", (Object)finCard.getBigDecimal("monthdeprechg").add(outDecVal));
            finCard.set("monthaccumdeprechg", (Object)finCard.getBigDecimal("monthaccumdeprechg").add(outAccumDepre));
            finCard.set("monthdepre", (Object)BigDecimal.ZERO);
            finCard.set("isneeddepre", (Object)true);
        }
    }
}

