/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.myasset;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.utils.FaAssertOrgUtil;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.validator.SourceFlagDataAssetValidator;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;

public class FaAssetDrawbackSubmitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                    DynamicObject assetOrg = dynamicObject.getDynamicObject("assetorg");
                    Long assetOrgId = (Long)assetOrg.getPkValue();
                    DynamicObject assertStoreKeeper = FaAssertOrgUtil.getStoreKeeper((Long)assetOrgId);
                    if (assertStoreKeeper != null) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5e93\u7ba1\u5458\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"FaAssetDrawbackSubmitOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
        e.addValidator((AbstractValidator)new SourceFlagDataAssetValidator("assetdrawbackentry", null, "realcard"));
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(dataEntity -> {
            dataEntity.set("bizstatus", (Object)FaAssetDrawback.BizStatusEnum.SUBMITTED.getValue());
            DynamicObjectCollection entryEntityList = dataEntity.getDynamicObjectCollection("assetdrawbackentry");
            for (DynamicObject entryEntity : entryEntityList) {
                DynamicObject store_place = entryEntity.getDynamicObject("store_place");
                if (store_place != null) continue;
                DynamicObject realCard = entryEntity.getDynamicObject("realcard");
                entryEntity.set("store_place", realCard.getDynamicObject("storeplace").getPkValue());
            }
        });
        FaModiRealStatsUtils.saveUpdate_allBill_bizStatus((BeginOperationTransactionArgs)e, (String)"assetdrawbackentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.DRAWBACKING, (BizStatusEnum)BizStatusEnum.READY);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("bizstatus");
        keys.add("assetdrawbackentry");
        keys.add("assetdrawbackentry.realcard");
        keys.add("assetdrawbackentry.store_place");
        keys.add("assetdrawbackentry.realcard.masterid");
        keys.add("assetdrawbackentry.realcard.storeplace");
    }
}

