/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.myasset;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.business.dao.factory.FaChangeBillDaoFactory;
import kd.fi.fa.business.service.api.AssetChangeBillGenService;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.opplugin.changebill.AssetChangeDTO;
import kd.fi.fa.opplugin.myasset.FaAssetGenChangeBill;
import kd.fi.fa.opplugin.myasset.FaAssetTransferSignValidator;

public class FaAssetTransferSignOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("assetorg");
        e.getFieldKeys().add("assettransferentry");
        e.getFieldKeys().add("applydate");
        e.getFieldKeys().add("assettransferentry.realcard");
        e.getFieldKeys().add("assettransferentry.realcard.masterid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaAssetTransferSignValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        DynamicObject[] transferBills = beginOperationTransactionArgs.getDataEntities();
        AssetChangeBillGenService service = FaChangeBillDaoFactory.getGenerateService();
        for (DynamicObject transferBill : transferBills) {
            transferBill = this.doAuditTransferOp(transferBill);
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)transferBill, (String)"assettransferentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.TRANSFERING);
            FaAssetGenChangeBill.genChangeBill("fa_asset_transfer", transferBill, service, this::assetTransferToChangeBill);
        }
    }

    private DynamicObject doAuditTransferOp(DynamicObject transferBill) {
        transferBill = BusinessDataServiceHelper.loadSingle((Object)transferBill.getPkValue(), (String)"fa_asset_transfer");
        transferBill.set("applydate", (Object)new Date());
        transferBill.set("bizstatus", (Object)FaAssetTranfer.BizStatusEnum.SIGNED.getValue());
        transferBill.set("billstatus", (Object)BillStatus.C.name());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transferBill});
        return transferBill;
    }

    private DynamicObject assetTransferToChangeBill(DynamicObject assetTransfer) {
        AssetChangeDTO changeInfo = this.toChangeInfoDTO(assetTransfer);
        return changeInfo.toChangeBill(new Date());
    }

    private AssetChangeDTO toChangeInfoDTO(DynamicObject assetTransfer) {
        assetTransfer = BusinessDataServiceHelper.loadSingle((Object)assetTransfer.getPkValue(), (String)"fa_asset_transfer");
        AssetChangeDTO changeInfo = new AssetChangeDTO();
        changeInfo.setSrcNumber(assetTransfer.getString("billno"));
        changeInfo.setAlias(ResManager.loadKDString((String)"\u8d44\u4ea7\u79fb\u4ea4\u5355", (String)"FaAssetTransferSignOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        changeInfo.setRemark(null);
        changeInfo.setReason(assetTransfer.getString("reason"));
        DynamicObject assetOrg = assetTransfer.getDynamicObject("assetorg");
        long assetOrgId = assetOrg.getLong("id");
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType("09");
        param.setFromViewType("10");
        param.setOrgId(assetOrgId);
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(true);
        List fromOrgList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache(fromOrgList.get(0), (String)"bos_org");
        changeInfo.setOrg(org);
        changeInfo.setReceiver(assetTransfer.getDynamicObject("receiver"));
        changeInfo.setDept(assetTransfer.getDynamicObject("receiver_dpt"));
        changeInfo.setSourceId(assetTransfer.getLong("id"));
        changeInfo.setCreator(assetTransfer.getDynamicObject("sender"));
        changeInfo.setAuditor(assetTransfer.getDynamicObject("sender"));
        changeInfo.setFromsource("fa_asset_transfer");
        changeInfo.setSourcetype(assetTransfer.getString("sourcetype"));
        DynamicObject storeplace = assetTransfer.getDynamicObject("storeplace");
        DynamicObjectCollection transferEntries = assetTransfer.getDynamicObjectCollection("assettransferentry");
        LinkedList realCardIds = new LinkedList();
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(transferEntries.size());
        transferEntries.stream().forEach(transferEntry -> {
            DynamicObject realCard = transferEntry.getDynamicObject("realcard");
            realCard = BusinessDataServiceHelper.loadSingle((Object)realCard.getPkValue(), (String)"fa_card_real_base");
            Long pkValue = (Long)realCard.getPkValue();
            realCardIds.add(pkValue);
            changeInfo.addRealEntry(realCard);
            map.put(pkValue, storeplace);
        });
        changeInfo.setStoreplaceMap(map);
        Map finCardMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", realCardIds)});
        Collection<Object> finCards = Collections.EMPTY_LIST;
        if (finCardMap != null && !finCardMap.isEmpty()) {
            finCards = finCardMap.values();
        }
        for (DynamicObject finCard : finCards) {
            DynamicObject realCard = finCard.getDynamicObject("realcard");
            changeInfo.addFinEntry(realCard, finCard);
            if (!finCard.getDynamicObject("assetbook").getBoolean("ismainbook") || finCard.getLong("endperiod_id") != 99999999999L) continue;
            changeInfo.addEntry(realCard, finCard);
        }
        if (realCardIds.size() != changeInfo.getEntries().size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u505a\u4e86\u672a\u6765\u4e1a\u52a1\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaAssetTransferSignOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        return changeInfo;
    }
}

