/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.myasset;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaUserUtils;
import kd.fi.fa.business.validator.SourceFlagDataAssetValidator;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;
import org.apache.log4j.Logger;

public class FaAssetTransferSubmitOp
extends AbstractOperationServicePlugIn {
    private static Logger log = Logger.getLogger(FaAssetTransferSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("receiver_dpt");
        fieldKeys.add("bizstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    List resultList;
                    boolean departSharing;
                    DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                    if (dynamicObject.getDynamicObject("receiver") == null) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63a5\u6536\u4eba\u3002", (String)"FaAssetTransferSubmitOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject receiver = dynamicObject.getDynamicObject("receiver");
                    DynamicObject assetOrg = dynamicObject.getDynamicObject("assetorg");
                    DynamicObject receiverDept = dynamicObject.getDynamicObject("receiver_dpt");
                    Long receiverDeptId = 0L;
                    if (null != receiverDept) {
                        receiverDeptId = (Long)receiverDept.getPkValue();
                    }
                    Long assetOrgId = (Long)assetOrg.getPkValue();
                    Long receiverId = (Long)receiver.getPkValue();
                    Long receiverAssetOrgId = FaAssetTransferSubmitOp.this.getAssetOrg(receiver, assetOrgId);
                    if (receiverAssetOrgId == null) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u4e0d\u5b58\u5728\u975e\u517c\u804c\u90e8\u95e8\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u4fe1\u606f", (String)"FaAssetTransferSubmitOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    log.info((Object)("\u63a5\u6536\u4eba\u8d44\u4ea7\u7ec4\u7ec7\uff1a" + receiverAssetOrgId + "\u79fb\u4ea4\u4eba\u8d44\u4ea7\u7ec4\u7ec7\uff1a" + assetOrgId));
                    DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("assettransferentry");
                    Long org = assetOrgId;
                    if (entry.size() > 0) {
                        DynamicObject realCard = ((DynamicObject)entry.get(0)).getDynamicObject("realcard");
                        if (null == realCard) continue;
                        org = realCard.getLong("org.id");
                    }
                    if ((departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharingByOrgId((long)org)) || assetOrgId == null || (resultList = FaAssetUnitAndUseDeptUnits.queryEnableDeptByOrg((Long)assetOrgId)).contains(receiverDeptId)) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u6240\u5728\u90e8\u95e8\u4e0d\u5728\u79fb\u4ea4\u5361\u7247\u7684\u6838\u7b97\u7ec4\u7ec7\u5185\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9700\u8981\u5f00\u542f\u90e8\u95e8\u5171\u4eab", (String)"FaAssetTransferSubmitOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
        e.addValidator((AbstractValidator)new SourceFlagDataAssetValidator("assettransferentry", null, "realcard"));
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            dataEntity.set("bizstatus", (Object)FaAssetTranfer.BizStatusEnum.SUBMITTED.getValue());
        }
        FaModiRealStatsUtils.saveUpdate_allBill_bizStatus((BeginOperationTransactionArgs)e, (String)"assettransferentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.TRANSFERING, (BizStatusEnum)BizStatusEnum.READY);
    }

    private Long getAssetOrg(DynamicObject user, Long assetOrgId2) {
        DynamicObject dep = FaUserUtils.getAdminOrgByUser((DynamicObject)user);
        if (dep == null) {
            return null;
        }
        LinkedList<Long> Orgs = new LinkedList<Long>();
        Orgs.add(dep.getLong("id"));
        log.info((Object)("\u83b7\u53d6\u5230\u7684\u90e8\u95e8\uff1a" + dep.getLong("id")));
        List allOrgs = OrgUnitServiceHelper.getAdminOrgRelation(Orgs, (boolean)false);
        if (allOrgs != null && allOrgs.size() > 0) {
            log.info((Object)("\u59d4\u6258\u7684\u7b2c\u4e00\u4e2a\u7ec4\u7ec7\uff1a" + allOrgs.get(0)));
            log.info((Object)("\u59d4\u6258\u7684\u7ec4\u7ec7\uff1a" + allOrgs.toString()));
        }
        List assetOrgs = OrgUnitServiceHelper.filterOrgDuty((List)allOrgs, (String)"09");
        Long assetOrgId = 0L;
        if (assetOrgs.size() > 0) {
            if (assetOrgs.contains(assetOrgId2)) {
                log.info((Object)("\u59d4\u6258\u7684\u7ec4\u7ec7\u4e2d\u5305\u62ec:" + assetOrgId2));
                assetOrgId = assetOrgId2;
            } else {
                log.info((Object)("\u59d4\u6258\u7684\u7ec4\u7ec7\u4e2d\u4e0d\u5305\u62ec:" + assetOrgId2 + "\u6240\u4ee5\u968f\u4fbf\u9009\u4e00\u4e2a\u59d4\u6258\u7ec4\u7ec7"));
                assetOrgId = (Long)assetOrgs.get(0);
                log.info((Object)(assetOrgId + "\u6709\u8d44\u4ea7\u7ec4\u7ec7\u804c\u80fd"));
            }
        } else {
            log.info((Object)"\u6ca1\u6709\u59d4\u6258\u4e1a\u52a1\u5355\u5143");
            assetOrgs = OrgUnitServiceHelper.filterOrgDuty(Orgs, (String)"09");
            if (assetOrgs.size() > 0) {
                assetOrgId = (Long)assetOrgs.get(0);
                log.info((Object)("\u5f53\u524d\u90e8\u95e8" + assetOrgId + "\u6709\u8d44\u4ea7\u804c\u80fd"));
            } else {
                log.info((Object)"\u5f53\u524d\u90e8\u95e8\u6ca1\u6709\u8d44\u4ea7\u804c\u80fd");
                dep = FaUserUtils.getAssetOrgByUser((DynamicObject)user);
                if (dep != null) {
                    assetOrgId = (Long)dep.getPkValue();
                    log.info((Object)("\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\uff1a" + assetOrgId));
                }
            }
        }
        return assetOrgId;
    }
}

