/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.pclock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.pclock.EntityName2PcLockConfig;
import kd.fi.fa.business.pclock.PCLockBillUtils;
import kd.fi.fa.business.pclock.PcLockConfigUtils;
import kd.fi.fa.business.pclock.PcLockUtils;
import kd.fi.fa.business.pclock.inter.PcChildLock;
import kd.fi.fa.business.pclock.po.PcChildLockParameter;
import kd.fi.fa.business.pclock.po.PcLockConfigParameter;
import kd.fi.fa.business.utils.FaCommonUtils;

public class PcChildLockOperationServiceHelper {
    private static final Log logger = LogFactory.getLog(PcChildLockOperationServiceHelper.class);

    public static void executeOperate(DynamicObject[] billList, String operationKey, String entityNumber) {
        block8: {
            List<PcChildLock> lockList = PcChildLockOperationServiceHelper.getPcLockTryLock(billList);
            ArrayList<Long> ids = new ArrayList<Long>(billList.length);
            for (DynamicObject bill : billList) {
                Long d = bill.getLong("id");
                ids.add(d);
            }
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                FaCommonUtils.handleOperationResult((OperationResult)result);
                if (lockList == null || lockList.size() == 0) break block8;
            }
            catch (Exception e1) {
                try {
                    logger.error("PcLockOperationServiceHelper", (Throwable)e1);
                    throw e1;
                }
                catch (Throwable throwable) {
                    if (lockList != null && lockList.size() != 0) {
                        for (PcChildLock lock : lockList) {
                            lock.unlock();
                        }
                    }
                    throw throwable;
                }
            }
            for (PcChildLock lock : lockList) {
                lock.unlock();
            }
        }
    }

    public static OperationResult executeOperateAndReturnResult(DynamicObject[] billList, String operationKey, String entityNumber) {
        List<PcChildLock> lockList = PcChildLockOperationServiceHelper.getPcLockTryLock(billList);
        ArrayList<Long> ids = new ArrayList<Long>(billList.length);
        for (DynamicObject bill : billList) {
            Long d = bill.getLong("id");
            ids.add(d);
        }
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids.toArray(), (OperateOption)option);
            return operationResult;
        }
        catch (Exception e1) {
            logger.error("PcLockOperationServiceHelper", (Throwable)e1);
            throw e1;
        }
        finally {
            if (lockList != null && lockList.size() != 0) {
                for (PcChildLock lock : lockList) {
                    lock.unlock();
                }
            }
        }
    }

    @Deprecated
    protected static List<PcChildLock> getPcLockTryLock(DynamicObject[] billList) {
        return PcChildLockOperationServiceHelper.getPcChildLockTryLock(billList);
    }

    protected static List<PcChildLock> getPcChildLockTryLock(DynamicObject[] billList) {
        if (billList == null || billList.length == 0) {
            return new ArrayList<PcChildLock>(0);
        }
        String entityName = billList[0].getDataEntityType().getName();
        String pcLockConfig = (String)EntityName2PcLockConfig.entityName2Config.get(entityName);
        if (StringUtils.isEmpty((CharSequence)pcLockConfig)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u914d\u7f6e[%s]\u4e0d\u5b58\u5728", (String)"PcChildLockOperationServiceHelper_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), pcLockConfig));
        }
        PcLockConfigParameter configPara = PcLockConfigUtils.handleConfigBaseData((String)entityName, (String)"", (String)pcLockConfig);
        if (configPara == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u603b\u5206\u9501\u914d\u7f6e[%s]\u4e0d\u5b58\u5728", (String)"PcChildLockOperationServiceHelper_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), pcLockConfig));
        }
        ArrayList<Long> ids = new ArrayList<Long>(billList.length);
        for (DynamicObject plan : billList) {
            Long d = plan.getLong("id");
            ids.add(d);
        }
        DynamicObject[] billListDb = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashMap pcChildLockParameterMap = new HashMap(billListDb.length, 1.0f);
        for (DynamicObject bill : billListDb) {
            PCLockBillUtils.setPcChildLockParameterMap((DynamicObject)bill, (PcLockConfigParameter)configPara, pcChildLockParameterMap);
        }
        ArrayList<PcChildLock> lockList = new ArrayList<PcChildLock>(pcChildLockParameterMap.size());
        for (PcChildLockParameter parameter : pcChildLockParameterMap.values()) {
            PcChildLock lock = PcLockUtils.createChildLock((PcChildLockParameter)parameter);
            lock.lock();
            lockList.add(lock);
        }
        return lockList;
    }
}

