/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.pclock;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.opplugin.pclock.PcChildLockOperationServiceHelper;

public class PcLockForLeasePayPlan
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("rent");
        e.getFieldKeys().add("pushedamount");
        e.getFieldKeys().add("planpaydate");
        e.getFieldKeys().add("lease");
        e.getFieldKeys().add("curlease.bizstatus");
        e.getFieldKeys().add("curlease.leaseterminationdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (this.dataEntities == null || this.dataEntities.length == 0) {
                    return;
                }
                PcLockForLeasePayPlan.this.validateCurUser();
                for (ExtendedDataEntity bill : this.dataEntities) {
                    try {
                        PcLockForLeasePayPlan.this.validatePayPlan4Push(bill.getDataEntity());
                    }
                    catch (Exception e) {
                        this.addErrorMessage(bill, e.getMessage());
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] planList = e.getDataEntities();
        if (planList == null || planList.length == 0) {
            return;
        }
        String operationKey = e.getOperationKey();
        if (operationKey.equals("donothing_pushandsave")) {
            operationKey = "pushandsave";
        } else if (operationKey.startsWith("donothing_")) {
            operationKey = operationKey.replaceFirst("donothing_", "");
        } else if (operationKey.startsWith("do_")) {
            operationKey = operationKey.replaceFirst("do_", "");
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c", (String)"PcLockForLeasePayPlan_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        PcChildLockOperationServiceHelper.executeOperate(planList, operationKey, "fa_lease_pay_plan");
    }

    private void validateCurUser() {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)currUserId, (String)"bos_user");
        DynamicObjectCollection collection = (DynamicObjectCollection)user.get("entryentity");
        List mainJob = collection.stream().filter(dyn -> !dyn.getBoolean("ispartjob")).collect(Collectors.toList());
        if (mainJob.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u4e3b\u90e8\u95e8", (String)"PcLockForLeasePayPlan_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    private void validatePayPlan4Push(DynamicObject payPlan) {
        BigDecimal pushed;
        String plannumber = payPlan.getString("billno");
        BigDecimal rent = payPlan.getBigDecimal("rent");
        BigDecimal diff = rent.subtract(pushed = payPlan.getBigDecimal("pushedamount"));
        if (diff.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\uff1a%s\uff0c\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d-\u5df2\u4e0b\u63a8\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u53ef\u4ee5\u4e0b\u63a8\u3002", (String)"PcLockForLeasePayPlan_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), plannumber));
        }
        String bizStatus = payPlan.getString("curlease.bizstatus");
        Date planPayDate = payPlan.getDate("planpaydate");
        Date leaseEndDate = payPlan.getDate("curlease.leaseterminationdate");
        if ("B".equals(bizStatus) && planPayDate.after(leaseEndDate)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\uff1a%s\uff0c\u8ba1\u5212\u4ed8\u6b3e\u65e5\u8d85\u8fc7\u5408\u540c\u7684\u79df\u8d41\u7ec8\u6b62\u65e5\uff0c\u4e0d\u53ef\u4e0b\u63a8\u3002", (String)"PcLockForLeasePayPlan_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), plannumber));
        }
        if ("C".equals(bizStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\uff1a%s\uff0c\u5408\u540c\u4e1a\u52a1\u72b6\u6001\u4e3a\u53d8\u66f4\uff0c\u4e0d\u53ef\u4e0b\u63a8\u3002", (String)"PcLockForLeasePayPlan_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), plannumber));
        }
    }
}

