/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.pclock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.pclock.EntityName2PcLockConfig;

public class PcLockForLeaseRentSettle
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String entityName = this.billEntityType.getName();
        String prepareProperty = (String)EntityName2PcLockConfig.entityName2PreProperty.get(entityName);
        if (!StringUtils.isEmpty((CharSequence)prepareProperty)) {
            e.getFieldKeys().add(prepareProperty);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject[] billList = (DynamicObject[])Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
                if (billList.length == 0) {
                    return;
                }
                String operationKey = this.getOperateKey();
                if ("genvoucher_dn".equals(operationKey)) {
                    operationKey = "generatevoucher";
                } else if ("deletevoucher_dn".equals(operationKey)) {
                    operationKey = "deletevoucher";
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c", (String)"PcLockForLeaseRentSettle_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                ArrayList<Long> ids = new ArrayList<Long>(billList.length);
                for (DynamicObject bill : billList) {
                    Long d = bill.getLong("id");
                    ids.add(d);
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)"fa_lease_rent_settle", (Object[])ids.toArray(), (OperateOption)option);
                List allErrorInfo = result.getAllErrorOrValidateInfo();
                HashMap<Object, List> errMsgMap = new HashMap<Object, List>(allErrorInfo.size());
                for (IOperateInfo info : allErrorInfo) {
                    Object pk = info.getPkValue();
                    List errMsgList = errMsgMap.computeIfAbsent(pk, v -> new ArrayList());
                    errMsgList.add(info.getMessage());
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Object pk = dataEntity.getDataEntity().getPkValue();
                    List errMsgList = (List)errMsgMap.get(pk);
                    if (errMsgList == null) continue;
                    for (String errMsg : errMsgList) {
                        String billNo;
                        String prefix;
                        if (errMsg.startsWith(prefix = (billNo = dataEntity.getDataEntity().getString("billno")) + "\uff1a ")) {
                            errMsg = errMsg.substring(prefix.length());
                        }
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            }
        });
    }
}

