/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.opplugin.realcard.base.CodeRuleOp;

public abstract class BaseRealCardCodeRuleOp
extends CodeRuleOp {
    private static final Log logger = LogFactory.getLog(BaseRealCardCodeRuleOp.class);

    @Override
    public List<String> getSkipPropKeysForDirtyCheck() {
        return Arrays.asList("billnocoderule", "numberrule", "barcoderule");
    }

    @Override
    protected String getClassName() {
        return "fa_card_real";
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null) {
            Stream.of(dataEntities).forEach(this::setRuleFields);
        }
        super.onAddValidators(e);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null) {
            Stream.of(dataEntities).forEach(this::setRuleFields);
        }
        super.beginOperationTransaction(e);
    }

    @Override
    public void onReturnOperation(ReturnOperationArgs e) {
        if (super.getAllData() != null) {
            Stream.of(super.getAllData()).forEach(this::setRuleFields);
        }
        super.onReturnOperation(e);
    }

    @Override
    protected CodeRuleInfo getCodeRuleInfo(DynamicObject dynamicObject) {
        return super.getCodeRuleInfo(dynamicObject);
    }

    protected abstract void setRuleFields(DynamicObject var1);

    @Override
    protected boolean isOpenForOnlyNumber(String billNoFldKey, CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        boolean onlyBillNoUnique = false;
        Map operMeta = this.operateMeta;
        List validationList = (List)operMeta.get("validations");
        for (Map validationInfo : validationList) {
            if (!((Boolean)validationInfo.get("enabled")).booleanValue() || !"GroupFieldUnique".equals(validationInfo.get("ruleType"))) continue;
            List fields = (List)validationInfo.get("fields");
            if (fields.size() == 1 && ((Map)fields.get(0)).containsValue(billNoFldKey)) {
                onlyBillNoUnique = true;
                logger.info("[CodeRuleOp]\u627e\u5230\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c");
                break;
            }
            if (fields.size() != 2 || !((Map)fields.get(0)).containsValue(billNoFldKey)) continue;
            onlyBillNoUnique = true;
            logger.info("CodeRuleOp: \u627e\u5230\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c");
            break;
        }
        return onlyBillNoUnique;
    }

    @Override
    protected QFilter[] getQFilterExistUniqueBillNo(String billNoFldKey, String number, DynamicObject dynamicObject) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter(billNoFldKey, "=", (Object)number));
        if ("billno".equals(billNoFldKey)) {
            DynamicObject assetUnit = dynamicObject.getDynamicObject("assetunit");
            long assetUnitId = assetUnit.getLong("id");
            filters.add(new QFilter("assetunit", "=", (Object)assetUnitId));
        }
        return filters.toArray(new QFilter[0]);
    }
}

