/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.utils.FaCardInitFieldUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaChangeItemUtil;
import kd.fi.fa.opplugin.realcard.FaRealCardCommonValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaAbstractRealCardOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("assetcat");
        fieldKeys.add(Fa.dot((String[])new String[]{"assetcat", "isleaf"}));
        fieldKeys.add("billno");
        fieldKeys.add("barcode");
        fieldKeys.add("number");
        fieldKeys.add("assetname");
        fieldKeys.add("bizstatus");
        fieldKeys.add("realaccountdate");
        fieldKeys.add("assetamount");
        fieldKeys.add("unit");
        fieldKeys.add("originmethod");
        fieldKeys.add("storeplace");
        fieldKeys.add("usestatus");
        fieldKeys.add("headusedept");
        fieldKeys.add("initialcard");
        fieldKeys.add("barcoderule");
        fieldKeys.add("numberrule");
        fieldKeys.add("billnocoderule");
        fieldKeys.add("sourceflag");
        fieldKeys.add("sourceentryid");
        fieldKeys.add("usedate");
        fieldKeys.add("supplier");
        fieldKeys.add("srcbillnumber");
        fieldKeys.add("sourceentrysplitseq");
        fieldKeys.add("masterid");
        fieldKeys.add("createtime");
        fieldKeys.add("creator");
        fieldKeys.add("srcbillid");
        fieldKeys.add("barcoderecovery");
        fieldKeys.add("billnorecovery");
        fieldKeys.add("numberrecovery");
        fieldKeys.add("justrealcard");
        fieldKeys.add("price");
        fieldKeys.add("isimport");
        fieldKeys.add("srcbillentityname");
        fieldKeys.add("mergedcard");
        fieldKeys.add("costcentrer");
        fieldKeys.add("originaldata");
        fieldKeys.add("isbak");
        fieldKeys.add("productline");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaRealCardCommonValidator());
    }

    protected void setBaseInfoForAddNew(BeginOperationTransactionArgs e) {
        List<DynamicObject> cards = FaOpUtils.getDataEntities(e);
        for (DynamicObject card : cards) {
            long master = card.getLong("masterid");
            if (master == 0L) {
                card.set("masterid", (Object)card.getLong("id"));
            }
            card.set("originaldata", (Object)Boolean.TRUE);
        }
    }

    @Deprecated
    protected void setMasterId(BeginOperationTransactionArgs e) {
        this.setBaseInfoForAddNew(e);
    }

    protected void restoreInitFields(BeginOperationTransactionArgs e) {
        Set initFields = FaChangeItemUtil.getAllInitFields((String)"fa_card_real");
        if (initFields.isEmpty()) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        Set pks = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObject[] realCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)String.join((CharSequence)",", initFields), (QFilter[])new QFilter("id", "in", pks).toArray());
        FaCardInitFieldUtil.restoreInitFields((DynamicObject[])realCards);
        SaveServiceHelper.save((DynamicObject[])realCards);
    }
}

