/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.cardgenerate.CardGenerateHelper;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.utils.AttachmentUtils;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.realcard.FaAbstractRealCardOp;
import kd.fi.fa.utils.FaOpUtils;

public class FaRealCardAuditOp
extends FaAbstractRealCardOp
implements IFaOpHandler {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<Long, String> orgIdToNumber = new HashMap<Long, String>(4);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    long orgId = dataEntity.getDataEntity().getLong(Fa.id((String)"org"));
                    if (orgIdToNumber.get(orgId) != null) continue;
                    String number = dataEntity.getDataEntity().getDynamicObject("org").getString("number");
                    orgIdToNumber.put(orgId, number);
                }
                DynamicObjectCollection mainBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdToNumber.keySet()), new QFilter("ismainbook", "=", (Object)true)});
                Set bookOrgIds = mainBooks.stream().map(v -> v.getLong("org")).collect(Collectors.toSet());
                String numbers = "";
                for (Map.Entry entry : orgIdToNumber.entrySet()) {
                    if (bookOrgIds.contains(entry.getKey())) continue;
                    numbers = "\u3001" + (String)entry.getValue();
                }
                if (!numbers.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%s]\u4e0d\u5b58\u5728\u4e3b\u8d26\u7c3f\u3002", (String)"FaRealCardAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbers.substring(1)));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        HashMap<String, BeginOperationTransactionArgs> otherParams = new HashMap<String, BeginOperationTransactionArgs>(1, 1.0f);
        otherParams.put("beginArgs", e);
        FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operationKey, (String)"fa_card_real", (DynamicObject[])e.getDataEntities(), otherParams, (IFaOpHandler)this);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.updateAuditInfo4OriReal(e);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        BeginOperationTransactionArgs e = (BeginOperationTransactionArgs)otherParams.get("beginArgs");
        OperateOption option = this.getOption();
        boolean assetCardOperate = option.containsVariable("assetCardOperate");
        this.createOriginalReal(e);
        if (!assetCardOperate) {
            this.createFinCard(e);
        }
        super.restoreInitFields(e);
    }

    private void createOriginalReal(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> realCardIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            realCardIds.add(data.getLong("id"));
        }
        Collection realCards = BusinessDataServiceHelper.loadFromCache((String)"fa_card_real", (QFilter[])new QFilter[]{new QFilter("id", "in", realCardIds)}).values();
        ArrayList<DynamicObject> oriRealCards = new ArrayList<DynamicObject>(realCards.size());
        long[] ids = DB.genLongIds((String)"t_fa_card_real", (int)realCards.size());
        HashMap sourceId2TargetIdMap = new HashMap(realCards.size());
        HashMap<Long, Long> sourceTargetIdMap = new HashMap<Long, Long>(realCards.size());
        int i = 0;
        for (DynamicObject realCard : realCards) {
            DynamicObject oriRealCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)realCard);
            Long oriRealId = ids[i];
            oriRealCard.set("id", (Object)oriRealId);
            oriRealCard.set("isbak", (Object)Boolean.TRUE);
            oriRealCard.set("originaldata", (Object)Boolean.TRUE);
            oriRealCards.add(oriRealCard);
            ArrayList<Long> targetIds = new ArrayList<Long>(1);
            targetIds.add(oriRealId);
            sourceId2TargetIdMap.put(realCard.getLong("id"), targetIds);
            sourceTargetIdMap.put(realCard.getLong("id"), oriRealId);
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])oriRealCards.toArray(new DynamicObject[0]));
        FaCardBotpUtil.copyRepairTC(sourceTargetIdMap, (String)"fa_card_real");
        Set<Object> pks = realCards.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_fa_card_real set foriginaldata = '0' where foriginaldata = '1' and ", new Object[0]);
        sql.appendIn(" fid ", pks.toArray(new Object[0]));
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sql);
        AttachmentUtils.copyAttachments((String)"fa_card_real", (String)"fa_card_real", (String)"attachmentpanel", sourceId2TargetIdMap);
    }

    private void updateAuditInfo4OriReal(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> realCardIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            realCardIds.add(data.getLong("id"));
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(realCardIds.size());
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fmasterid,fbillstatus,fbizstatus,fauditdate,fauditorid from t_fa_card_real where ", new Object[0]);
        querySql.appendIn(" fid ", realCardIds.toArray(new Object[0]));
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                Object[] auditInfo = new Object[]{row.getString("fbillstatus"), row.getString("fbizstatus"), row.getDate("fauditdate"), row.getLong("fauditorid"), row.getLong("fmasterid")};
                params.add(auditInfo);
            }
        }
        String updateSql = "update t_fa_card_real set fbillstatus = ?,fbizstatus = ?,fauditdate = ?,fauditorid = ? where fmasterid = ? and foriginaldata = '1';";
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, params);
    }

    private void createFinCard(BeginOperationTransactionArgs e) {
        Map<Object, List<DynamicObject>> orgDynamicObjectMap = this.orgDynamicObjectMap(e);
        for (Map.Entry<Object, List<DynamicObject>> entry : orgDynamicObjectMap.entrySet()) {
            CardGenerateHelper.generateFinCard(entry.getValue());
        }
    }

    private Map<Object, List<DynamicObject>> orgDynamicObjectMap(BeginOperationTransactionArgs e) {
        HashMap<Object, List<DynamicObject>> orgCardMap = new HashMap<Object, List<DynamicObject>>(16);
        for (DynamicObject realCard : FaOpUtils.getDataEntities(e)) {
            Object orgPk = realCard.getDynamicObject("org").getPkValue();
            List cards = orgCardMap.computeIfAbsent(orgPk, v -> new ArrayList());
            cards.add(realCard);
        }
        return orgCardMap;
    }
}

