/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.opplugin.FaCardDeleteRelationValidator;
import kd.fi.fa.opplugin.FaRealCheckClearApplyValidator;
import kd.fi.fa.opplugin.realcard.FaAbstractRealCardOp;
import kd.fi.fa.opplugin.realcard.FaRealCardDeleteValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaRealCardDeleteOp
extends FaAbstractRealCardOp {
    private static final Log logger = LogFactory.getLog(FaRealCardDeleteOp.class);

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        boolean deleteClearBillByUnAudit = this.getOption().containsVariable("deleteRealCardByInvdiffer");
        if (deleteClearBillByUnAudit) {
            return;
        }
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaRealCardDeleteValidator());
        e.addValidator((AbstractValidator)new FaRealCheckClearApplyValidator(this.billEntityType));
        this.getOption().setVariableValue("ignorerefentityids", FaConstants.ignorerefentityids_forRealCard);
        e.getValidators().add(new FaCardDeleteRelationValidator("fa_card_real_base"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.dealPurchaseCard(e);
        Set cardIds = Arrays.stream(e.getDataEntities()).map(card -> card.getLong("masterid")).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"fa_additiondevrecord", (QFilter[])new QFilter[]{new QFilter("realcard", "in", cardIds)});
    }

    private void dealPurchaseCard(BeginOperationTransactionArgs e) {
        List purchaseObjects = FaOpUtils.getDataEntities(e).stream().filter(item -> "PURCHASE".equals(item.getString("sourceflag"))).collect(Collectors.toList());
        Map<Object, List<DynamicObject>> collect = purchaseObjects.stream().collect(Collectors.groupingBy(t -> t.getLong("sourceentryid")));
        ArrayList listUpdateObject = new ArrayList();
        collect.forEach((k, v) -> {
            Object[] objects = new Object[]{v == null ? 0 : v.size(), k};
            listUpdateObject.add(objects);
        });
        if (CollectionUtils.isEmpty(listUpdateObject)) {
            logger.info("\u66f4\u65b0\u91c7\u8d2d\u8f6c\u56fa\u5355\u76f8\u5e94\u53ef\u751f\u6210\u6570\u91cf:listUpdatObject\u4e3a\u7a7a");
            return;
        }
        String sql = "update T_FA_PURCHASEBILLENTRY set fassetqtyleft = fassetqtyleft + ? where fentryid= ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, listUpdateObject);
    }
}

