/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.fi.fa.opplugin.realcard.FaAbstractRealCardOp;
import kd.fi.fa.opplugin.realcard.FaRealCardSubmitValidator;
import kd.fi.fa.opplugin.validator.FaProductLineValidator;

public class FaRealCardSubmitOp
extends FaAbstractRealCardOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaRealCardSubmitValidator());
        e.addValidator((AbstractValidator)new FaProductLineValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.setBaseInfoForAddNew(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] finCardObjs = e.getDataEntities();
        QFilter filter = new QFilter("enable", "=", (Object)"A");
        QFilter[] filters = new QFilter[]{filter};
        if (QueryServiceHelper.exists((String)"bas_imageconfig", (QFilter[])filters) && QueryServiceHelper.exists((String)"bos_imagestrategy", (QFilter[])filters)) {
            this.generateImageNumberBatchAsyn(finCardObjs);
        }
    }

    private void generateImageNumberBatchAsyn(DynamicObject[] dataEntities) {
        ArrayList<ImageInfo> imageInfoList = new ArrayList<ImageInfo>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String creator;
            String pkId = dataEntity.getPkValue().toString();
            Date createTime = dataEntity.getDate("createtime");
            if (null == createTime) {
                createTime = new Date();
            }
            if (null == dataEntity.getDynamicObject("creator")) {
                RequestContext requestContext = RequestContext.get();
                creator = requestContext.getUserId();
            } else {
                creator = dataEntity.getDynamicObject("creator").getPkValue().toString();
            }
            String orgId = dataEntity.getDynamicObject("org").getPkValue().toString();
            Date date = new Date();
            int dateHash = date.hashCode();
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setCreatetime(createTime);
            imageInfo.setCreator(creator);
            imageInfo.setOrgId(orgId);
            imageInfo.setBilltype(dataEntity.getDynamicObjectType().getName());
            imageInfo.setBillNo(pkId + "-" + dateHash);
            imageInfo.setBillId(pkId);
            imageInfoList.add(imageInfo);
        }
        ImageServiceHelper.createImageInfoBatchAsyn(imageInfoList);
    }
}

