/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.business.plugin.AbstractUniqueBillno;
import kd.bos.business.plugin.CodeRuleValidator;
import kd.bos.business.plugin.UniqueBillno;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.opplugin.pagecache.BillNoChangeCache;
import kd.bos.coderule.opplugin.pagecache.RecycleCache;
import kd.bos.coderule.opplugin.util.OrgUtil;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.opplugin.realcard.base.CodeRuleOpStatusRecord;

public class AbstractCodeRuleOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(kd.bos.business.plugin.AbstractCodeRuleOp.class);
    public static final int loopNum = 50;
    public static final String SKIPBILLNOVALIDATOR = "skipbillnovalidator";
    private static final String SKIPBILLNOVALIDATOR_VALUE = "skipbillnovalidator_value";
    protected CodeRuleServiceImp codeRuleService;
    protected AbstractUniqueBillno uniqueBillno = new UniqueBillno();
    protected CodeRuleOpStatusRecord statusRecord;

    private String getEntityId() {
        return "fa_card_real";
    }

    private String getSkipbillnovalidator() {
        return SKIPBILLNOVALIDATOR + this.getClassName();
    }

    private String getSkipbillnovalidatorValue() {
        return SKIPBILLNOVALIDATOR_VALUE + this.getClassName();
    }

    protected String getClassName() {
        return "AbstractCodeRule";
    }

    public AbstractCodeRuleOp() {
        this.codeRuleService = new CodeRuleServiceImp();
        this.statusRecord = new CodeRuleOpStatusRecord();
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.rebackBillno(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.generateNumber(e.getDataEntities());
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        this.recycleOldNumberWhenSuccess(e.getOperationResult());
        logger.info("[CodeRuleOp]\u751f\u6210\u7f16\u53f7\u6d41\u7a0b\u8bb0\u5f55\uff1a" + this.statusRecord.toString());
    }

    public void generateNumber(DynamicObject[] dynamicObjects) {
        if (!(this.billEntityType instanceof BillEntityType)) {
            return;
        }
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        if (!"save".equals(operateType) && !"submit".equals(operateType)) {
            return;
        }
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            String webapitagOfDatasource;
            this.statusRecord.initDataOperateProcess(dynamicObjects);
            if (this.operateOption.tryGetVariableValue("webapitag_of_datasource", new RefObject())) {
                webapitagOfDatasource = this.operateOption.getVariableValue("webapitag_of_datasource");
                if (String.valueOf(true).equals(webapitagOfDatasource)) {
                    logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3aOpenApi>\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e(" + dynamicObjects.length + ")");
                    this.statusRecord.tagOperateSourceStatus(CodeRuleOpStatusRecord.OperateSourceStatus.WEBAPI_BATCH_GENERATE);
                    this.batchGenerateNumberFromExcel(dynamicObjects);
                    return;
                }
            }
            if (this.operateOption.tryGetVariableValue("importtag_of_datasource", new RefObject())) {
                webapitagOfDatasource = this.operateOption.getVariableValue("importtag_of_datasource");
                if (String.valueOf(true).equals(webapitagOfDatasource)) {
                    logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3a\u5f15\u5165>\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e(" + dynamicObjects.length + ")");
                    this.statusRecord.tagOperateSourceStatus(CodeRuleOpStatusRecord.OperateSourceStatus.IMPORT_BATCH_GENERATE);
                    this.batchGenerateNumberFromExcel(dynamicObjects);
                    return;
                }
            }
            if (dynamicObjects.length > 1) {
                logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3a\u5217\u8868or\u5168\u90e8\u4e0b\u63a8>\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e (" + dynamicObjects.length + ")");
                this.statusRecord.tagOperateSourceStatus(CodeRuleOpStatusRecord.OperateSourceStatus.PUSH_GENERATE_NUMBERS);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.singleGenerateNumber(dynamicObject);
                }
                return;
            }
            logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3a\u8868\u5355\u6216\u5217\u8868>\u4ec5\u5904\u7406\u4e00\u6761\u6570\u636e");
            this.statusRecord.tagOperateSourceStatus(CodeRuleOpStatusRecord.OperateSourceStatus.BILL_GENERATE_NUMBER);
            this.singleGenerateNumber(dynamicObjects[0]);
        }
    }

    protected void rebackBillno(AddValidatorsEventArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (!(this.billEntityType instanceof BillEntityType)) {
            return;
        }
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        if (!"save".equals(operateType) && !"submit".equals(operateType)) {
            return;
        }
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            BillEntityType dataEntityType;
            String billno;
            String importFlag;
            if (this.operateOption.tryGetVariableValue("ignoreinteraction", new RefObject()) && "true".equals(importFlag = this.operateOption.getVariableValue("ignoreinteraction"))) {
                return;
            }
            if (dynamicObjects.length > 1) {
                return;
            }
            boolean skipbillnovalidator = this.operateOption.tryGetVariableValue(this.getSkipbillnovalidator(), new RefObject());
            if (skipbillnovalidator && this.operateOption.getVariableValue(this.getSkipbillnovalidator()).equals(String.valueOf(true)) && "".equals(billno = dynamicObjects[0].get(this.getBillNoField(dataEntityType = (BillEntityType)dynamicObjects[0].getDataEntityType())).toString())) {
                logger.info("[CodeRuleOp]\u8fd8\u539f\u88ab\u8868\u5355\u63d2\u4ef6\u8bbe\u7f6e\u7684\u7a7a\u503c,\u5e76\u8865\u5145CodeRuleValidator\u6821\u9a8c\u5668");
                CodeRuleValidator validator = new CodeRuleValidator(this.operateOption.getVariableValue(this.getSkipbillnovalidatorValue()));
                e.getValidators().add(0, validator);
            }
        }
    }

    private void recycleOldNumberWhenSuccess(IOperationResult operationResult) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map<DynamicObject, CodeRuleOpStatusRecord.OperateProcess> allDataStatus = this.statusRecord.getDataOperateProcess();
        if (allDataStatus == null || allDataStatus.isEmpty()) {
            return;
        }
        for (Map.Entry<DynamicObject, CodeRuleOpStatusRecord.OperateProcess> statusEntry : allDataStatus.entrySet()) {
            DynamicObject dynamicObject = statusEntry.getKey();
            if (!successPkIds.contains(dynamicObject.getPkValue()) || CodeRuleOpStatusRecord.RecycleStatus.GENERATE_NEW_RECYCLE_OLD != statusEntry.getValue().getRecycleStatus() && CodeRuleOpStatusRecord.RecycleStatus.USER_INPUT_RECYCLE_OLD != statusEntry.getValue().getRecycleStatus()) continue;
            this.recycleOldNumber(this.getCodeRuleInfo(dynamicObject), dynamicObject);
        }
    }

    private void singleGenerateNumber(DynamicObject dynamicObject) {
        boolean isNew;
        BillEntityType billEntityType = (BillEntityType)dynamicObject.getDataEntityType();
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo(dynamicObject);
        if (codeRuleInfo == null) {
            return;
        }
        boolean bl = isNew = !dynamicObject.getDataEntityState().getFromDatabase();
        if (isNew) {
            logger.info("[CodeRuleOp]\u65b0\u589e\u4e00\u6761\u6570\u636e");
            this.statusRecord.tagDataStatus(dynamicObject, CodeRuleOpStatusRecord.DataStatus.DATA_NEW);
            this.singleGenerateNewNumber(dynamicObject, billEntityType, codeRuleInfo);
        } else {
            logger.info("[CodeRuleOp]\u4fee\u6539\u4e00\u6761\u6570\u636e");
            this.statusRecord.tagDataStatus(dynamicObject, CodeRuleOpStatusRecord.DataStatus.DATA_UPDATE);
            this.singleGenerateUpdateNumber(dynamicObject, billEntityType, codeRuleInfo);
        }
    }

    protected CodeRuleInfo getCodeRuleInfo(DynamicObject dynamicObject) {
        String entityNum = this.getEntityId();
        String orgId = OrgUtil.getMainOrgId((DynamicObject)dynamicObject);
        return CodeRuleServiceHelper.getCodeRule((String)entityNum, (DynamicObject)dynamicObject, (String)orgId);
    }

    private void singleGenerateNewNumber(DynamicObject dynamicObject, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        boolean billNOIsEmpty;
        logger.info("[CodeRuleOp]\u751f\u6210\u7f16\u53f7");
        String billNoFldKey = this.getBillNoField(billEntityType);
        boolean bl = billNOIsEmpty = !"".equals(dynamicObject.getString(billNoFldKey));
        if (dynamicObject.containsProperty("sourceflag") && SourceFlagEnum.SPLIT.name().equals(dynamicObject.getString("sourceflag")) && billNOIsEmpty) {
            return;
        }
        if (!this.operateOption.tryGetVariableValue(this.getSkipbillnovalidator(), new RefObject()) && billNOIsEmpty) {
            logger.info("[AbstractCodeRuleOp]\u901a\u8fc7OperationServiceHelper\u65b9\u5f0f\u8fdb\u5165\u5230\u64cd\u4f5c\u63d2\u4ef6");
            boolean fitCodeRule = this.codeRuleService.checkNumber(dynamicObject, dynamicObject.getString(billNoFldKey), codeRuleInfo);
            if (!fitCodeRule) {
                logger.info("[AbstractCodeRuleOp]\u4f20\u5165\u7684\u7f16\u53f7\u4e0e\u7f16\u7801\u89c4\u5219\u683c\u5f0f\u4e0d\u4e00\u81f4,\u5224\u65ad\u5f53\u524d\u573a\u666f\u662f\u5355\u5143\u6d4b\u8bd5");
                this.statusRecord.tagBillNoStatus(dynamicObject, CodeRuleOpStatusRecord.BillNoStatus.FORMAT_MISMATCH);
                return;
            }
        }
        this.statusRecord.tagResultStatus(dynamicObject, CodeRuleOpStatusRecord.ResultStatus.NO_NUMBER_GENERATE);
        if (this.validateFitCodeRuleByOldNumber(codeRuleInfo)) {
            String newNumber = this.invokeGetNumber(dynamicObject, codeRuleInfo);
            if (this.isOpenForOnlyNumber(billNoFldKey, codeRuleInfo, dynamicObject)) {
                newNumber = this.generateNumberForUniqueBillno(dynamicObject, billNoFldKey, codeRuleInfo, newNumber);
            }
            dynamicObject.set(billNoFldKey, (Object)newNumber);
            this.statusRecord.tagResultStatus(dynamicObject, CodeRuleOpStatusRecord.ResultStatus.NEW_NUMBER);
        }
    }

    private String invokeGetNumber(DynamicObject dynamicObject, CodeRuleInfo codeRuleInfo) {
        String number = null;
        try {
            number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObject);
        }
        catch (KDException e) {
            logger.error((Throwable)e);
            if (e.getErrorCode() != null && "ERRCODE_CODERULE_VALIDATE_NUMBER".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getErrorCode(), new Object[0]);
            }
            throw new KDException(e.getErrorCode(), new Object[0]);
        }
        return number;
    }

    protected String getBillNoField(BillEntityType billEntityType) {
        return billEntityType.getBillNo();
    }

    private boolean validateFitCodeRuleByOldNumber(CodeRuleInfo codeRuleInfo) {
        return codeRuleInfo.getIsModifiable() == false || !new BillNoChangeCache(this.getClassName()).isChange(this.operateOption);
    }

    protected boolean isOpenForOnlyNumber(String billNoFldKey, CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        Map operMeta = this.operateMeta;
        List validationList = (List)operMeta.get("validations");
        boolean onlyBillNoUnique = this.uniqueBillno.validateGrpFieldUnique(billNoFldKey, validationList, dynamicObject);
        return onlyBillNoUnique;
    }

    private String generateNumberForUniqueBillno(DynamicObject dynamicObject, String billNoFldKey, CodeRuleInfo codeRuleInfo, String number) {
        block2: {
            String entityNum = this.getEntityId();
            int loopCount = 0;
            do {
                boolean existBillNum;
                if (!(existBillNum = this.uniqueBillno.checkReatedInDB(entityNum, this.getQFilterExistUniqueBillNo(billNoFldKey, number, dynamicObject)))) {
                    logger.info("[CodeRuleOp]\u5c1d\u8bd5" + loopCount + "\u6b21\u540e\u53d1\u73b0\u4e0d\u91cd\u590d\u7684\u7f16\u7801");
                    break block2;
                }
                number = this.invokeGetNumber(dynamicObject, codeRuleInfo);
            } while (++loopCount <= 50);
            logger.info("[CodeRuleOp]\u5c1d\u8bd550\u6b21\u540e\u4f9d\u7136\u6ca1\u6709\u53d1\u73b0\u4e0d\u91cd\u590d\u7684\u7f16\u7801,\u505c\u6b62\u7ee7\u7eed\u6d88\u8017\u6d41\u6c34\u53f7");
        }
        return number;
    }

    protected QFilter[] getQFilterExistUniqueBillNo(String billNoFldKey, String number, DynamicObject dynamicObject) {
        return this.uniqueBillno.buildQFilter(billNoFldKey, number, dynamicObject);
    }

    protected QFilter[] getQFilterExistsUniqueBillNo(String billNoFldKey, LinkedHashMap<String, DynamicObject> dynamicObjectMap) {
        return new QFilter(billNoFldKey, "in", dynamicObjectMap.keySet()).toArray();
    }

    private void singleGenerateUpdateNumber(DynamicObject dynamicObject, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        if (!this.validateFitCodeRuleByOldNumber(codeRuleInfo)) {
            this.statusRecord.tagBillNoStatus(dynamicObject, CodeRuleOpStatusRecord.BillNoStatus.IS_USER_INPUT);
            this.statusRecord.tagResultStatus(dynamicObject, CodeRuleOpStatusRecord.ResultStatus.NO_NUMBER_GENERATE);
            this.statusRecord.tagRecycleStatus(dynamicObject, CodeRuleOpStatusRecord.RecycleStatus.USER_INPUT_RECYCLE_OLD);
            return;
        }
        this.statusRecord.tagResultStatus(dynamicObject, CodeRuleOpStatusRecord.ResultStatus.UPDATE_NUMBER);
        if (this.validateRebuildNumberAtUpdate(dynamicObject, billEntityType, codeRuleInfo)) {
            logger.info("[CodeRuleOp]\u91cd\u751f\u6210\u7f16\u53f7");
            this.singleGenerateNewNumber(dynamicObject, billEntityType, codeRuleInfo);
            this.statusRecord.tagRecycleStatus(dynamicObject, CodeRuleOpStatusRecord.RecycleStatus.GENERATE_NEW_RECYCLE_OLD);
        }
    }

    protected boolean validateRebuildNumberAtUpdate(DynamicObject dynamicObject, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        if (!codeRuleInfo.isUpdateRecover()) {
            return false;
        }
        String billNoFldKey = this.getBillNoField(billEntityType);
        String number = dynamicObject.getString(billNoFldKey);
        return StringUtils.isNotBlank((CharSequence)number) && this.dirtyPropsContainBillNoRelFieldKey(dynamicObject, billNoFldKey, codeRuleInfo);
    }

    protected void signResourceFromList() {
        this.operateOption.setVariableValue(this.getSkipbillnovalidator(), String.valueOf(true));
    }

    private boolean dirtyPropsContainBillNoRelFieldKey(DynamicObject dObj, String billNoFieldKey, CodeRuleInfo codeRuleInfo) {
        List dirtyProperties = dObj.getDataEntityState().GetDirtyProperties();
        if (CollectionUtils.isEmpty((Collection)dirtyProperties)) {
            return false;
        }
        List dirtyPropKeys = dirtyProperties.stream().map(IMetadata::getName).collect(Collectors.toList());
        Set propertiesSet = Optional.ofNullable(codeRuleInfo.getRuleEntry()).map(Collection::stream).orElseGet(Stream::empty).filter(StringUtils::isNotBlank).map(entry -> entry.getValueAtribute().split("\\.")[0]).collect(Collectors.toSet());
        List conditionEntry = codeRuleInfo.getConditionEntry();
        if (!CollectionUtils.isEmpty((Collection)conditionEntry)) {
            String billStatusFieldKey = "";
            IDataEntityType dataEntityType = dObj.getDataEntityType();
            if (dataEntityType instanceof BillEntityType) {
                billStatusFieldKey = ((BillEntityType)dataEntityType).getBillStatus();
            }
            for (ConditionEntryInfo entryInfo : conditionEntry) {
                String conditionPropKey = entryInfo.getProperty();
                if (StringUtils.isNotEmpty((CharSequence)billStatusFieldKey) && billStatusFieldKey.equals(conditionPropKey)) continue;
                propertiesSet.add(entryInfo.getProperty());
            }
        }
        List<String> skipPropKeys = this.getSkipPropKeysForDirtyCheck();
        for (String propertyKey : propertiesSet) {
            if (!StringUtils.isNotEmpty((CharSequence)propertyKey) || !CollectionUtils.isEmpty(skipPropKeys) && skipPropKeys.contains(propertyKey) || !dirtyPropKeys.contains(propertyKey)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getSkipPropKeysForDirtyCheck() {
        return null;
    }

    private void recycleOldNumber(CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        if (codeRuleInfo.getIsNonBreak().booleanValue()) {
            RecycleCache recycleCache = new RecycleCache(this.getClassName());
            String recycleNumber = recycleCache.getNumber(this.operateOption);
            DynamicObject dynamicObj = recycleCache.getDynamicObj(this.operateOption, (DynamicObjectType)dynamicObject.getDataEntityType());
            if (StringUtils.isNotBlank((CharSequence)recycleNumber) && dynamicObj != null) {
                this.codeRuleService.recycleNumber(codeRuleInfo, dynamicObj, recycleNumber);
            }
        }
    }

    private void batchGenerateNumberFromExcel(DynamicObject[] dynamicObjects) {
        this.batchGenerateNumberBySimpleLogic(dynamicObjects);
    }

    private void batchGenerateNumberBySimpleLogic(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> mayGenerateDynamicObjs = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> unGenerateDynamicObjs = new ArrayList<DynamicObject>(8);
        this.statusRecord.batchTagDataStatus(dynamicObjects, CodeRuleOpStatusRecord.DataStatus.BATCH_GENERATE);
        this.composeDynamicObjs(dynamicObjects, mayGenerateDynamicObjs, unGenerateDynamicObjs);
        this.updateMaxserialNumbers(unGenerateDynamicObjs);
        this.generateNumbers(mayGenerateDynamicObjs);
    }

    private List<DynamicObject> composeDynamicObjs(DynamicObject[] originalDynamicObjects, List<DynamicObject> mayGenerateDynamicObjs, List<DynamicObject> unGenerateDynamicObjs) {
        if (!this.validateBillNo()) {
            return new ArrayList<DynamicObject>(0);
        }
        String billNoFldKey = this.getBillNoField((BillEntityType)this.billEntityType);
        for (DynamicObject obj : originalDynamicObjects) {
            String billNo = obj.getString(billNoFldKey);
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                unGenerateDynamicObjs.add(obj);
                this.statusRecord.tagBillNoStatus(obj, CodeRuleOpStatusRecord.BillNoStatus.NOT_EMPTY);
                continue;
            }
            this.statusRecord.tagBillNoStatus(obj, CodeRuleOpStatusRecord.BillNoStatus.EMPTY);
            mayGenerateDynamicObjs.add(obj);
        }
        return mayGenerateDynamicObjs;
    }

    private boolean validateBillNo() {
        BillEntityType dt = (BillEntityType)this.billEntityType;
        if (dt == null) {
            return false;
        }
        String billNoFldKey = this.getBillNoField(dt);
        return !StringUtils.isEmpty((CharSequence)billNoFldKey);
    }

    private void generateNumbers(List<DynamicObject> mayGenerateDynamicObjs) {
        if (!this.validateBillNo()) {
            return;
        }
        if (CollectionUtils.isEmpty(mayGenerateDynamicObjs)) {
            return;
        }
        String billNoFldKey = this.getBillNoField((BillEntityType)this.billEntityType);
        String entityName = this.getEntityId();
        List numbers = this.codeRuleService.getNumbers(entityName, mayGenerateDynamicObjs);
        for (int i = 0; i < mayGenerateDynamicObjs.size(); ++i) {
            DynamicObject dynamicObject = mayGenerateDynamicObjs.get(i);
            if (numbers.get(i) == null) {
                this.statusRecord.tagResultStatus(dynamicObject, CodeRuleOpStatusRecord.ResultStatus.NO_NUMBER_GENERATE);
                continue;
            }
            dynamicObject.set(billNoFldKey, numbers.get(i));
            this.statusRecord.tagResultStatus(dynamicObject, CodeRuleOpStatusRecord.ResultStatus.NEW_NUMBER);
        }
    }

    private void updateMaxserialNumbers(List<DynamicObject> unGenerateDynamicObjs) {
        String billNoFldKey = this.getBillNoField((BillEntityType)this.billEntityType);
        this.codeRuleService.updateMaxserialNumbers(unGenerateDynamicObjs, billNoFldKey);
    }

    private void batchGenerateNumber(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> nullNumberDatas = new ArrayList<DynamicObject>();
        BillEntityType dt = (BillEntityType)this.billEntityType;
        if (dt == null || StringUtils.isBlank((CharSequence)dt.getBillNo())) {
            return;
        }
        String billNoFldKey = this.getBillNoField(dt);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : dynamicObjects) {
            boolean isNew = !obj.getDataEntityState().getFromDatabase();
            String billNo = obj.getString(billNoFldKey);
            if (isNew && StringUtils.isNotBlank((CharSequence)billNo)) {
                dynamicObjectList.add(obj);
            }
            if (!StringUtils.isBlank((CharSequence)billNo)) continue;
            nullNumberDatas.add(obj);
        }
        for (DynamicObject dynamicObject : dynamicObjectList) {
            this.singleGenerateNumber(dynamicObject);
        }
        if (nullNumberDatas.size() == 0) {
            return;
        }
        String entityName = this.getEntityId();
        logger.info("[CodeRuleOp]\u5b9e\u4f53:" + entityName + "\u8ba1\u5212\u751f\u6210" + nullNumberDatas.size() + "\u4e2a\u7f16\u7801");
        if (dt.getBillNo().equals(this.getBillNoField(dt))) {
            this.codeRuleService.injectNumbers(entityName, nullNumberDatas);
        } else if (this.getCodeRuleInfo((DynamicObject)nullNumberDatas.get(0)) != null) {
            List numbers = this.codeRuleService.getNumbers(entityName, nullNumberDatas, this.getCodeRuleInfo((DynamicObject)nullNumberDatas.get(0)));
            for (int i = 0; i < nullNumberDatas.size(); ++i) {
                if (numbers.get(i) == null) continue;
                ((DynamicObject)nullNumberDatas.get(i)).set(this.getBillNoField(dt), numbers.get(i));
            }
        }
        int count = 0;
        for (DynamicObject numberData : nullNumberDatas) {
            Object realBillNo = numberData.get(this.getBillNoField(dt));
            if (ObjectUtils.isEmpty((Object)realBillNo)) continue;
            ++count;
        }
        logger.info("[CodeRuleOp]\u5b9e\u4f53:" + entityName + "\u6210\u529f\u751f\u6210" + count + "\u4e2a\u7f16\u7801");
    }
}

