/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard.base;

import java.util.ArrayList;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.opplugin.util.DynamicObjUtil;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.fa.business.utils.FaOperateLogUtil;

public class CodeRuleDeleteOp
extends AbstractOperationServicePlugIn {
    private String getEntityId() {
        return "fa_card_real";
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String entityTypeName = this.getEntityId();
        List codeRuleList = CodeRuleCache.getAllCodeRuleByEntity((String)entityTypeName);
        if (codeRuleList != null && !codeRuleList.isEmpty()) {
            for (CodeRuleInfo codeRuleInfo : codeRuleList) {
                DynamicObjUtil.injectFieldFromConditionEntry((List)e.getFieldKeys(), (List)codeRuleInfo.getConditionEntry());
                DynamicObjUtil.injectFieldFromCodeRuleEntry((List)e.getFieldKeys(), (List)codeRuleInfo.getRuleEntry());
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.recycleNumber(e.getDataEntities());
    }

    protected void recycleNumber(DynamicObject[] objs) {
        String billNoField;
        if (objs != null && objs.length != 0 && this.billEntityType instanceof BillEntityType && !StringUtils.isBlank((CharSequence)(billNoField = this.getBillNoField()))) {
            ArrayList<String> billNos = new ArrayList<String>();
            ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
            for (int i = 0; i < objs.length; ++i) {
                String billNo = objs[i].getString(billNoField);
                if (!StringUtils.isNotBlank((CharSequence)billNo)) continue;
                billNos.add(billNo);
                objList.add(objs[i]);
            }
            if (!billNos.isEmpty()) {
                FaOperateLogUtil.addLog((String)this.billEntityType.getName(), (String)((Object)((Object)this)).getClass().getSimpleName(), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%s", (String)"CodeRuleDeleteOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), StringUtils.join((Object[])billNos.toArray(), (String)",")));
                CodeRuleServiceHelper.recycleBatchNumber((String)this.getEntityId(), (DynamicObject[])objList.toArray(new DynamicObject[objList.size()]), (String)null, (String[])billNos.toArray(new String[billNos.size()]));
            }
        }
    }

    protected String getBillNoField() {
        return ((BillEntityType)this.billEntityType).getBillNo();
    }
}

