/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.opplugin.realcard.base.AbstractCodeRuleOp;

public class CodeRuleOp
extends AbstractCodeRuleOp {
    private static final Log logger = LogFactory.getLog(kd.bos.business.plugin.CodeRuleOp.class);
    private DynamicObject[] allData = null;
    private CodeRuleServiceImp codeRuleServiceImp = new CodeRuleServiceImp();

    private String getEntityId() {
        return "fa_card_real";
    }

    protected DynamicObject[] getAllData() {
        return this.allData;
    }

    protected void setCodeRuleService(CodeRuleServiceImp codeRuleServiceImp) {
        this.codeRuleService = codeRuleServiceImp;
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        this.rebackBillno(e);
        this.allData = e.getDataEntities();
        this.generateNumber(e.getDataEntities());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    @Override
    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.allData == null || this.allData.length == 0) {
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(Arrays.asList(this.allData));
        for (int i = this.allData.length - 1; i >= 0; --i) {
            if (!e.getOperationResult().getSuccessPkIds().contains(this.allData[i].getPkValue())) continue;
            list.remove(i);
        }
        if (!list.isEmpty()) {
            logger.info("[CodeRuleOp]\u672c\u6b21\u64cd\u4f5c\u6ca1\u6709\u6210\u529f\u51c6\u5907\u5c1d\u8bd5\u56de\u6536\u5904\u7406");
            this.recycleNumber(list, (BillEntityType)this.billEntityType);
        }
    }

    protected void recycleNumber(List<DynamicObject> list, BillEntityType dt) {
        if (dt == null) {
            return;
        }
        String billNoFldKey = this.getBillNoField(dt);
        if (StringUtils.isBlank((String)billNoFldKey)) {
            return;
        }
        String entityNum = this.getEntityId();
        List codeRuleList = this.codeRuleService.getAllCodeRuleByEntity(entityNum);
        if (CollectionUtils.isEmpty((Collection)codeRuleList)) {
            return;
        }
        LinkedHashMap dynamicObjectMap = list.stream().filter(dynamicObject -> this.checkCodeRule(entityNum, codeRuleList, (DynamicObject)dynamicObject) != null).collect(Collectors.toMap(dt1 -> dt1.getString(billNoFldKey), dt1 -> dt1, (o, o2) -> o, LinkedHashMap::new));
        if (CodeRuleSystemParam.getMcParam((String)"code_rule_op.recycleNumber") && dynamicObjectMap.entrySet().size() > 10) {
            Set<String> numbers = this.validateNumbersInBusinessDB(entityNum, billNoFldKey, dynamicObjectMap);
            for (Map.Entry entry : dynamicObjectMap.entrySet()) {
                CodeRuleInfo codeRuleInfo;
                if (!CollectionUtils.isEmpty(numbers) && numbers.contains(entry.getKey())) continue;
                String number = (String)entry.getKey();
                DynamicObject dynamicObject2 = (DynamicObject)entry.getValue();
                if (dynamicObject2 == null || (codeRuleInfo = this.checkCodeRule(entityNum, codeRuleList, dynamicObject2)) == null) continue;
                boolean isEdit = dynamicObject2.getDataEntityState().getFromDatabase();
                if (isEdit && !codeRuleInfo.isUpdateRecover()) {
                    logger.info("CodeRuleServiceImp.recycleNumber(): \u52a8\u6001\u5bf9\u8c61\u6765\u81ea\u6570\u636e\u5e93, \u4e14\u672a\u5f00\u542f\u4fee\u6539\u65f6\u91cd\u7f16\u7801, \u4e0d\u56de\u6536\u7f16\u7801");
                    continue;
                }
                logger.info(String.format("CodeRuleServiceImp.recycleNumber(): entityId: %s , dataInfo: %s ,  orgID: %s , number: %s ", entityNum, dynamicObject2 != null ? dynamicObject2.getPkValue() : null, null, number));
                this.codeRuleService.recycleNumber(codeRuleInfo, dynamicObject2, number);
            }
            return;
        }
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            boolean isExist;
            DynamicObject dynamicObject3 = (DynamicObject)entry.getValue();
            CodeRuleInfo codeRuleInfo = this.checkCodeRule(entityNum, codeRuleList, dynamicObject3);
            if (codeRuleInfo == null) continue;
            boolean isEdit = dynamicObject3.getDataEntityState().getFromDatabase();
            if (isEdit && !codeRuleInfo.isUpdateRecover()) {
                logger.info("CodeRuleServiceImp.recycleNumber(): \u52a8\u6001\u5bf9\u8c61\u6765\u81ea\u6570\u636e\u5e93, \u4e14\u672a\u5f00\u542f\u4fee\u6539\u65f6\u91cd\u7f16\u7801, \u4e0d\u56de\u6536\u7f16\u7801");
                continue;
            }
            String number = dynamicObject3.getString(billNoFldKey);
            if (this.isOpenForOnlyNumber(billNoFldKey, codeRuleInfo, dynamicObject3) && (isExist = this.uniqueBillno.checkReatedInDB(entityNum, this.getQFilterExistUniqueBillNo(billNoFldKey, number, dynamicObject3)))) continue;
            logger.info(String.format("CodeRuleServiceImp.recycleNumber(): entityId: %s , dataInfo: %s ,  orgID: %s , number: %s ", entityNum, dynamicObject3 != null ? dynamicObject3.getPkValue() : null, null, number));
            this.codeRuleService.recycleNumber(codeRuleInfo, dynamicObject3, number);
        }
    }

    protected CodeRuleInfo checkCodeRule(String entityNum, List<CodeRuleInfo> codeRuleList, DynamicObject dynamicObject) {
        Long userOrgId = this.codeRuleServiceImp.getUserOrgId(dynamicObject, null);
        if (codeRuleList != null && !codeRuleList.isEmpty()) {
            CodeRuleInfo codeRuleInfo = this.codeRuleServiceImp.getUsableCodeRuleId(codeRuleList, entityNum, userOrgId, dynamicObject);
            if (codeRuleInfo != null) {
                codeRuleInfo.setEntityId(entityNum);
                codeRuleInfo.setOrgId(userOrgId.longValue());
            }
            return codeRuleInfo;
        }
        return null;
    }

    private boolean validateNumberInBusinessDB(String entityNum, String billNoFldKey, DynamicObject dynamicObject, String number) {
        boolean existBillNum = QueryServiceHelper.exists((String)entityNum, (QFilter[])this.getQFilterExistUniqueBillNo(billNoFldKey, number, dynamicObject));
        return !existBillNum;
    }

    private Set<String> validateNumbersInBusinessDB(String entityNum, String billNoFldKey, LinkedHashMap<String, DynamicObject> dynamicObjectMap) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityNum, (String)billNoFldKey, (QFilter[])this.getQFilterExistsUniqueBillNo(billNoFldKey, dynamicObjectMap));
        return Optional.ofNullable(dynamicObjectCollection).orElseGet(DynamicObjectCollection::new).stream().map(dynamicObject -> dynamicObject.getString(billNoFldKey)).collect(Collectors.toSet());
    }

    public void testJunit() {
    }
}

