/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.FaReStartRealBillCommAuditOp;
import kd.fi.fa.opplugin.restartrealbill.handlers.FaReStartRealBillAuditCopyFinCardHandler;
import kd.fi.fa.opplugin.restartrealbill.validators.FaReStartRealBillAuditValidator;

public class FaReStartRealBillAuditOp
extends FaReStartRealBillCommAuditOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaReStartRealBillAuditValidator());
    }

    @Override
    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject reStartRealBill : dataEntities) {
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)reStartRealBill, (String)"restartentity", (String)"realcard", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.RESTARTING);
            Long orgId = reStartRealBill.getLong("org.id");
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (mainAssetBookDynObj == null) {
                mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"id", "depreuse", "periodtype", "basecurrency", "curperiod"}));
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            Map<Object, Object> realId2BakIdMap = this.copyRealCard4Restart(reStartRealBill, "audit", mainAssetBookDynObj);
            DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg((Long)orgId);
            for (DynamicObject assetBook : assetBooks) {
                this.copyFinCard4Restart(assetBook, reStartRealBill, realId2BakIdMap);
            }
            DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
            for (DynamicObject reStartEntityDynObj : reStartEntity) {
                String restartType = reStartEntityDynObj.getString("restarttype");
                if (!"2".equals(restartType)) continue;
                Object bakRealId = realId2BakIdMap.get(reStartEntityDynObj.get("realcard.id"));
                reStartEntityDynObj.set("backrealcard", bakRealId);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reStartRealBill});
        }
    }

    private void createBillTracker(List<CreateBillTrackerModel> billTrackerModelList) {
        if (Objects.isNull(billTrackerModelList) || billTrackerModelList.isEmpty()) {
            return;
        }
        Long finCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_fin", (String)"fa_card_fin").getTableId();
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        Long restartRealBillTableId = EntityMetadataCache.loadTableDefine((String)"fa_restartrealbill", (String)"fa_restartrealbill").getTableId();
        Map<Long, Long> realCardId2FinCardId = this.getRealCardId2FinCardIdMap(billTrackerModelList);
        Date nowDate = new Date();
        ArrayList<Object[]> insertTrackerParams = new ArrayList<Object[]>(16);
        for (CreateBillTrackerModel createBillTrackerModel : billTrackerModelList) {
            Long billId = createBillTrackerModel.getBillId();
            Set<Long> realCardIdSet = createBillTrackerModel.getRealCardIdSet();
            for (Long realCardId : realCardIdSet) {
                insertTrackerParams.add(new Object[]{DB.genGlobalLongId(), realCardId, realCardTableId, billId, restartRealBillTableId, nowDate});
                Long finCardId = realCardId2FinCardId.get(realCardId);
                if (!Objects.nonNull(finCardId)) continue;
                insertTrackerParams.add(new Object[]{DB.genGlobalLongId(), finCardId, finCardTableId, billId, restartRealBillTableId, nowDate});
            }
        }
        String insertTrackerSql = "INSERT INTO t_botp_billtracker (fid, ftbillid, fttableid, fsbillid, fstableid, fcreatetime) VALUES(?, ?, ?, ?, ?, ?);";
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)insertTrackerSql, insertTrackerParams);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private Map<Long, Long> getRealCardId2FinCardIdMap(List<CreateBillTrackerModel> billTrackerModelList) {
        HashSet<Long> allRealCardIdSet = new HashSet<Long>(16);
        for (CreateBillTrackerModel createBillTrackerModel : billTrackerModelList) {
            Set<Long> realCardIdSet = createBillTrackerModel.getRealCardIdSet();
            allRealCardIdSet.addAll(realCardIdSet);
        }
        String selectChangeFields = Fa.comma((String[])new String[]{"id", "realcard"});
        DynamicObjectCollection dynObjCollection = QueryServiceHelper.query((String)"fa_card_fin", (String)selectChangeFields, (QFilter[])new QFilter[]{new QFilter("realcard", "in", allRealCardIdSet)});
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        if (dynObjCollection.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        for (DynamicObject dynObj : dynObjCollection) {
            long realCardId = dynObj.getLong("realcard");
            long finCardId = dynObj.getLong("id");
            resultMap.put(realCardId, finCardId);
        }
        return resultMap;
    }

    protected void copyFinCard4Restart(DynamicObject bookDynObj, DynamicObject reStartRealBill, Map<Object, Object> realCardMasterId2NewBackRealCardIdMap) {
        DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
        if (reStartEntity == null || reStartEntity.size() == 0) {
            return;
        }
        HashMap<Long, List<DynamicObject>> realCardMasterId2ReStartEntityDynObjListMap = new HashMap<Long, List<DynamicObject>>(reStartEntity.size());
        for (DynamicObject reStartEntityDynObj : reStartEntity) {
            Long longRealCardMasterId = reStartEntityDynObj.getLong(Fa.id((String)"realcard"));
            ArrayList<DynamicObject> dynObjList = (ArrayList<DynamicObject>)realCardMasterId2ReStartEntityDynObjListMap.get(longRealCardMasterId);
            if (Objects.isNull(dynObjList)) {
                dynObjList = new ArrayList<DynamicObject>(16);
                realCardMasterId2ReStartEntityDynObjListMap.put(longRealCardMasterId, dynObjList);
            }
            dynObjList.add(reStartEntityDynObj);
        }
        Long reStartPeriodId = bookDynObj.getLong("curperiod");
        Long depUseId = bookDynObj.getLong("depreuse");
        Set realCardMasterIdSet = realCardMasterId2ReStartEntityDynObjListMap.keySet();
        FaReStartRealBillAuditCopyFinCardHandler faReStartRealBillAuditCopyFinCardHandler = new FaReStartRealBillAuditCopyFinCardHandler(realCardMasterId2ReStartEntityDynObjListMap, "audit");
        FaFinCardDaoFactory.getInstance().copyFinCards(reStartPeriodId.longValue(), depUseId.longValue(), realCardMasterIdSet.toArray(), (IBizSetCardDataHandler)faReStartRealBillAuditCopyFinCardHandler, null, realCardMasterId2NewBackRealCardIdMap);
    }

    protected Map<Object, Object> copyRealCard4Restart(DynamicObject reStartRealBill, String operType, DynamicObject mainAssetBookDynObj) {
        DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
        if (reStartEntity == null || reStartEntity.size() == 0) {
            return null;
        }
        DynamicObject orgDynObj = reStartRealBill.getDynamicObject("org");
        Long orgId = orgDynObj.getLong("id");
        Long mainDepreUseId = mainAssetBookDynObj.getLong("depreuse");
        HashMap<Long, BigDecimal> realCapkClearCount = new HashMap<Long, BigDecimal>(reStartEntity.size());
        for (DynamicObject reStartEntityDynObj : reStartEntity) {
            String restartType = reStartEntityDynObj.getString("restarttype");
            Long realCardMasterId = reStartEntityDynObj.getLong(Fa.id((String)"realcard"));
            Long entryDepreUseId = reStartEntityDynObj.getLong(Fa.id((String)"entitydepreuse"));
            if (!"2".equals(restartType) || mainDepreUseId.longValue() != entryDepreUseId.longValue()) continue;
            BigDecimal restClearQty = (BigDecimal)realCapkClearCount.get(realCardMasterId);
            if (Objects.isNull(restClearQty)) {
                restClearQty = BigDecimal.ZERO;
            }
            restClearQty = restClearQty.add(reStartEntityDynObj.getBigDecimal("restclearqty"));
            realCapkClearCount.put(realCardMasterId, restClearQty);
        }
        if (realCapkClearCount.size() == 0) {
            return null;
        }
        Date restartDate = reStartRealBill.getDate("restartdate");
        Long billId = reStartRealBill.getLong("id");
        FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
        cardVersionParameter.setAccountdate(restartDate);
        cardVersionParameter.setSrcbillid(billId);
        cardVersionParameter.setSrcbillentityname("fa_restartrealbill");
        IBizSetCardDataHandler handler = this.getClearPartNumCardHandler(realCapkClearCount, operType);
        Map realId2BakIdMap = this.rCardDao.copyCards(realCapkClearCount.keySet().toArray(), handler, orgId, null, cardVersionParameter);
        return realId2BakIdMap;
    }

    static class CreateBillTrackerModel {
        private Long billId;
        private Set<Long> realCardIdSet;

        CreateBillTrackerModel() {
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public Set<Long> getRealCardIdSet() {
            return this.realCardIdSet;
        }

        public void setRealCardIdSet(Set<Long> realCardIdSet) {
            this.realCardIdSet = realCardIdSet;
        }
    }
}

