/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.depreciation.ClearValue;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.pclock.AbstractPcLockOperationServicePlugIn;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.validators.FaReStartRealBillSaveValidator;

public class FaReStartRealBillSaveOp
extends AbstractPcLockOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FaReStartRealBillSaveOp.class);
    private static final List<BizStatusEnum> fromBizStatusList = new ArrayList<BizStatusEnum>(2);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("restartdate");
        fieldKeys.add("org");
        fieldKeys.add("reason");
        fieldKeys.add("restartentity");
        fieldKeys.add("entitydepreuse");
        fieldKeys.add("assetqty");
        fieldKeys.add("clearbillid");
        fieldKeys.add("realcard");
        fieldKeys.add("clearbilldetailid");
        fieldKeys.add("restclearqty");
        fieldKeys.add("restassetvalue");
        fieldKeys.add("restaddupdepre");
        fieldKeys.add("restdecval");
        fieldKeys.add("restpreresidualval");
        fieldKeys.add("addeddepre");
        fieldKeys.add("addeddepreamount");
        fieldKeys.add("restarttype");
        fieldKeys.add("addchangemode");
        fieldKeys.add("restartperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaReStartRealBillSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        FaModiRealStatsUtils.saveUpdate_allBill_bizStatus((BeginOperationTransactionArgs)e, (String)"restartentity", (String)"realcard", (BizStatusEnum)BizStatusEnum.RESTARTING, fromBizStatusList);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_fa_restartrealbill");
        cacheManager.removeByDt();
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection restartEntity = bill.getDynamicObjectCollection("restartentity");
            Date reStartDate = bill.getDate("restartdate");
            DynamicObject orgDynObj = bill.getDynamicObject("org");
            Long orgId = orgDynObj.getLong("id");
            String orgName = orgDynObj.getString("name");
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (Objects.isNull(mainAssetBookDynObj) && Objects.nonNull(mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"id", "curperiod"})))) {
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            if (Objects.isNull(mainAssetBookDynObj)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaReStartRealBillAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), orgName));
            }
            Long curPeriodId = mainAssetBookDynObj.getLong("curperiod");
            bill.set("restartperiod", (Object)curPeriodId);
            Map<Long, CalcResultModel> clearDetailBaseId2CalcResultMap = this.getId2CalcResultModelMap(restartEntity, reStartDate, orgId);
            for (DynamicObject dynObj : restartEntity) {
                DynamicObject clearBillDetailDynObj = dynObj.getDynamicObject("clearbilldetailid");
                long clearBillEntryPk = clearBillDetailDynObj.getLong("entrysid");
                CalcResultModel calcResultModel = clearDetailBaseId2CalcResultMap.get(clearBillEntryPk);
                if (!Objects.nonNull(calcResultModel)) continue;
                dynObj.set("addeddepre", (Object)calcResultModel.getAddedAccumDepre());
                dynObj.set("addeddepreamount", (Object)calcResultModel.getReStartAddedDepredAmount());
            }
        }
    }

    protected void setPcLockCofig() {
        this.pcLockCofigBillNoList.add("FA_CLEARDETAIL_BASE_CONFIG_01");
    }

    private Map<Long, CalcResultModel> getId2CalcResultModelMap(DynamicObjectCollection restartEntity, Date reStartDate, Long orgId) {
        HashMap<Long, CalcResultModel> result = new HashMap<Long, CalcResultModel>(restartEntity.size());
        for (DynamicObject entityDynObj : restartEntity) {
            long depreUseId = entityDynObj.getLong("entitydepreuse.id");
            DynamicObject assetBook = FaBizUtils.getAsstBookByOrgAndDepreuse((Long)orgId, (Long)depreUseId, (String)"periodtype");
            long periodTypeId = assetBook.getLong("periodtype");
            DynamicObject reStartPeriod = PeriodUtil.getPeriodFullObjByDate((Date)reStartDate, (long)periodTypeId);
            long reStartPeriodId = reStartPeriod.getLong("id");
            Long reStartPreviousPeriodId = FaPeriodUtils.getPreviousPeriodId((Long)reStartPeriodId, (Long)periodTypeId);
            log.info("\u91cd\u542f\u5355\u8bb0\u8d26\u65e5\u671f\u6240\u5728\u671f\u95f4\u7684\u4e0a\u4e00\u4e2a\u671f\u95f4Id\uff1a{}", (Object)reStartPreviousPeriodId);
            DynamicObject clearBillDetailDynObj = entityDynObj.getDynamicObject("clearbilldetailid");
            Date clearBillEntryBizDate = clearBillDetailDynObj.getDate("bizdate");
            DynamicObject periodFullObjByDate = PeriodUtil.getPeriodFullObjByDate((Date)clearBillEntryBizDate, (long)periodTypeId);
            long clearBillEntryBizPeriodId = periodFullObjByDate.getLong("id");
            long realCardMasterId = clearBillDetailDynObj.getLong("realcardmasterid");
            long clearBillEntryPk = clearBillDetailDynObj.getLong("entrysid");
            ClearValue clearValue = new ClearValue();
            clearValue.setClearBillEntryPk(Long.valueOf(clearBillEntryPk));
            clearValue.setRealCardMasterId(Long.valueOf(realCardMasterId));
            clearValue.setClearAssetvalue(clearBillDetailDynObj.getBigDecimal("assetvalue"));
            clearValue.setClearAddupdepre(clearBillDetailDynObj.getBigDecimal("addupdepre"));
            clearValue.setClearDecval(clearBillDetailDynObj.getBigDecimal("decval"));
            clearValue.setClearPreresidualval(clearBillDetailDynObj.getBigDecimal("preresidualval"));
            clearValue.setClearDepredAmount(clearBillDetailDynObj.getBigDecimal("depredamount"));
            log.info("clearValue\uff1a{}", (Object)clearValue);
            HashMap<Long, ClearValue> realMasterId2ClrValueMap = new HashMap<Long, ClearValue>(1);
            realMasterId2ClrValueMap.put(realCardMasterId, clearValue);
            Map<Long, CalcResultModel> calcResultMap = this.depreClearValue2RestartBill(orgId, depreUseId, clearBillEntryBizPeriodId, reStartPreviousPeriodId, realMasterId2ClrValueMap);
            CalcResultModel calcResultModel = calcResultMap.get(realCardMasterId);
            result.put(clearBillEntryPk, calcResultModel);
            log.info("\u8865\u63d0\u7ed3\u679c\uff1a{}", result);
        }
        return result;
    }

    private Map<Long, CalcResultModel> calcAccumulatedDepreciation(Long reStartPreviousPeriodId, Map<Long, List<ClearValue>> clearBillEntryBizPeriodId2ClearValueListMap, Long orgId, Long depreUseId) {
        Set<Map.Entry<Long, List<ClearValue>>> entries = clearBillEntryBizPeriodId2ClearValueListMap.entrySet();
        HashMap<Long, CalcResultModel> calcResultMap = new HashMap<Long, CalcResultModel>(16);
        for (Map.Entry<Long, List<ClearValue>> map : entries) {
            Long clearBillEntryBizPeriodId = map.getKey();
            List<ClearValue> clearValueList = map.getValue();
            Map<Long, List<ClearValue>> realCardMasterId2ListMap = clearValueList.stream().collect(Collectors.groupingBy(ClearValue::getRealCardMasterId));
            HashMap<Long, ClearValue> realMasterId2ClrValueMap = new HashMap<Long, ClearValue>(16);
            for (Map.Entry<Long, List<ClearValue>> entryMap : realCardMasterId2ListMap.entrySet()) {
                Long realCardMasterId = entryMap.getKey();
                List<ClearValue> value = entryMap.getValue();
                if (value.size() == 1) {
                    realMasterId2ClrValueMap.put(realCardMasterId, value.get(0));
                    continue;
                }
                for (ClearValue clearValue3 : value) {
                    HashMap<Long, ClearValue> realMasterId2ClrValueMap2 = new HashMap<Long, ClearValue>(1);
                    realMasterId2ClrValueMap2.put(realCardMasterId, clearValue3);
                    Map<Long, CalcResultModel> realCardMasterId2ResultMap = this.depreClearValue2RestartBill(orgId, depreUseId, clearBillEntryBizPeriodId, reStartPreviousPeriodId, realMasterId2ClrValueMap2);
                    realMasterId2ClrValueMap2.forEach((realMasterId, clearValue2) -> {
                        Long clearBillEntryPk = clearValue2.getClearBillEntryPk();
                        CalcResultModel calcResultModel = (CalcResultModel)realCardMasterId2ResultMap.get(realMasterId);
                        if (Objects.nonNull(calcResultModel)) {
                            calcResultMap.put(clearBillEntryPk, calcResultModel);
                        }
                    });
                }
            }
            if (realMasterId2ClrValueMap.size() <= 0) continue;
            Map<Long, CalcResultModel> realCardMasterId2ResultMap = this.depreClearValue2RestartBill(orgId, depreUseId, clearBillEntryBizPeriodId, reStartPreviousPeriodId, realMasterId2ClrValueMap);
            realMasterId2ClrValueMap.forEach((realMasterId, clearValue) -> {
                Long clearBillEntryPk = clearValue.getClearBillEntryPk();
                CalcResultModel calcResultModel = (CalcResultModel)realCardMasterId2ResultMap.get(realMasterId);
                if (Objects.nonNull(calcResultModel)) {
                    calcResultMap.put(clearBillEntryPk, calcResultModel);
                }
            });
        }
        return calcResultMap;
    }

    private Map<Long, CalcResultModel> depreClearValue2RestartBill(long orgId, long depreUseId, Long clearBillEntryBizPeriodId, Long reStartPreviousPeriodId, Map<Long, ClearValue> realMasterId2ClrValueMap) {
        DailyDepreImpl dailyDepreImpl = new DailyDepreImpl();
        Map calcResultMap = dailyDepreImpl.depreClearValue2Restartbill((Object)orgId, Long.valueOf(depreUseId), clearBillEntryBizPeriodId, reStartPreviousPeriodId, realMasterId2ClrValueMap);
        HashMap<Long, CalcResultModel> result = new HashMap<Long, CalcResultModel>(calcResultMap.size());
        calcResultMap.forEach((realMasterId, resultMap) -> {
            BigDecimal addedAccumDepre = resultMap.getOrDefault("addedAccumDepre", BigDecimal.ZERO);
            BigDecimal reStartAddedDepredamount = resultMap.getOrDefault("reStartAddedDepredAmount", BigDecimal.ZERO);
            result.put((Long)realMasterId, new CalcResultModel(addedAccumDepre, reStartAddedDepredamount));
        });
        return result;
    }

    static {
        fromBizStatusList.add(BizStatusEnum.DELETE);
        fromBizStatusList.add(BizStatusEnum.READY);
    }

    static class CalcResultModel {
        private BigDecimal addedAccumDepre;
        private BigDecimal reStartAddedDepredAmount;

        public CalcResultModel(BigDecimal addedAccumDepre, BigDecimal depredAmount) {
            this.addedAccumDepre = addedAccumDepre;
            this.reStartAddedDepredAmount = depredAmount;
        }

        public BigDecimal getAddedAccumDepre() {
            return this.addedAccumDepre;
        }

        public void setAddedAccumDepre(BigDecimal addedAccumDepre) {
            this.addedAccumDepre = addedAccumDepre;
        }

        public BigDecimal getReStartAddedDepredAmount() {
            return this.reStartAddedDepredAmount;
        }

        public void setReStartAddedDepredAmount(BigDecimal reStartAddedDepredAmount) {
            this.reStartAddedDepredAmount = reStartAddedDepredAmount;
        }

        public String toString() {
            return "CalcResultModel{addedAccumDepre=" + this.addedAccumDepre + ", reStartAddedDepredAmount=" + this.reStartAddedDepredAmount + '}';
        }
    }
}

