/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.impl.FaFinCardDaoOrmImpl;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.restartrealbill.FaReStartRealBillCommAuditOp;
import kd.fi.fa.opplugin.restartrealbill.handlers.FaReStartRealBillAuditCopyFinCardHandler;
import kd.fi.fa.opplugin.restartrealbill.handlers.FaReStartRealUnAuditClearAllFinCardHandler;
import kd.fi.fa.opplugin.restartrealbill.validators.FaReStartRealBillUnAuditValidator;

public class FaReStartRealBillUnAuditOp
extends FaReStartRealBillCommAuditOp {
    private static final String[] SELECT_CARD_SELECTOR = new String[]{"clearperiod", "originalval", "monthorigvalchg", "yearorigvalchg", "monthdeprechg"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaReStartRealBillUnAuditValidator());
    }

    @Override
    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        ArrayList needToSaveRptMediateDynObjList = new ArrayList(16);
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject reStartRealBill : dataEntities) {
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)reStartRealBill, (String)"restartentity", (String)"realcard", (BizStatusEnum)BizStatusEnum.RESTARTING, (BizStatusEnum)BizStatusEnum.READY);
            Long orgId = reStartRealBill.getLong("org.id");
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (mainAssetBookDynObj == null) {
                mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"id", "depreuse", "periodtype", "basecurrency"}));
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            this.resetRealCard4Restart(reStartRealBill, "unaudit", mainAssetBookDynObj);
            DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg((Long)orgId);
            for (DynamicObject assetBook : assetBooks) {
                long periodId = assetBook.getLong("curperiod");
                Long depureId = assetBook.getLong("depreuse");
                DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
                HashMap<Long, List<DynamicObject>> realMasterId2ReStartEntityMap = new HashMap<Long, List<DynamicObject>>(reStartEntity.size());
                for (DynamicObject reStartEntityDynObj : reStartEntity) {
                    Long longRealCardMasterId = reStartEntityDynObj.getLong(Fa.id((String)"realcard"));
                    ArrayList<DynamicObject> dynObjList = (ArrayList<DynamicObject>)realMasterId2ReStartEntityMap.get(longRealCardMasterId);
                    if (Objects.isNull(dynObjList)) {
                        dynObjList = new ArrayList<DynamicObject>(16);
                        realMasterId2ReStartEntityMap.put(longRealCardMasterId, dynObjList);
                    }
                    dynObjList.add(reStartEntityDynObj);
                }
                Set realCardMasterIdSet = realMasterId2ReStartEntityMap.keySet();
                FaReStartRealBillAuditCopyFinCardHandler handler = new FaReStartRealBillAuditCopyFinCardHandler(realMasterId2ReStartEntityMap, "unaudit");
                FaFinCardDaoFactory.getInstance().restoreCard(periodId, depureId.longValue(), realCardMasterIdSet.toArray(), (IBizSetCardDataHandler)handler, SELECT_CARD_SELECTOR);
            }
            DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
            HashMap<String, HashSet<Long>> depureId2clealPeriodId2RealIdSet = new HashMap<String, HashSet<Long>>(8);
            for (DynamicObject reStartEntityObj : reStartEntity) {
                String restarttype = reStartEntityObj.getString("restarttype");
                Long clearallperiod = reStartEntityObj.getLong("clearallperiod.id");
                if (!restarttype.equals("1") || clearallperiod == 0L) continue;
                String depureId = reStartEntityObj.getString("entitydepreuse.id");
                String clealPeriodId = reStartEntityObj.getString("clearallperiod.id");
                String depreId2clealPeriodId = depureId + "_" + clealPeriodId;
                HashSet<Long> realIdSet = (HashSet<Long>)depureId2clealPeriodId2RealIdSet.get(depreId2clealPeriodId);
                if (realIdSet == null) {
                    realIdSet = new HashSet<Long>(100);
                    depureId2clealPeriodId2RealIdSet.put(depreId2clealPeriodId, realIdSet);
                }
                realIdSet.add(reStartEntityObj.getLong("realcard.id"));
            }
            if (depureId2clealPeriodId2RealIdSet.size() > 0) {
                for (Map.Entry depureId2clealPeriodId2RealIdSetObj : depureId2clealPeriodId2RealIdSet.entrySet()) {
                    String depureId2periodId = (String)depureId2clealPeriodId2RealIdSetObj.getKey();
                    Set realIdSet = (Set)depureId2clealPeriodId2RealIdSetObj.getValue();
                    String[] depureId2clealPeriodIdArr = depureId2periodId.split("_");
                    String depureIdStr = depureId2clealPeriodIdArr[0];
                    String clealPeriodIdStr = depureId2clealPeriodIdArr[1];
                    Long depureId = Long.parseLong(depureIdStr);
                    Long clealPeriodId = Long.parseLong(clealPeriodIdStr);
                    String fields = Fa.join((Object[])FaFinCardDaoOrmImpl.ID_REALCARD_BIZPERIOD, (String)",");
                    QFilter filter = new QFilter("realcardmasterid", "in", (Object)realIdSet);
                    filter.and(new QFilter("endperiod", ">", (Object)clealPeriodId));
                    if (depureId > 0L) {
                        filter.and(new QFilter("depreuse", "=", (Object)depureId));
                    }
                    DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)fields, (QFilter[])filter.toArray());
                    FaReStartRealUnAuditClearAllFinCardHandler handler = new FaReStartRealUnAuditClearAllFinCardHandler(clealPeriodId);
                    FaFinCardDaoFactory.getInstance().restoreCard(clealPeriodId.longValue(), depureId.longValue(), realIdSet.toArray(), (IBizSetCardDataHandler)handler, SELECT_CARD_SELECTOR);
                    new DepreSplitSum().deduct(finCards, true, false);
                }
            }
            for (DynamicObject reStartEntityDynObj : reStartEntity) {
                String restartType = reStartEntityDynObj.getString("restarttype");
                if (!"2".equals(restartType)) continue;
                reStartEntityDynObj.set("backrealcard", (Object)0L);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reStartRealBill});
        }
        SaveServiceHelper.save((DynamicObject[])needToSaveRptMediateDynObjList.toArray(new DynamicObject[0]));
    }

    private void deleteBillTracker(Set<Long> billIdSet) {
        if (Objects.isNull(billIdSet) || billIdSet.isEmpty()) {
            return;
        }
        Long restartRealBillTableId = EntityMetadataCache.loadTableDefine((String)"fa_restartrealbill", (String)"fa_restartrealbill").getTableId();
        ArrayList<Object[]> params = new ArrayList<Object[]>(billIdSet.size());
        for (Long billId : billIdSet) {
            params.add(new Object[]{billId, restartRealBillTableId});
        }
        try (TXHandle tx = TX.requiresNew();){
            String deleteSysBotp = "delete from t_botp_billtracker where fsbillid = ? and fstableid = ?;";
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)deleteSysBotp, params);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    protected void resetRealCard4Restart(DynamicObject reStartRealBill, String operType, DynamicObject mainAssetBookDynObj) {
        Long mainDepreUseId = mainAssetBookDynObj.getLong("depreuse");
        DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
        HashMap<Long, BigDecimal> realCapkClearCount = new HashMap<Long, BigDecimal>(reStartEntity.size());
        HashMap<Long, Long> bakIdAndNewIdMap = new HashMap<Long, Long>(200);
        for (DynamicObject reStartEntityDynObj : reStartEntity) {
            String restartType = reStartEntityDynObj.getString("restarttype");
            Long realCardMasterId = reStartEntityDynObj.getLong(Fa.id((String)"realcard"));
            Long entryDepreUseId = reStartEntityDynObj.getLong(Fa.id((String)"entitydepreuse"));
            if (!"2".equals(restartType) || mainDepreUseId.longValue() != entryDepreUseId.longValue()) continue;
            BigDecimal restClearQty = (BigDecimal)realCapkClearCount.get(realCardMasterId);
            if (Objects.isNull(restClearQty)) {
                restClearQty = BigDecimal.ZERO;
            }
            restClearQty = restClearQty.add(reStartEntityDynObj.getBigDecimal("restclearqty"));
            realCapkClearCount.put(realCardMasterId, restClearQty);
            Long bakRealCardId = reStartEntityDynObj.getLong("backrealcard_id");
            if (bakRealCardId == null || bakRealCardId == 0L) {
                bakIdAndNewIdMap.put(reStartEntityDynObj.getLong("realcard_id"), reStartEntityDynObj.getLong("realcard_id"));
                continue;
            }
            bakIdAndNewIdMap.put(reStartEntityDynObj.getLong("backrealcard_id"), reStartEntityDynObj.getLong("realcard_id"));
        }
        if (realCapkClearCount.size() == 0) {
            return;
        }
        Long billId = reStartRealBill.getLong("id");
        FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
        cardVersionParameter.setSrcbillid(billId);
        cardVersionParameter.setSrcbillentityname("fa_restartrealbill");
        IBizSetCardDataHandler handler = this.getClearPartNumCardHandler(realCapkClearCount, operType);
        this.rCardDao.restoreCards(realCapkClearCount.keySet().toArray(), bakIdAndNewIdMap, null, handler, null, cardVersionParameter);
    }
}

