/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill.handlers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.common.util.Fa;

public class FaReStartRealBillAuditCopyFinCardHandler
implements IBizSetCardDataHandler {
    private final Map<Long, List<DynamicObject>> realMasterId2ReStartEntityMap;
    private final String operType;

    public FaReStartRealBillAuditCopyFinCardHandler(Map<Long, List<DynamicObject>> realMasterId2ReStartEntityMap, String operType) {
        this.realMasterId2ReStartEntityMap = realMasterId2ReStartEntityMap;
        this.operType = operType;
    }

    public void handle(DynamicObject finCardDynObj) {
        if (Objects.isNull(this.realMasterId2ReStartEntityMap)) {
            return;
        }
        long realCardMasterId = finCardDynObj.getLong("realcardmasterid");
        List<Object> reStartEntityDynObjList = this.realMasterId2ReStartEntityMap.get(realCardMasterId);
        if (Objects.isNull(reStartEntityDynObjList) || reStartEntityDynObjList.size() == 0) {
            return;
        }
        DynamicObject finCardDepUseDynObj = finCardDynObj.getDynamicObject("depreuse");
        if (Objects.isNull(finCardDepUseDynObj)) {
            return;
        }
        long finCardDepUseId = finCardDepUseDynObj.getLong("id");
        if ((reStartEntityDynObjList = reStartEntityDynObjList.stream().filter(dynamicObject -> finCardDepUseId == dynamicObject.getLong(Fa.id((String)"entitydepreuse"))).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        BigDecimal totalRestAssetValue = BigDecimal.ZERO;
        BigDecimal totalAddUpDepre = BigDecimal.ZERO;
        BigDecimal totalRestDecVal = BigDecimal.ZERO;
        BigDecimal totalRestPreResidualVal = BigDecimal.ZERO;
        BigDecimal totalAddedDepre = BigDecimal.ZERO;
        BigDecimal totalAccumDepreChg = BigDecimal.ZERO;
        BigDecimal totalRestAssetValueChg = BigDecimal.ZERO;
        BigDecimal totalRestDecValChg = BigDecimal.ZERO;
        BigDecimal totalAddedDepreAmount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject2 : reStartEntityDynObjList) {
            String restarttype = dynamicObject2.getString("restarttype");
            long clearAllPeriod = dynamicObject2.getLong("clearallperiod.id");
            boolean isClearAll = false;
            if (restarttype.equals("1") && clearAllPeriod != 0L) {
                isClearAll = true;
            }
            if ("1".equals(restarttype)) {
                totalAddedDepreAmount = dynamicObject2.getBigDecimal("addeddepreamount");
            }
            BigDecimal restAssetValue = this.getBigDecimalOrDefault(dynamicObject2.getBigDecimal("restassetvalue"));
            BigDecimal restAddUpDepre = this.getBigDecimalOrDefault(dynamicObject2.getBigDecimal("restaddupdepre"));
            BigDecimal addedDepre = this.getBigDecimalOrDefault(dynamicObject2.getBigDecimal("addeddepre"));
            BigDecimal restDecVal = this.getBigDecimalOrDefault(dynamicObject2.getBigDecimal("restdecval"));
            BigDecimal restPreResidualVal = this.getBigDecimalOrDefault(dynamicObject2.getBigDecimal("restpreresidualval"));
            if (!isClearAll) {
                totalRestAssetValue = totalRestAssetValue.add(restAssetValue);
                totalAddUpDepre = totalAddUpDepre.add(restAddUpDepre).add(addedDepre);
                totalAddedDepre = totalAddedDepre.add(addedDepre);
                totalRestDecVal = totalRestDecVal.add(restDecVal);
                totalRestPreResidualVal = totalRestPreResidualVal.add(restPreResidualVal);
                totalAccumDepreChg = totalAccumDepreChg.add(restAddUpDepre);
                totalRestAssetValueChg = totalRestAssetValue;
                totalRestDecValChg = totalRestDecVal;
            } else {
                totalRestAssetValue = totalRestAssetValue.add(BigDecimal.ZERO);
                totalAddUpDepre = totalAddUpDepre.add(BigDecimal.ZERO).add(addedDepre);
                totalAddedDepre = totalAddedDepre.add(addedDepre);
                totalRestDecVal = totalRestDecVal.add(BigDecimal.ZERO);
                totalRestPreResidualVal = totalRestPreResidualVal.add(BigDecimal.ZERO);
                totalAccumDepreChg = totalAccumDepreChg.add(restAddUpDepre);
                totalRestAssetValueChg = totalRestAssetValueChg.add(restAssetValue);
                totalRestDecValChg = totalRestDecValChg.add(restDecVal);
            }
            if (!isClearAll || !"audit".equals(this.operType)) continue;
            finCardDynObj.set("clearperiod", (Object)0L);
        }
        this.sum(finCardDynObj, "addidepreamount", totalAddedDepreAmount, this.operType);
        this.sum(finCardDynObj, "depredamount", totalAddedDepreAmount, this.operType);
        this.sum(finCardDynObj, "originalval", totalRestAssetValue, this.operType);
        this.sum(finCardDynObj, "accumdepre", totalAddUpDepre, this.operType);
        this.sum(finCardDynObj, "decval", totalRestDecVal, this.operType);
        this.sum(finCardDynObj, "preresidualval", totalRestPreResidualVal, this.operType);
        this.sum(finCardDynObj, "addupyeardepre", totalAddedDepre, this.operType);
        this.sum(finCardDynObj, "monthdepre", totalAddedDepre, this.operType);
        this.sum(finCardDynObj, "monthorigvalchg", totalRestAssetValueChg, this.operType);
        this.sum(finCardDynObj, "yearorigvalchg", totalRestAssetValueChg, this.operType);
        this.sum(finCardDynObj, "monthdeprechg", totalRestDecValChg, this.operType);
        this.sum(finCardDynObj, "monthaccumdeprechg", totalAccumDepreChg, this.operType);
        this.sum(finCardDynObj, "restartaddeddepre", totalAddedDepre, this.operType);
        BigDecimal originValue = finCardDynObj.getBigDecimal("originalval");
        BigDecimal bigDecimal = finCardDynObj.getBigDecimal("accumdepre");
        BigDecimal netWorth = originValue.subtract(bigDecimal);
        finCardDynObj.set("networth", (Object)netWorth);
        BigDecimal decVal = finCardDynObj.getBigDecimal("decval");
        BigDecimal netAmount = netWorth.subtract(decVal);
        finCardDynObj.set("netamount", (Object)netAmount);
        finCardDynObj.set("isneeddepre", (Object)"1");
        finCardDynObj.set("restartdepreamount", (Object)totalAddedDepreAmount);
        if (finCardDynObj.getBigDecimal("originalval").compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal depreRate = finCardDynObj.getBigDecimal("monthdepre").divide(finCardDynObj.getBigDecimal("originalval"), 4, RoundingMode.HALF_UP);
            finCardDynObj.set("monthdeprerate", (Object)depreRate);
        }
    }

    private void sum(DynamicObject finCardDynObj, String propertyName, BigDecimal sumValue, String operType) {
        BigDecimal propertyValue = this.getBigDecimalOrDefault(finCardDynObj.getBigDecimal(propertyName));
        if ("audit".equals(operType)) {
            propertyValue = propertyValue.add(sumValue);
        } else if ("unaudit".equals(operType)) {
            propertyValue = propertyValue.subtract(sumValue);
        }
        finCardDynObj.set(propertyName, (Object)propertyValue);
    }

    private BigDecimal getBigDecimalOrDefault(BigDecimal bigDecimal) {
        if (Objects.isNull(bigDecimal)) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }
}

