/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill.validators;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.ClearBizStatus;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class FaReStartRealBillSaveValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            int entrySize = dataEntity.getDataEntity().getDynamicObjectCollection("restartentity").size();
            if (entrySize == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91cd\u542f\u5355\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaReStartRealBillSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            DynamicObject reStartRealBill = dataEntity.getDataEntity();
            DynamicObject orgDynObj = reStartRealBill.getDynamicObject("org");
            Long orgId = orgDynObj.getLong("id");
            String orgName = orgDynObj.getString("name");
            DynamicObject mainBook = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (Objects.isNull(mainBook) && Objects.nonNull(mainBook = FaBizUtils.getAsstBookByOrg((Long)orgId))) {
                orgId2MainBookMap.put(orgId, mainBook);
            }
            if (Objects.isNull(mainBook)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaReStartRealBillAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), orgName));
            }
            String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "restartdate");
            if (!bookNames.isEmpty()) {
                String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaReStartRealBillAuditValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format("%s:%s\u3002", msgCaption, bookNames));
            }
            this.checkCanRestartPartClearRealCard(reStartRealBill, dataEntity);
        }
    }

    private void checkCanRestartPartClearRealCard(DynamicObject reStartRealBill, ExtendedDataEntity dataEntity) {
        HashMap<Long, String> partClearRealCardId2NumberMap = new HashMap<Long, String>(16);
        DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
        Map<Long, Set<Date>> entityPartClearRealCardId2ClearBillBizDateSetMap = this.getEntityPartClearRealCardId2ClearBillBizDateSetMap(partClearRealCardId2NumberMap, reStartEntity);
        if (entityPartClearRealCardId2ClearBillBizDateSetMap.isEmpty()) {
            return;
        }
        Set<Long> partClearRealCardIdSet = entityPartClearRealCardId2ClearBillBizDateSetMap.keySet();
        Map<Long, Set<Date>> allPartClearRealCardId2ClearBillBizDateSetMap = this.getAllPartClearRealCardId2ClearBillBizDateSetMap(partClearRealCardIdSet);
        HashSet<String> numberSet = new HashSet<String>(16);
        for (Map.Entry<Long, Set<Date>> map : allPartClearRealCardId2ClearBillBizDateSetMap.entrySet()) {
            Long partClearRealCardId = map.getKey();
            Set<Date> clearBillBizDateSet = entityPartClearRealCardId2ClearBillBizDateSetMap.get(partClearRealCardId);
            if (Objects.isNull(clearBillBizDateSet) || clearBillBizDateSet.isEmpty()) continue;
            Date entityMinClearBillBizDate = clearBillBizDateSet.iterator().next();
            Set<Date> dateSet = map.getValue();
            TreeSet<Date> shouldAllReStartClearBillSet = new TreeSet<Date>(Date::compareTo);
            for (Date date : dateSet) {
                if (date.compareTo(entityMinClearBillBizDate) < 0) continue;
                shouldAllReStartClearBillSet.add(date);
            }
            shouldAllReStartClearBillSet.removeAll(clearBillBizDateSet);
            if (shouldAllReStartClearBillSet.isEmpty()) continue;
            String number = (String)partClearRealCardId2NumberMap.get(partClearRealCardId);
            numberSet.add(number);
        }
        if (numberSet.size() > 0) {
            String allNumber = String.join((CharSequence)"\uff0c", numberSet);
            String msgCaption = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u53ea\u80fd\u6309\u6e05\u7406\u5355\u8bb0\u8d26\u65e5\u671f\u5012\u5e8f\u4f9d\u6b21\u91cd\u542f\u3002", (String)"FaReStartRealBillSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(msgCaption, allNumber));
        }
    }

    private Map<Long, Set<Date>> getAllPartClearRealCardId2ClearBillBizDateSetMap(Set<Long> partClearRealCardIdSet) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("realcard.masterid", "in", partClearRealCardIdSet));
        qFilterList.add(new QFilter("bizstatus", "=", (Object)ClearBizStatus.READY));
        String selectFields = Fa.comma((String[])new String[]{"realcard.masterid", "bizdate"});
        DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)"fa_cleardetail_base", (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]));
        HashMap<Long, Set<Date>> map = new HashMap<Long, Set<Date>>(16);
        for (DynamicObject dynObj : dynObjColl) {
            long realCardId = dynObj.getLong("realcard.masterid");
            Date bizDate = dynObj.getDate("bizdate");
            TreeSet<Date> dateSet = (TreeSet<Date>)map.get(realCardId);
            if (Objects.isNull(dateSet)) {
                dateSet = new TreeSet<Date>(Date::compareTo);
            }
            dateSet.add(bizDate);
            map.put(realCardId, dateSet);
        }
        return map;
    }

    private Map<Long, Set<Date>> getEntityPartClearRealCardId2ClearBillBizDateSetMap(Map<Long, String> partClearRealCardId2NumberMap, DynamicObjectCollection reStartEntity) {
        HashMap<Long, Set<Date>> map = new HashMap<Long, Set<Date>>(reStartEntity.size());
        for (DynamicObject entityDynObj : reStartEntity) {
            DynamicObject realCardDyn = entityDynObj.getDynamicObject("realcard");
            Long realCardId = Long.parseLong(realCardDyn.getPkValue().toString());
            String realCardAssetNumber = realCardDyn.getString("number");
            partClearRealCardId2NumberMap.put(realCardId, realCardAssetNumber);
            Date clearBillBizDate = entityDynObj.getDynamicObject("clearbilldetailid").getDate("bizdate");
            TreeSet<Date> clearBillBizDateSet = (TreeSet<Date>)map.get(realCardId);
            if (Objects.isNull(clearBillBizDateSet)) {
                clearBillBizDateSet = new TreeSet<Date>(Date::compareTo);
            }
            clearBillBizDateSet.add(clearBillBizDate);
            map.put(realCardId, clearBillBizDateSet);
        }
        return map;
    }
}

